/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.lang.Nullable;
import io.micrometer.shaded.statsd.org.pcollections.HashTreePMap;
import io.micrometer.shaded.statsd.org.pcollections.PMap;
import io.micrometer.statsd.internal.FlavorStatsdLineBuilder;

public class EtsyStatsdLineBuilder
extends FlavorStatsdLineBuilder {
    private final HierarchicalNameMapper nameMapper;
    private volatile NamingConvention namingConvention;
    @Nullable
    private volatile String nameNoStat;
    private final Object namesLock = new Object();
    private volatile PMap<Statistic, String> names = HashTreePMap.empty();

    public EtsyStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config, HierarchicalNameMapper nameMapper) {
        super(id, config);
        this.nameMapper = nameMapper;
    }

    @Override
    String line(String amount, @Nullable Statistic stat, String type) {
        this.updateIfNamingConventionChanged();
        return this.nameByStatistic(stat) + ":" + amount + "|" + type;
    }

    private void updateIfNamingConventionChanged() {
        NamingConvention next = this.config.namingConvention();
        if (this.namingConvention != next) {
            this.namingConvention = next;
            this.names = HashTreePMap.empty();
            this.nameNoStat = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nameByStatistic(@Nullable Statistic stat) {
        if (stat == null) {
            if (this.nameNoStat == null) {
                this.nameNoStat = this.etsyName(null);
            }
            return this.nameNoStat;
        }
        String nameString = (String)this.names.get(stat);
        if (nameString != null) {
            return nameString;
        }
        Object object = this.namesLock;
        synchronized (object) {
            nameString = (String)this.names.get(stat);
            if (nameString != null) {
                return nameString;
            }
            nameString = this.etsyName(stat);
            this.names = this.names.plus(stat, nameString);
            return nameString;
        }
    }

    private String etsyName(@Nullable Statistic stat) {
        return this.nameMapper.toHierarchicalName(stat != null ? this.id.withTag(stat) : this.id, this.config.namingConvention()).replace(':', '_');
    }
}

