/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.Response;

import com.google.protobuf.ByteString;
import io.milvus.exception.IllegalResponseException;
import io.milvus.grpc.DataType;
import io.milvus.grpc.FieldData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class FieldDataWrapper {
    private final FieldData fieldData;

    public FieldDataWrapper(@NonNull FieldData fieldData) {
        if (fieldData == null) {
            throw new NullPointerException("fieldData is marked non-null but is null");
        }
        this.fieldData = fieldData;
    }

    public boolean isVectorField() {
        return this.fieldData.getType() == DataType.FloatVector || this.fieldData.getType() == DataType.BinaryVector;
    }

    public int getDim() throws IllegalResponseException {
        if (!this.isVectorField()) {
            throw new IllegalResponseException("Not a vector field");
        }
        return (int)this.fieldData.getVectors().getDim();
    }

    public long getRowCount() throws IllegalResponseException {
        DataType dt = this.fieldData.getType();
        switch (dt) {
            case FloatVector: {
                int dim = this.getDim();
                System.out.println(this.fieldData.getVectors().getFloatVector().getDataCount());
                List<Float> data = this.fieldData.getVectors().getFloatVector().getDataList();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned float vector field data array size doesn't match dimension");
                }
                return data.size() / dim;
            }
            case BinaryVector: {
                int dim = this.getDim();
                ByteString data = this.fieldData.getVectors().getBinaryVector();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned binary vector field data array size doesn't match dimension");
                }
                return data.size() / dim;
            }
            case Int64: {
                return this.fieldData.getScalars().getLongData().getDataList().size();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                return this.fieldData.getScalars().getIntData().getDataList().size();
            }
            case Bool: {
                return this.fieldData.getScalars().getBoolData().getDataList().size();
            }
            case Float: {
                return this.fieldData.getScalars().getFloatData().getDataList().size();
            }
            case Double: {
                return this.fieldData.getScalars().getDoubleData().getDataList().size();
            }
            case String: {
                return this.fieldData.getScalars().getStringData().getDataList().size();
            }
        }
        throw new IllegalResponseException("Unsupported data type returned by FieldData");
    }

    public List<?> getFieldData() throws IllegalResponseException {
        DataType dt = this.fieldData.getType();
        switch (dt) {
            case FloatVector: {
                int dim = this.getDim();
                System.out.println(this.fieldData.getVectors().getFloatVector().getDataCount());
                List<Float> data = this.fieldData.getVectors().getFloatVector().getDataList();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned float vector field data array size doesn't match dimension");
                }
                ArrayList<List<Float>> packData = new ArrayList<List<Float>>();
                int count = data.size() / dim;
                for (int i = 0; i < count; ++i) {
                    packData.add(data.subList(i * dim, (i + 1) * dim));
                }
                return packData;
            }
            case BinaryVector: {
                int dim = this.getDim();
                ByteString data = this.fieldData.getVectors().getBinaryVector();
                if (data.size() % dim != 0) {
                    throw new IllegalResponseException("Returned binary vector field data array size doesn't match dimension");
                }
                ArrayList<ByteBuffer> packData = new ArrayList<ByteBuffer>();
                int count = data.size() / dim;
                for (int i = 0; i < count; ++i) {
                    ByteBuffer bf = ByteBuffer.allocate(dim);
                    bf.put(data.substring(i * dim, (i + 1) * dim).toByteArray());
                    packData.add(bf);
                }
                return packData;
            }
            case Int64: {
                return this.fieldData.getScalars().getLongData().getDataList();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                return this.fieldData.getScalars().getIntData().getDataList();
            }
            case Bool: {
                return this.fieldData.getScalars().getBoolData().getDataList();
            }
            case Float: {
                return this.fieldData.getScalars().getFloatData().getDataList();
            }
            case Double: {
                return this.fieldData.getScalars().getDoubleData().getDataList();
            }
            case String: {
                return this.fieldData.getScalars().getStringData().getDataList();
            }
        }
        throw new IllegalResponseException("Unsupported data type returned by FieldData");
    }
}

