/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.Response;

import io.milvus.Response.FieldDataWrapper;
import io.milvus.exception.IllegalResponseException;
import io.milvus.exception.ParamException;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.IDs;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.SearchResultData;
import io.milvus.grpc.StringArray;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class SearchResultsWrapper {
    private final SearchResultData results;

    public SearchResultsWrapper(@NonNull SearchResultData results) {
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.results = results;
    }

    public List<?> getFieldData(@NonNull String fieldName, int indexOfTarget) {
        List<?> allData;
        long k;
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        FieldDataWrapper wrapper = null;
        for (int i = 0; i < this.results.getFieldsDataCount(); ++i) {
            FieldData data = this.results.getFieldsData(i);
            if (fieldName.compareTo(data.getFieldName()) != 0) continue;
            wrapper = new FieldDataWrapper(data);
        }
        if (wrapper == null) {
            throw new ParamException("Illegal field name: " + fieldName);
        }
        Position position = this.getOffsetByIndex(indexOfTarget);
        long offset = position.getOffset();
        if (offset + (k = position.getK()) > (long)(allData = wrapper.getFieldData()).size()) {
            throw new IllegalResponseException("Field data row count is wrong");
        }
        return allData.subList((int)offset, (int)offset + (int)k);
    }

    public List<IDScore> getIDScore(int indexOfTarget) throws ParamException, IllegalResponseException {
        long k;
        Position position = this.getOffsetByIndex(indexOfTarget);
        long offset = position.getOffset();
        if (offset + (k = position.getK()) > (long)this.results.getScoresCount()) {
            throw new IllegalResponseException("Result scores count is wrong");
        }
        ArrayList<IDScore> idScore = new ArrayList<IDScore>();
        IDs ids = this.results.getIds();
        if (ids.hasIntId()) {
            LongArray longIDs = ids.getIntId();
            if (offset + k > (long)longIDs.getDataCount()) {
                throw new IllegalResponseException("Result ids count is wrong");
            }
            int n = 0;
            while ((long)n < k) {
                idScore.add(new IDScore("", longIDs.getData((int)offset + n), this.results.getScores((int)offset + n)));
                ++n;
            }
        } else if (ids.hasStrId()) {
            StringArray strIDs = ids.getStrId();
            if (offset + k >= (long)strIDs.getDataCount()) {
                throw new IllegalResponseException("Result ids count is wrong");
            }
            int n = 0;
            while ((long)n < k) {
                idScore.add(new IDScore(strIDs.getData((int)offset + n), 0L, this.results.getScores((int)offset + n)));
                ++n;
            }
        } else {
            throw new IllegalResponseException("Result ids is illegal");
        }
        return idScore;
    }

    private Position getOffsetByIndex(int indexOfTarget) {
        List<Long> kList = this.results.getTopksList();
        if (kList.isEmpty()) {
            kList = new ArrayList<Long>();
            for (long i = 0L; i < this.results.getNumQueries(); ++i) {
                kList.add(this.results.getTopK());
            }
        }
        if (indexOfTarget < 0 || indexOfTarget >= kList.size()) {
            throw new ParamException("Illegal index of target: " + indexOfTarget);
        }
        long offset = 0L;
        for (int i = 0; i < indexOfTarget; ++i) {
            offset += kList.get(i).longValue();
        }
        long k = kList.get(indexOfTarget);
        return new Position(offset, k);
    }

    public static final class IDScore {
        private final String strID;
        private final long longID;
        private final float score;

        public IDScore(String strID, long longID, float score) {
            this.strID = strID;
            this.longID = longID;
            this.score = score;
        }

        public String toString() {
            if (this.strID.isEmpty()) {
                return "(ID: " + this.getLongID() + " Score: " + this.getScore() + ")";
            }
            return "(ID: '" + this.getStrID() + "' Score: " + this.getScore() + ")";
        }

        public String getStrID() {
            return this.strID;
        }

        public long getLongID() {
            return this.longID;
        }

        public float getScore() {
            return this.score;
        }
    }

    private static final class Position {
        private final long offset;
        private final long k;

        public Position(long offset, long k) {
            this.offset = offset;
            this.k = k;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getK() {
            return this.k;
        }
    }
}

