/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.control;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class GetMetricsParam {
    private final String request;

    private GetMetricsParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.request = builder.request;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "GetMetricsParam{request='" + this.request + '\'' + '}';
    }

    public String getRequest() {
        return this.request;
    }

    public static final class Builder {
        private String request;

        private Builder() {
        }

        public Builder withRequest(@NonNull String request) {
            if (request == null) {
                throw new NullPointerException("request is marked non-null but is null");
            }
            this.request = request;
            return this;
        }

        public GetMetricsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.request, "Request string");
            return new GetMetricsParam(this);
        }
    }
}

