/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.common.collect.Lists;
import io.milvus.exception.ParamException;
import io.milvus.param.MetricType;
import io.milvus.param.ParamUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class SearchParam {
    private final String collectionName;
    private final List<String> partitionNames;
    private final String metricType;
    private final String vectorFieldName;
    private final int topK;
    private final String expr;
    private final List<String> outFields;
    private final List<?> vectors;
    private final int roundDecimal;
    private final String params;

    private SearchParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.metricType = builder.metricType.name();
        this.vectorFieldName = builder.vectorFieldName;
        this.topK = builder.topK;
        this.expr = builder.expr;
        this.outFields = builder.outFields;
        this.vectors = builder.vectors;
        this.roundDecimal = builder.roundDecimal;
        this.params = builder.params;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "SearchParam{collectionName='" + this.collectionName + '\'' + ", partitionNames='" + this.partitionNames.toString() + '\'' + ", metricType=" + this.metricType + ", target vectors count=" + this.vectors.size() + ", vectorFieldName='" + this.vectorFieldName + '\'' + ", topK=" + this.topK + ", expr='" + this.expr + '\'' + ", params='" + this.params + '\'' + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public int getTopK() {
        return this.topK;
    }

    public String getExpr() {
        return this.expr;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public List<?> getVectors() {
        return this.vectors;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public String getParams() {
        return this.params;
    }

    public static class Builder {
        private String collectionName;
        private final List<String> partitionNames = Lists.newArrayList();
        private MetricType metricType = MetricType.L2;
        private String vectorFieldName;
        private Integer topK;
        private String expr = "";
        private List<String> outFields = new ArrayList<String>();
        private List<?> vectors;
        private Integer roundDecimal = -1;
        private String params = "{}";

        Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionNames(@NonNull List<String> partitionNames) {
            if (partitionNames == null) {
                throw new NullPointerException("partitionNames is marked non-null but is null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder addPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public Builder withMetricType(@NonNull MetricType metricType) {
            if (metricType == null) {
                throw new NullPointerException("metricType is marked non-null but is null");
            }
            this.metricType = metricType;
            return this;
        }

        public Builder withVectorFieldName(@NonNull String vectorFieldName) {
            if (vectorFieldName == null) {
                throw new NullPointerException("vectorFieldName is marked non-null but is null");
            }
            this.vectorFieldName = vectorFieldName;
            return this;
        }

        public Builder withTopK(@NonNull Integer topK) {
            if (topK == null) {
                throw new NullPointerException("topK is marked non-null but is null");
            }
            this.topK = topK;
            return this;
        }

        public Builder withExpr(@NonNull String expr) {
            if (expr == null) {
                throw new NullPointerException("expr is marked non-null but is null");
            }
            this.expr = expr;
            return this;
        }

        public Builder withOutFields(@NonNull List<String> outFields) {
            if (outFields == null) {
                throw new NullPointerException("outFields is marked non-null but is null");
            }
            this.outFields = outFields;
            return this;
        }

        public Builder addOutField(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            if (!this.outFields.contains(fieldName)) {
                this.outFields.add(fieldName);
            }
            return this;
        }

        public Builder withVectors(@NonNull List<?> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            return this;
        }

        public Builder withRoundDecimal(@NonNull Integer decimal) {
            if (decimal == null) {
                throw new NullPointerException("decimal is marked non-null but is null");
            }
            this.roundDecimal = decimal;
            return this;
        }

        public Builder withParams(@NonNull String params) {
            if (params == null) {
                throw new NullPointerException("params is marked non-null but is null");
            }
            this.params = params;
            return this;
        }

        public SearchParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.vectorFieldName, "Target field name");
            if (this.topK <= 0) {
                throw new ParamException("TopK value is illegal");
            }
            if (this.metricType == MetricType.INVALID) {
                throw new ParamException("Metric type is illegal");
            }
            if (this.vectors == null || this.vectors.isEmpty()) {
                throw new ParamException("Target vectors can not be empty");
            }
            if (this.vectors.get(0) instanceof List) {
                List first = (List)this.vectors.get(0);
                if (!(first.get(0) instanceof Float)) {
                    throw new ParamException("Float vector field's value must be Lst<Float>");
                }
                int dim = first.size();
                for (int i = 1; i < this.vectors.size(); ++i) {
                    List temp = (List)this.vectors.get(i);
                    if (dim == temp.size()) continue;
                    throw new ParamException("Target vector dimension must be equal");
                }
            } else if (this.vectors.get(0) instanceof ByteBuffer) {
                ByteBuffer first = (ByteBuffer)this.vectors.get(0);
                int dim = first.position();
                for (int i = 1; i < this.vectors.size(); ++i) {
                    ByteBuffer temp = (ByteBuffer)this.vectors.get(i);
                    if (dim == temp.position()) continue;
                    throw new ParamException("Target vector dimension must be equal");
                }
            } else {
                throw new ParamException("Target vector type must be Lst<Float> or ByteBuffer");
            }
            return new SearchParam(this);
        }
    }
}

