/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.index;

import io.milvus.exception.ParamException;
import io.milvus.param.Constant;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class CreateIndexParam {
    private final String collectionName;
    private final String fieldName;
    private final Map<String, String> extraParam = new HashMap<String, String>();
    private final boolean syncMode;
    private final long syncWaitingInterval;
    private final long syncWaitingTimeout;

    private CreateIndexParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.fieldName = builder.fieldName;
        this.extraParam.put("index_type", builder.indexType.name());
        this.extraParam.put("metric_type", builder.metricType.name());
        this.extraParam.put("params", builder.extraParam);
        this.syncMode = builder.syncMode;
        this.syncWaitingInterval = builder.syncWaitingInterval;
        this.syncWaitingTimeout = builder.syncWaitingTimeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "CreateIndexParam{collectionName='" + this.collectionName + '\'' + ", fieldName='" + this.fieldName + '\'' + ", params='" + this.extraParam.toString() + '\'' + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Map<String, String> getExtraParam() {
        return this.extraParam;
    }

    public boolean isSyncMode() {
        return this.syncMode;
    }

    public long getSyncWaitingInterval() {
        return this.syncWaitingInterval;
    }

    public long getSyncWaitingTimeout() {
        return this.syncWaitingTimeout;
    }

    public static final class Builder {
        private String collectionName;
        private String fieldName;
        private IndexType indexType;
        private MetricType metricType;
        private String extraParam;
        private Boolean syncMode = Boolean.TRUE;
        private Long syncWaitingInterval = 500L;
        private Long syncWaitingTimeout = 600L;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withFieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this;
        }

        public Builder withIndexType(@NonNull IndexType indexType) {
            if (indexType == null) {
                throw new NullPointerException("indexType is marked non-null but is null");
            }
            this.indexType = indexType;
            return this;
        }

        public Builder withMetricType(@NonNull MetricType metricType) {
            if (metricType == null) {
                throw new NullPointerException("metricType is marked non-null but is null");
            }
            this.metricType = metricType;
            return this;
        }

        public Builder withExtraParam(@NonNull String extraParam) {
            if (extraParam == null) {
                throw new NullPointerException("extraParam is marked non-null but is null");
            }
            this.extraParam = extraParam;
            return this;
        }

        public Builder withSyncMode(@NonNull Boolean syncMode) {
            if (syncMode == null) {
                throw new NullPointerException("syncMode is marked non-null but is null");
            }
            this.syncMode = syncMode;
            return this;
        }

        public Builder withSyncWaitingInterval(@NonNull Long milliseconds) {
            if (milliseconds == null) {
                throw new NullPointerException("milliseconds is marked non-null but is null");
            }
            this.syncWaitingInterval = milliseconds;
            return this;
        }

        public Builder withSyncWaitingTimeout(@NonNull Long seconds) {
            if (seconds == null) {
                throw new NullPointerException("seconds is marked non-null but is null");
            }
            this.syncWaitingTimeout = seconds;
            return this;
        }

        public CreateIndexParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.fieldName, "Field name");
            if (this.indexType == IndexType.INVALID) {
                throw new ParamException("Index type is required");
            }
            if (this.metricType == MetricType.INVALID) {
                throw new ParamException("Metric type is required");
            }
            if (this.syncMode == Boolean.TRUE) {
                if (this.syncWaitingInterval <= 0L) {
                    throw new ParamException("Sync index waiting interval must be larger than zero");
                }
                if (this.syncWaitingInterval > Constant.MAX_WAITING_INDEX_INTERVAL) {
                    throw new ParamException("Sync index waiting interval cannot be larger than " + Constant.MAX_WAITING_INDEX_INTERVAL.toString() + " milliseconds");
                }
                if (this.syncWaitingTimeout <= 0L) {
                    throw new ParamException("Sync index waiting timeout must be larger than zero");
                }
            }
            ParamUtils.CheckNullEmptyString(this.extraParam, "Index extra param");
            return new CreateIndexParam(this);
        }
    }
}

