/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.index;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class DescribeIndexParam {
    private final String collectionName;
    private final String fieldName;

    private DescribeIndexParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.fieldName = builder.fieldName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "DescribeIndexParam{collectionName='" + this.collectionName + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public static final class Builder {
        private String collectionName;
        private String fieldName;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withFieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this;
        }

        public DescribeIndexParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.fieldName, "Field name");
            return new DescribeIndexParam(this);
        }
    }
}

