/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.partition;

import io.milvus.exception.ParamException;
import io.milvus.param.Constant;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class LoadPartitionsParam {
    private final String collectionName;
    private final List<String> partitionNames;
    private final boolean syncLoad;
    private final long syncLoadWaitingInterval;
    private final long syncLoadWaitingTimeout;

    private LoadPartitionsParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.syncLoad = builder.syncLoad;
        this.syncLoadWaitingInterval = builder.syncLoadWaitingInterval;
        this.syncLoadWaitingTimeout = builder.syncLoadWaitingTimeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "LoadPartitionsParam{collectionName='" + this.collectionName + '\'' + ", partitionName='" + this.partitionNames.toString() + '\'' + ", syncLoad=" + this.syncLoad + ", syncLoadWaitingInterval=" + this.syncLoadWaitingInterval + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public boolean isSyncLoad() {
        return this.syncLoad;
    }

    public long getSyncLoadWaitingInterval() {
        return this.syncLoadWaitingInterval;
    }

    public long getSyncLoadWaitingTimeout() {
        return this.syncLoadWaitingTimeout;
    }

    public static final class Builder {
        private String collectionName;
        private final List<String> partitionNames = new ArrayList<String>();
        private Boolean syncLoad = Boolean.TRUE;
        private Long syncLoadWaitingInterval = 500L;
        private Long syncLoadWaitingTimeout = 60L;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionNames(@NonNull List<String> partitionNames) {
            if (partitionNames == null) {
                throw new NullPointerException("partitionNames is marked non-null but is null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder addPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public Builder withSyncLoad(@NonNull Boolean syncLoad) {
            if (syncLoad == null) {
                throw new NullPointerException("syncLoad is marked non-null but is null");
            }
            this.syncLoad = syncLoad;
            return this;
        }

        public Builder withSyncLoadWaitingInterval(@NonNull Long milliseconds) {
            if (milliseconds == null) {
                throw new NullPointerException("milliseconds is marked non-null but is null");
            }
            this.syncLoadWaitingInterval = milliseconds;
            return this;
        }

        public Builder withSyncLoadWaitingTimeout(@NonNull Long seconds) {
            if (seconds == null) {
                throw new NullPointerException("seconds is marked non-null but is null");
            }
            this.syncLoadWaitingTimeout = seconds;
            return this;
        }

        public LoadPartitionsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.partitionNames.isEmpty()) {
                throw new ParamException("Partition names cannot be empty");
            }
            for (String name : this.partitionNames) {
                ParamUtils.CheckNullEmptyString(name, "Partition name");
            }
            if (this.syncLoad == Boolean.TRUE) {
                if (this.syncLoadWaitingInterval <= 0L) {
                    throw new ParamException("Sync load waiting interval must be larger than zero");
                }
                if (this.syncLoadWaitingInterval > Constant.MAX_WAITING_LOADING_INTERVAL) {
                    throw new ParamException("Sync load waiting interval cannot be larger than " + Constant.MAX_WAITING_LOADING_INTERVAL.toString() + " milliseconds");
                }
                if (this.syncLoadWaitingTimeout <= 0L) {
                    throw new ParamException("Sync load waiting interval must be larger than zero");
                }
                if (this.syncLoadWaitingTimeout > Constant.MAX_WAITING_LOADING_TIMEOUT) {
                    throw new ParamException("Sync load waiting interval cannot be larger than " + Constant.MAX_WAITING_LOADING_TIMEOUT.toString() + " seconds");
                }
            }
            return new LoadPartitionsParam(this);
        }
    }
}

