/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.unsigned_indices_model;

import com.google.protobuf.Struct;
import io.pinecone.proto.ScoredVector;
import io.pinecone.unsigned_indices_model.SparseValuesWithUnsignedIndices;
import java.util.Collections;
import java.util.List;

public class ScoredVectorWithUnsignedIndices {
    private float score;
    private String id;
    private List<Float> values;
    private Struct metadata;
    private SparseValuesWithUnsignedIndices sparseValuesWithUnsignedIndices;

    public ScoredVectorWithUnsignedIndices(ScoredVector scoredVector) {
        if (scoredVector == null) {
            this.score = 0.0f;
            this.id = "";
            this.values = Collections.emptyList();
            this.metadata = Struct.newBuilder().build();
            this.sparseValuesWithUnsignedIndices = new SparseValuesWithUnsignedIndices();
        } else {
            this.score = scoredVector.getScore();
            this.id = scoredVector.getId();
            this.values = scoredVector.getValuesList();
            this.metadata = scoredVector.getMetadata();
            this.sparseValuesWithUnsignedIndices = new SparseValuesWithUnsignedIndices(scoredVector.getSparseValues());
        }
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Float> getValuesList() {
        return this.values;
    }

    public void setValues(List<Float> values) {
        this.values = values;
    }

    public Struct getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Struct metadata) {
        this.metadata = metadata;
    }

    public SparseValuesWithUnsignedIndices getSparseValuesWithUnsignedIndices() {
        return this.sparseValuesWithUnsignedIndices;
    }

    public void setSparseValuesWithUnsignedIndices(SparseValuesWithUnsignedIndices sparseValuesWithUnsignedIndices) {
        this.sparseValuesWithUnsignedIndices = sparseValuesWithUnsignedIndices;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ScoredVectorWithUnsignedIndices {").append("\n");
        sb.append("    score: ").append(this.toIndentedString(Float.valueOf(this.score))).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    sparseValuesWithUnsignedIndices: ").append(this.toIndentedString(this.sparseValuesWithUnsignedIndices)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

