/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.spring.boot;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="endpoints.prometheus")
class PrometheusEndpoint
extends AbstractEndpoint<String> {
    private final CollectorRegistry collectorRegistry;

    PrometheusEndpoint(CollectorRegistry collectorRegistry) {
        super("prometheus");
        this.collectorRegistry = collectorRegistry;
    }

    public String invoke() {
        return this.writeRegistry(Collections.<String>emptySet(), "");
    }

    public String writeRegistry(Set<String> metricsToInclude, String contentType) {
        try {
            StringWriter writer = new StringWriter();
            TextFormat.writeFormat((String)contentType, (Writer)writer, (Enumeration)this.collectorRegistry.filteredMetricFamilySamples(metricsToInclude));
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing metrics failed", e);
        }
    }
}

