/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.pom;

import io.spring.gradle.dependencymanagement.internal.pom.Coordinates;
import java.util.Collections;
import java.util.Set;

public final class Dependency {
    private final Coordinates coordinates;
    private final boolean optional;
    private final String type;
    private final String classifier;
    private final String scope;
    private final Set<String> exclusions;

    public Dependency(Coordinates coordinates, Set<String> exclusions) {
        this(coordinates, false, null, null, null, exclusions);
    }

    public Dependency(Coordinates coordinates, boolean optional, String type, String classifier, String scope, Set<String> exclusions) {
        this.coordinates = coordinates;
        this.optional = optional;
        this.type = type == null ? "jar" : type;
        this.classifier = classifier;
        this.scope = scope;
        this.exclusions = exclusions == null ? Collections.emptySet() : exclusions;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public Set<String> getExclusions() {
        return this.exclusions;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isOptional() {
        return this.optional;
    }
}

