/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;

public class SpringCatchCheck
extends AbstractSpringCheck {
    public int[] getAcceptableTokens() {
        return new int[]{96};
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 96) {
            this.visitCatch(ast);
        }
    }

    private void visitCatch(DetailAST ast) {
        DetailAST child;
        for (child = ast.getFirstChild(); child != null && child.getType() != 21; child = child.getNextSibling()) {
        }
        if (child != null) {
            this.visitParameterDef(child);
        }
    }

    private void visitParameterDef(DetailAST ast) {
        DetailAST lastChild = ast.getLastChild();
        if (lastChild != null && lastChild.getType() == 58) {
            this.checkIdent(lastChild);
        }
    }

    private void checkIdent(DetailAST ast) {
        String text = ast.getText();
        if (text.length() == 1) {
            this.log(ast.getLineNo(), ast.getColumnNo(), "catch.singleLetter", new Object[0]);
        }
    }
}

