/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SpringNoThisCheck
extends AbstractSpringCheck {
    private Set<String> names = Collections.emptySet();
    private boolean allowAssignement = true;

    public int[] getAcceptableTokens() {
        return new int[]{58};
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 58) {
            this.visitIdent(ast);
        }
    }

    private void visitIdent(DetailAST ast) {
        DetailAST sibling;
        String name = ast.getText();
        if (this.names.contains(name) && (sibling = ast.getPreviousSibling()) != null && sibling.getType() == 78) {
            DetailAST parent = this.getFirstNonDotParent(ast);
            if (!this.allowAssignement || parent == null || parent.getType() != 80) {
                this.log(ast.getLineNo(), ast.getColumnNo(), "nothis.unexpected", new Object[]{name});
            }
        }
    }

    private DetailAST getFirstNonDotParent(DetailAST ast) {
        DetailAST result;
        DetailAST detailAST = result = ast != null ? ast.getParent() : null;
        while (result != null && result.getType() == 59) {
            result = result.getParent();
        }
        return result;
    }

    public void setNames(String ... names) {
        this.names = new HashSet<String>(Arrays.asList(names));
    }

    public void setAllowAssignement(boolean allowAssignement) {
        this.allowAssignement = allowAssignement;
    }
}

