/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;

public class MetricsClientMeters {
    private Meter.MeterProvider<Counter> attemptCounter;
    private Meter.MeterProvider<DistributionSummary> sentMessageSizeDistribution;
    private Meter.MeterProvider<DistributionSummary> receivedMessageSizeDistribution;
    private Meter.MeterProvider<Timer> clientAttemptDuration;
    private Meter.MeterProvider<Timer> clientCallDuration;

    private MetricsClientMeters(Builder builder) {
        this.attemptCounter = builder.attemptCounter;
        this.sentMessageSizeDistribution = builder.sentMessageSizeDistribution;
        this.receivedMessageSizeDistribution = builder.receivedMessageSizeDistribution;
        this.clientAttemptDuration = builder.clientAttemptDuration;
        this.clientCallDuration = builder.clientCallDuration;
    }

    public Meter.MeterProvider<Counter> getAttemptCounter() {
        return this.attemptCounter;
    }

    public Meter.MeterProvider<DistributionSummary> getSentMessageSizeDistribution() {
        return this.sentMessageSizeDistribution;
    }

    public Meter.MeterProvider<DistributionSummary> getReceivedMessageSizeDistribution() {
        return this.receivedMessageSizeDistribution;
    }

    public Meter.MeterProvider<Timer> getClientAttemptDuration() {
        return this.clientAttemptDuration;
    }

    public Meter.MeterProvider<Timer> getClientCallDuration() {
        return this.clientCallDuration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        private Meter.MeterProvider<Counter> attemptCounter;
        private Meter.MeterProvider<DistributionSummary> sentMessageSizeDistribution;
        private Meter.MeterProvider<DistributionSummary> receivedMessageSizeDistribution;
        private Meter.MeterProvider<Timer> clientAttemptDuration;
        private Meter.MeterProvider<Timer> clientCallDuration;

        private Builder() {
        }

        public Builder setAttemptCounter(Meter.MeterProvider<Counter> counter) {
            this.attemptCounter = counter;
            return this;
        }

        public Builder setSentMessageSizeDistribution(Meter.MeterProvider<DistributionSummary> distribution) {
            this.sentMessageSizeDistribution = distribution;
            return this;
        }

        public Builder setReceivedMessageSizeDistribution(Meter.MeterProvider<DistributionSummary> distribution) {
            this.receivedMessageSizeDistribution = distribution;
            return this;
        }

        public Builder setClientAttemptDuration(Meter.MeterProvider<Timer> timer) {
            this.clientAttemptDuration = timer;
            return this;
        }

        public Builder setClientCallDuration(Meter.MeterProvider<Timer> timer) {
            this.clientCallDuration = timer;
            return this;
        }

        public MetricsClientMeters build() {
            return new MetricsClientMeters(this);
        }
    }
}

