/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.hibernate3;

import java.util.Map;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheObject;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class J2HibernateCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(J2HibernateCache.class);
    private String region;
    private CacheChannel cache;

    public J2HibernateCache(String region, CacheChannel cache) {
        this.region = region;
        this.cache = cache;
    }

    public void clear() throws CacheException {
        this.cache.clear(this.region);
    }

    public void destroy() throws CacheException {
        this.cache.close();
    }

    public Object get(Object key) throws CacheException {
        CacheObject cobj = this.cache.get(this.region, key.toString(), new boolean[0]);
        if (log.isDebugEnabled()) {
            log.debug("get value for j2cache which key:" + key + ",value:" + cobj.getValue());
        }
        return cobj.getValue();
    }

    public long getElementCountInMemory() {
        return this.cache.keys(this.region).size();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public String getRegionName() {
        return this.region;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public int getTimeout() {
        return 0;
    }

    public void lock(Object key) {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void put(Object key, Object value) {
        this.cache.set(this.region, key.toString(), value);
    }

    public Object read(Object key) throws CacheException {
        return this.get(key);
    }

    public void remove(Object key) throws CacheException {
        this.cache.evict(this.region, new String[]{key.toString()});
    }

    public Map toMap() {
        throw new UnsupportedOperationException("j2cache not support region to map");
    }

    public void unlock(Object key) throws CacheException {
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }
}

