/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.NotFoundException;
import net.roseboy.classfinal.Const;
import net.roseboy.classfinal.CoreAgent;
import net.roseboy.classfinal.util.ClassUtils;
import net.roseboy.classfinal.util.EncryptUtils;
import net.roseboy.classfinal.util.IoUtils;
import net.roseboy.classfinal.util.JarUtils;
import net.roseboy.classfinal.util.Log;
import net.roseboy.classfinal.util.StrUtils;

public class JarEncryptor {
    static Map<String, String> aopMap = new HashMap<String, String>();
    private String jarPath = null;
    private List<String> packages = null;
    private List<String> includeJars = null;
    private List<String> excludeClass = null;
    private List<String> classPath = null;
    private List<String> cfgfiles = null;
    private char[] password = null;
    private char[] code = null;
    private String jarOrWar = null;
    private File targetDir = null;
    private File targetLibDir = null;
    private File targetClassesDir = null;
    private Integer encryptFileCount = null;
    private Map<String, String> resolveClassName = new HashMap<String, String>();

    public JarEncryptor(String jarPath, char[] password) {
        this.jarPath = jarPath;
        this.password = password;
    }

    public String doEncryptJar() {
        if (!this.jarPath.endsWith(".jar") && !this.jarPath.endsWith(".war")) {
            throw new RuntimeException("jar/war\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        if (!new File(this.jarPath).exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728:" + this.jarPath);
        }
        if (this.password == null || this.password.length == 0) {
            throw new RuntimeException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.password.length == 1 && this.password[0] == '#') {
            Log.debug("\u52a0\u5bc6\u6a21\u5f0f\uff1a\u65e0\u5bc6\u7801");
        }
        Log.debug("\u673a\u5668\u7ed1\u5b9a\uff1a" + (StrUtils.isEmpty(this.code) ? "\u5426" : "\u662f"));
        this.jarOrWar = this.jarPath.substring(this.jarPath.lastIndexOf(".") + 1);
        Log.debug("\u52a0\u5bc6\u7c7b\u578b\uff1a" + this.jarOrWar);
        this.targetDir = new File(this.jarPath.replace("." + this.jarOrWar, "__temp__"));
        this.targetLibDir = new File(this.targetDir, ("jar".equals(this.jarOrWar) ? "BOOT-INF" : "WEB-INF") + File.separator + "lib");
        this.targetClassesDir = new File(this.targetDir, ("jar".equals(this.jarOrWar) ? "BOOT-INF" : "WEB-INF") + File.separator + "classes");
        Log.debug("\u4e34\u65f6\u76ee\u5f55\uff1a" + this.targetDir);
        List<String> allFile = JarUtils.unJar(this.jarPath, this.targetDir.getAbsolutePath(), this.includeJars);
        allFile.forEach(s -> Log.debug("\u91ca\u653e\uff1a" + s));
        List<File> classFiles = this.filterClasses(allFile);
        this.addClassFinalAgent();
        List<String> encryptClass = this.encryptClass(classFiles);
        this.encryptFileCount = encryptClass.size();
        this.clearClassMethod(classFiles);
        this.encryptConfigFile();
        String result = this.packageJar();
        return result;
    }

    public List<File> filterClasses(List<String> allFile) {
        ArrayList<File> classFiles = new ArrayList<File>();
        allFile.forEach(file -> {
            if (!file.endsWith(".class")) {
                return;
            }
            String className = this.resolveClassName((String)file, true);
            if (ClassUtils.isPackage(this.packages, className) && !ClassUtils.isClass(this.excludeClass, className)) {
                classFiles.add(new File((String)file));
                Log.debug("\u5f85\u52a0\u5bc6: " + file);
            }
        });
        return classFiles;
    }

    private List<String> encryptClass(List<File> classFiles) {
        ArrayList<String> encryptClasses = new ArrayList<String>();
        File metaDir = new File(this.targetDir, "META-INF" + File.separator + ".classes");
        if (!metaDir.exists()) {
            metaDir.mkdirs();
        }
        if (this.password.length == 1 && this.password[0] == '#') {
            char[] randChars = EncryptUtils.randChar(32);
            this.password = EncryptUtils.md5(randChars);
            File configPass = new File(metaDir, "org.springframework.config.Pass");
            IoUtils.writeFile(configPass, StrUtils.toBytes(randChars));
        }
        if (StrUtils.isNotEmpty(this.code)) {
            File configCode = new File(metaDir, "org.springframework.config.Code");
            IoUtils.writeFile(configCode, StrUtils.toBytes(EncryptUtils.md5(this.code)));
        }
        classFiles.forEach(classFile -> {
            String className = classFile.getName();
            if (className.endsWith(".class")) {
                className = this.resolveClassName(classFile.getAbsolutePath(), true);
            }
            byte[] bytes = IoUtils.readFileToByte(classFile);
            char[] pass = StrUtils.merger(this.password, className.toCharArray());
            bytes = EncryptUtils.en(bytes, pass, 1);
            if (StrUtils.isNotEmpty(this.code)) {
                pass = StrUtils.merger(className.toCharArray(), this.code);
                bytes = EncryptUtils.en(bytes, pass, 1);
            }
            File targetFile = new File(metaDir, className);
            IoUtils.writeFile(targetFile, bytes);
            encryptClasses.add(className);
            Log.debug("\u52a0\u5bc6\uff1a" + className);
        });
        char[] pchar = EncryptUtils.md5(StrUtils.merger(this.password, EncryptUtils.SALT));
        pchar = EncryptUtils.md5(StrUtils.merger(EncryptUtils.SALT, pchar));
        IoUtils.writeFile(new File(metaDir, "org.springframework.config.PassHash"), StrUtils.toBytes(pchar));
        return encryptClasses;
    }

    private void clearClassMethod(List<File> classFiles) {
        ClassPool pool = ClassPool.getDefault();
        ClassUtils.loadClassPath(pool, this.targetLibDir);
        Log.debug("ClassPath: " + this.targetLibDir.getAbsolutePath());
        ClassUtils.loadClassPath(pool, this.classPath);
        this.classPath.forEach(classPath -> Log.debug("ClassPath: " + classPath));
        ArrayList classPaths = new ArrayList();
        classFiles.forEach(classFile -> {
            String classPath = this.resolveClassName(classFile.getAbsolutePath(), false);
            if (classPaths.contains(classPath)) {
                return;
            }
            try {
                pool.insertClassPath(classPath);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            classPaths.add(classPath);
            Log.debug("ClassPath: " + classPath);
        });
        classFiles.forEach(classFile -> {
            String className = this.resolveClassName(classFile.getAbsolutePath(), true);
            byte[] bts = null;
            try {
                Log.debug("\u6e05\u9664\u65b9\u6cd5\u4f53: " + className);
                bts = ClassUtils.rewriteAllMethods(pool, className);
            }
            catch (Exception e) {
                Log.debug("ERROR:" + e.getMessage());
            }
            if (bts != null) {
                IoUtils.writeFile(classFile, bts);
            }
        });
    }

    public void addClassFinalAgent() {
        ArrayList<String> thisJarPaths = new ArrayList<String>();
        thisJarPaths.add(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        thisJarPaths.forEach(thisJar -> {
            File thisJarFile = new File((String)thisJar);
            if ("jar".endsWith(this.jarOrWar) && thisJar.endsWith(".jar")) {
                List<String> includeFiles = Arrays.asList(Const.CLASSFINAL_FILES);
                JarUtils.unJar(thisJar, this.targetDir.getAbsolutePath(), null, includeFiles, null);
            } else if ("war".endsWith(this.jarOrWar) && thisJar.endsWith(".jar")) {
                File targetlassFinalJar = new File(this.targetLibDir, thisJarFile.getName());
                byte[] bytes = IoUtils.readFileToByte(thisJarFile);
                IoUtils.writeFile(targetlassFinalJar, bytes);
            } else if (thisJar.endsWith("/classes/")) {
                ArrayList<File> files = new ArrayList<File>();
                IoUtils.listFile(files, new File((String)thisJar));
                files.forEach(file -> {
                    String className = file.getAbsolutePath().substring(thisJarFile.getAbsolutePath().length());
                    File targetFile = "jar".equals(this.jarOrWar) ? this.targetDir : this.targetClassesDir;
                    targetFile = new File(targetFile, className);
                    if (file.isDirectory()) {
                        targetFile.mkdirs();
                    } else if (StrUtils.containsArray(file.getAbsolutePath(), Const.CLASSFINAL_FILES)) {
                        byte[] bytes = IoUtils.readFileToByte(file);
                        IoUtils.writeFile(targetFile, bytes);
                    }
                });
            }
        });
        File manifest = new File(this.targetDir, "META-INF/MANIFEST.MF");
        String preMain = "Premain-Class: " + CoreAgent.class.getName();
        String[] txts = new String[]{};
        if (manifest.exists()) {
            txts = IoUtils.readTxtFile(manifest).split("\r\n");
        }
        String str = StrUtils.insertStringArray(txts, preMain, "Main-Class:");
        IoUtils.writeTxtFile(manifest, str + "\r\n\r\n");
    }

    private void encryptConfigFile() {
        if (this.cfgfiles == null || this.cfgfiles.size() == 0) {
            return;
        }
        String[] supportFrame = new String[]{"spring", "jfinal"};
        ArrayList<File> aopClass = new ArrayList<File>(supportFrame.length);
        Arrays.asList(supportFrame).forEach(name -> {
            String javaCode = aopMap.get(name + ".code");
            String clazz = aopMap.get(name + ".class");
            Integer line = Integer.parseInt(aopMap.get(name + ".line"));
            javaCode = javaCode.replace("${passchar}", StrUtils.toCharArrayCode(this.password));
            byte[] bytes = null;
            try {
                bytes = ClassUtils.insertCode(clazz, javaCode, line, this.targetLibDir);
            }
            catch (Exception e) {
                Log.debug(e.getClass().getName() + ":" + e.getMessage());
            }
            if (bytes != null) {
                File cls = new File(this.targetDir, clazz.split("#")[0] + ".class");
                IoUtils.writeFile(cls, bytes);
                aopClass.add(cls);
            }
        });
        this.encryptClass(aopClass);
        aopClass.forEach(cls -> cls.delete());
        ArrayList<File> configFiles = new ArrayList<File>();
        File[] files = this.targetClassesDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file2 : files) {
            if (!file2.isFile() || !ClassUtils.isClass(this.cfgfiles, file2.getName())) continue;
            configFiles.add(file2);
        }
        this.encryptClass(configFiles);
        configFiles.forEach(file -> IoUtils.writeTxtFile(file, ""));
    }

    private String packageJar() {
        this.includeJars.forEach(jar -> {
            if (!jar.endsWith(".jar")) {
                return;
            }
            String targetJar = this.targetLibDir.getAbsolutePath() + File.separator + jar;
            String srcJarDir = targetJar.substring(0, targetJar.length() - 4) + "__temp__";
            if (!new File(srcJarDir).exists()) {
                return;
            }
            JarUtils.doJar(srcJarDir, targetJar);
            IoUtils.delete(new File(srcJarDir));
            Log.debug("\u6253\u5305: " + targetJar);
        });
        IoUtils.delete(new File(this.targetDir, "META-INF/maven"));
        String targetJar = this.jarPath.replace("." + this.jarOrWar, "-encrypted." + this.jarOrWar);
        String result = JarUtils.doJar(this.targetDir.getAbsolutePath(), targetJar);
        IoUtils.delete(this.targetDir);
        Log.debug("\u6253\u5305: " + targetJar);
        return result;
    }

    private String resolveClassName(String fileName, boolean classOrPath) {
        String clsPath;
        String clsName;
        String result = this.resolveClassName.get(fileName + classOrPath);
        if (result != null) {
            return result;
        }
        String file = fileName.substring(0, fileName.length() - 6);
        String K_CLASSES = File.separator + "classes" + File.separator;
        String K_LIB = File.separator + "lib" + File.separator;
        if (file.contains(K_LIB)) {
            clsName = file.substring(file.indexOf("__temp__", file.indexOf(K_LIB)) + "__temp__".length() + 1);
            clsPath = file.substring(0, file.length() - clsName.length() - 1);
        } else if (file.contains(K_CLASSES)) {
            clsName = file.substring(file.indexOf(K_CLASSES) + K_CLASSES.length());
            clsPath = file.substring(0, file.length() - clsName.length() - 1);
        } else {
            clsName = file.substring(file.indexOf("__temp__") + "__temp__".length() + 1);
            clsPath = file.substring(0, file.length() - clsName.length() - 1);
        }
        result = classOrPath ? clsName.replace(File.separator, ".") : clsPath;
        this.resolveClassName.put(fileName + classOrPath, result);
        return result;
    }

    public Integer getEncryptFileCount() {
        return this.encryptFileCount;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public void setIncludeJars(List<String> includeJars) {
        this.includeJars = includeJars;
    }

    public void setExcludeClass(List<String> excludeClass) {
        this.excludeClass = excludeClass;
    }

    public void setClassPath(List<String> classPath) {
        this.classPath = classPath;
    }

    public void setCfgfiles(List<String> cfgfiles) {
        this.cfgfiles = cfgfiles;
    }

    public void setCode(char[] code) {
        this.code = code;
    }

    static {
        aopMap.put("spring.class", "org.springframework.core.io.ClassPathResource#getInputStream");
        aopMap.put("spring.code", "char[] c=${passchar};is=net.roseboy.classfinal.JarDecryptor.getInstance().decryptConfigFile(this.path,is,c);");
        aopMap.put("spring.line", "999");
        aopMap.put("jfinal.class", "com.jfinal.kit.Prop#<Prop>(java.lang.String,java.lang.String)");
        aopMap.put("jfinal.code", "char[] c=${passchar};inputStream=net.roseboy.classfinal.JarDecryptor.getInstance().decryptConfigFile(fileName,inputStream,c);");
        aopMap.put("jfinal.line", "62");
    }
}

