/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Properties;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends Instruction {
    private Operand selectOp;
    private Operand terminateOp;
    private Operand errorCodeOp;
    private boolean isAssert;

    public Message(Expression select, Expression terminate, Expression errorCode) {
        if (errorCode == null) {
            errorCode = new StringLiteral("Q{http://www.w3.org/2005/xqt-errors}XTMM9000");
        }
        this.selectOp = new Operand(this, select, OperandRole.SINGLE_ATOMIC);
        this.terminateOp = new Operand(this, terminate, OperandRole.SINGLE_ATOMIC);
        this.errorCodeOp = new Operand(this, errorCode, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getSelect() {
        return this.selectOp.getChildExpression();
    }

    public void setSelect(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    public Expression getTerminate() {
        return this.terminateOp.getChildExpression();
    }

    public void setTerminate(Expression terminate) {
        this.terminateOp.setChildExpression(terminate);
    }

    public Expression getErrorCode() {
        return this.errorCodeOp.getChildExpression();
    }

    public void setErrorCode(Expression errorCode) {
        this.errorCodeOp.setChildExpression(errorCode);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.selectOp, this.terminateOp, this.errorCodeOp);
    }

    public void setIsAssert(boolean isAssert) {
        this.isAssert = isAssert;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Message exp = new Message(this.getSelect().copy(rebindings), this.getTerminate().copy(rebindings), this.getErrorCode().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getInstructionNameCode() {
        return this.isAssert ? 134 : 173;
    }

    @Override
    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public int getCardinality() {
        return 24576;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        if (this.isAssert && !controller.isAssertionsEnabled()) {
            return null;
        }
        Receiver emitter = controller.getMessageEmitter();
        if (emitter != null) {
            String code;
            try {
                code = this.getErrorCode().evaluateAsString(context).toString();
            }
            catch (XPathException err) {
                code = err.getErrorCodeQName().getEQName();
            }
            Receiver receiver = emitter;
            synchronized (receiver) {
                Item item;
                StructuredQName errorCode = null;
                try {
                    errorCode = StructuredQName.fromLexicalQName(code, false, true, this.getRetainedStaticContext());
                }
                catch (XPathException err) {
                    errorCode = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XTMM9000");
                }
                context.getController().incrementMessageCounter(errorCode);
                SequenceReceiver rec = new TreeReceiver(emitter);
                rec = new MessageAdapter(rec, errorCode.getEQName(), this.getLocation());
                SequenceReceiver saved = context.getReceiver();
                int savedOutputState = context.getTemporaryOutputState();
                Properties props = new Properties();
                props.setProperty("omit-xml-declaration", "yes");
                SerializerFactory sf = context.getConfiguration().getSerializerFactory();
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setLocationIsCodeLocation(true);
                pipe.setHostLanguage(50);
                SequenceReceiver receiver2 = sf.getReceiver(rec, pipe, props);
                context.setReceiver(receiver2);
                context.setTemporaryOutputState(173);
                boolean abort = false;
                String term = Whitespace.trim(this.getTerminate().evaluateAsString(context));
                if (!(term.equals("no") || term.equals("false") || term.equals("0"))) {
                    if (term.equals("yes") || term.equals("true") || term.equals("1")) {
                        abort = true;
                    } else {
                        XPathException e = new XPathException("The terminate attribute of xsl:message must be yes|no|true|false|1|0");
                        e.setXPathContext(context);
                        e.setErrorCode("XTDE0030");
                        throw e;
                    }
                }
                rec.startDocument(abort ? 16384 : 0);
                SequenceIterator iter = this.getSelect().iterate(context);
                while ((item = iter.next()) != null) {
                    rec.append(item, this.getLocation(), 2);
                }
                rec.endDocument();
                context.setReceiver(saved);
                context.setTemporaryOutputState(savedOutputState);
                if (abort) {
                    TerminationException te = new TerminationException("Processing terminated by " + StandardErrorListener.getInstructionName(this) + " at line " + this.getLocation().getLineNumber() + " in " + StandardErrorListener.abbreviatePath(this.getLocation().getSystemId()));
                    te.setLocation(this.getLocation());
                    te.setErrorCodeQName(errorCode);
                    throw te;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("message", this);
        out.setChildRole("select");
        this.getSelect().export(out);
        out.setChildRole("terminate");
        this.getTerminate().export(out);
        out.setChildRole("error");
        this.getErrorCode().export(out);
        out.endElement();
    }

    private static class MessageAdapter
    extends ProxyReceiver {
        private boolean contentStarted = true;
        private String errorCode;
        private Location location;

        public MessageAdapter(SequenceReceiver next, String errorCode, Location location) {
            super(next);
            this.errorCode = errorCode;
            this.location = location;
        }

        public void startDocument(int properties) throws XPathException {
            super.startDocument(properties);
            this.processingInstruction("error-code", this.errorCode, this.location, 0);
        }

        public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
            this.contentStarted = false;
            super.startElement(nameCode, typeCode, location, properties);
        }

        public void startContent() throws XPathException {
            this.contentStarted = true;
            super.startContent();
        }

        public void attribute(NodeName attributeName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
            if (this.contentStarted) {
                String attName = attributeName.getDisplayName();
                this.processingInstruction("attribute", "name=\"" + attName + "\" value=\"" + value + "\"", locationId, 0);
            } else {
                super.attribute(attributeName, typeCode, value, locationId, properties);
            }
        }

        public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
            if (this.contentStarted) {
                for (NamespaceBinding ns : namespaceBindings) {
                    String prefix = ns.getPrefix();
                    String uri = ns.getURI();
                    this.processingInstruction("namespace", "prefix=\"" + prefix + "\" uri=\"" + uri + "\"", ExplicitLocation.UNKNOWN_LOCATION, 0);
                }
            } else {
                super.namespace(namespaceBindings, properties);
            }
        }

        public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
            int kind;
            if (item instanceof NodeInfo && ((kind = ((NodeInfo)item).getNodeKind()) == 2 || kind == 13)) {
                ((NodeInfo)item).copy(this, 0, locationId);
                return;
            }
            ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
        }
    }
}

