/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.LocalizerFactory;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.PackageLibrary;
import net.sf.saxon.trans.packages.VersionedPackageName;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.SequenceExtent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationReader
implements ContentHandler,
NamespaceResolver {
    private int level = 0;
    private String section = null;
    private String subsection = null;
    private FastStringBuffer buffer = new FastStringBuffer(100);
    protected Configuration config;
    private ClassLoader classLoader = null;
    private List<XPathException> errors = new ArrayList<XPathException>();
    private Locator locator;
    private Stack<List<String[]>> namespaceStack = new Stack();
    private PackageLibrary packageLibrary;
    private PackageDetails currentPackage;
    private Configuration baseConfiguration;

    public ConfigurationReader() {
    }

    public ConfigurationReader(Configuration baseConfiguration) {
        this.baseConfiguration = baseConfiguration;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBaseConfiguration(Configuration base) {
        this.baseConfiguration = base;
    }

    public Configuration makeConfiguration(Source source) throws XPathException {
        InputSource is;
        XMLReader parser = null;
        if (source instanceof NodeInfo) {
            ContentHandlerProxy proxy = new ContentHandlerProxy(){

                public void startDocument(int properties) throws XPathException {
                    try {
                        this.getUnderlyingContentHandler().startDocument();
                    }
                    catch (SAXException e) {
                        throw XPathException.makeXPathException(e);
                    }
                }

                public void endDocument() throws XPathException {
                    try {
                        this.getUnderlyingContentHandler().endDocument();
                    }
                    catch (SAXException e) {
                        throw XPathException.makeXPathException(e);
                    }
                }
            };
            proxy.setUnderlyingContentHandler(this);
            proxy.setPipelineConfiguration(((NodeInfo)source).getConfiguration().makePipelineConfiguration());
            proxy.open();
            proxy.startDocument(0);
            ((NodeInfo)source).copy(proxy, 2, ExplicitLocation.UNKNOWN_LOCATION);
            proxy.endDocument();
            proxy.close();
            return this.config;
        }
        if (source instanceof SAXSource) {
            parser = ((SAXSource)source).getXMLReader();
            is = ((SAXSource)source).getInputSource();
        } else if (source instanceof StreamSource) {
            is = new InputSource(source.getSystemId());
            is.setCharacterStream(((StreamSource)source).getReader());
            is.setByteStream(((StreamSource)source).getInputStream());
        } else {
            throw new XPathException("Source for configuration file must be a StreamSource or SAXSource");
        }
        if (parser == null) {
            parser = Version.platform.loadParser();
            try {
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            }
            catch (SAXNotRecognizedException e) {
                throw new TransformerFactoryConfigurationError(e);
            }
            catch (SAXNotSupportedException e) {
                throw new TransformerFactoryConfigurationError(e);
            }
        }
        try {
            parser.setContentHandler(this);
            parser.parse(is);
        }
        catch (IOException e) {
            throw new XPathException("Failed to read config file", e);
        }
        catch (SAXException e) {
            throw new XPathException("Failed to parse config file", e);
        }
        if (!this.errors.isEmpty()) {
            UnfailingErrorListener listener = this.config == null ? new StandardErrorListener() : this.config.getErrorListener();
            try {
                for (XPathException err : this.errors) {
                    listener.warning(err);
                }
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw this.errors.get(0);
        }
        return this.config;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.namespaceStack.push(new ArrayList());
    }

    @Override
    public void endDocument() throws SAXException {
        this.namespaceStack.pop();
        this.config.getDefaultXsltCompilerInfo().setPackageLibrary(this.packageLibrary);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceStack.peek().add(new String[]{prefix, uri});
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.buffer.setLength(0);
        if ("http://saxon.sf.net/ns/configuration".equals(uri)) {
            if (this.level == 0) {
                String label;
                String edition;
                if (!"configuration".equals(localName)) {
                    this.error(localName, null, null, "configuration");
                }
                if ((edition = atts.getValue("edition")) == null) {
                    edition = "HE";
                }
                if (edition.equals("HE")) {
                    this.config = new Configuration();
                } else if (edition.equals("PE")) {
                    this.config = Configuration.makeLicensedConfiguration(this.classLoader, "com.saxonica.config.ProfessionalConfiguration");
                } else if (edition.equals("EE")) {
                    this.config = Configuration.makeLicensedConfiguration(this.classLoader, "com.saxonica.config.EnterpriseConfiguration");
                } else {
                    this.error("configuration", "edition", edition, "HE|PE|EE");
                    this.config = new Configuration();
                }
                if (this.baseConfiguration != null) {
                    this.config.setNamePool(this.baseConfiguration.getNamePool());
                    this.config.setDocumentNumberAllocator(this.baseConfiguration.getDocumentNumberAllocator());
                }
                this.packageLibrary = new PackageLibrary(this.config.getDefaultXsltCompilerInfo());
                String licenseLoc = atts.getValue("licenseFileLocation");
                if (licenseLoc != null && !edition.equals("HE")) {
                    String base = this.locator.getSystemId();
                    try {
                        URI absoluteLoc = ResolveURI.makeAbsolute(licenseLoc, base);
                        this.config.setConfigurationProperty("http://saxon.sf.net/feature/licenseFileLocation", absoluteLoc.toString());
                    }
                    catch (Exception err) {
                        this.errors.add(new XPathException("Failed to process license at " + licenseLoc, err));
                    }
                }
                if ((label = atts.getValue("label")) != null) {
                    this.config.setLabel(label);
                }
                this.config.getDynamicLoader().setClassLoader(this.classLoader);
            }
            if (this.level == 1) {
                this.section = localName;
                if ("global".equals(localName)) {
                    this.readGlobalElement(atts);
                } else if ("serialization".equals(localName)) {
                    this.readSerializationElement(atts);
                } else if ("xquery".equals(localName)) {
                    this.readXQueryElement(atts);
                } else if ("xslt".equals(localName)) {
                    this.readXsltElement(atts);
                } else if (!"xsltPackages".equals(localName)) {
                    if ("xsd".equals(localName)) {
                        this.readXsdElement(atts);
                    } else if (!"resources".equals(localName) && !"collations".equals(localName)) {
                        if ("localizations".equals(localName)) {
                            this.readLocalizationsElement(atts);
                        } else {
                            this.error(localName, null, null, null);
                        }
                    }
                }
            } else if (this.level == 2) {
                this.subsection = localName;
                if ("resources".equals(this.section)) {
                    if ("fileExtension".equals(localName)) {
                        this.readFileExtension(atts);
                    }
                } else if ("collations".equals(this.section)) {
                    if (!"collation".equals(localName)) {
                        this.error(localName, null, null, "collation");
                    } else {
                        this.readCollation(atts);
                    }
                } else if ("localizations".equals(this.section)) {
                    if (!"localization".equals(localName)) {
                        this.error(localName, null, null, "localization");
                    } else {
                        this.readLocalization(atts);
                    }
                } else if ("xslt".equals(this.section)) {
                    if ("extensionElement".equals(localName)) {
                        this.readExtensionElement(atts);
                    } else {
                        this.error(localName, null, null, null);
                    }
                } else if ("xsltPackages".equals(this.section) && "package".equals(localName)) {
                    this.readXsltPackage(atts);
                }
            } else if (this.level == 3 && "package".equals(this.subsection)) {
                if ("withParam".equals(localName)) {
                    this.readWithParam(atts);
                } else {
                    this.error(localName, null, null, null);
                }
            }
        } else {
            this.errors.add(new XPathException("Configuration elements must be in namespace http://saxon.sf.net/ns/configuration"));
        }
        ++this.level;
        this.namespaceStack.push(new ArrayList());
    }

    private void readGlobalElement(Attributes atts) {
        Properties props = new Properties();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (value.length() == 0 || !atts.getURI(i).isEmpty()) continue;
            props.put(name, value);
        }
        props.put("#element", "global");
        this.applyProperty(props, "allowExternalFunctions", "http://saxon.sf.net/feature/allow-external-functions");
        this.applyProperty(props, "allowMultiThreading", "http://saxon.sf.net/feature/allow-multithreading");
        this.applyProperty(props, "allowOldJavaUriFormat", "http://saxon.sf.net/feature/allow-old-java-uri-format");
        this.applyProperty(props, "allowSyntaxExtensions", "http://saxon.sf.net/feature/allowSyntaxExtensions");
        this.applyProperty(props, "collationUriResolver", "http://saxon.sf.net/feature/collation-uri-resolver-class");
        this.applyProperty(props, "collectionUriResolver", "http://saxon.sf.net/feature/collection-uri-resolver-class");
        this.applyProperty(props, "compileWithTracing", "http://saxon.sf.net/feature/compile-with-tracing");
        this.applyProperty(props, "debugByteCode", "http://saxon.sf.net/feature/debugByteCode");
        this.applyProperty(props, "debugByteCodeDirectory", "http://saxon.sf.net/feature/debugByteCodeDir");
        this.applyProperty(props, "defaultCollation", "http://saxon.sf.net/feature/defaultCollation");
        this.applyProperty(props, "defaultCollection", "http://saxon.sf.net/feature/defaultCollection");
        this.applyProperty(props, "defaultRegexEngine", "http://saxon.sf.net/feature/defaultRegexEngine");
        this.applyProperty(props, "displayByteCode", "http://saxon.sf.net/feature/displayByteCode");
        this.applyProperty(props, "dtdValidation", "http://saxon.sf.net/feature/validation");
        this.applyProperty(props, "dtdValidationRecoverable", "http://saxon.sf.net/feature/dtd-validation-recoverable");
        this.applyProperty(props, "eagerEvaluation", "http://saxon.sf.net/feature/eagerEvaluation");
        this.applyProperty(props, "entityResolver", "http://saxon.sf.net/feature/entityResolverClass");
        this.applyProperty(props, "errorListener", "http://saxon.sf.net/feature/errorListenerClass");
        this.applyProperty(props, "environmentVariableResolver", "http://saxon.sf.net/feature/environmentVariableResolverClass");
        this.applyProperty(props, "expandAttributeDefaults", "http://saxon.sf.net/feature/expandAttributeDefaults");
        this.applyProperty(props, "generateByteCode", "http://saxon.sf.net/feature/generateByteCode");
        this.applyProperty(props, "ignoreSAXSourceParser", "http://saxon.sf.net/feature/ignoreSAXSourceParser");
        this.applyProperty(props, "lineNumbering", "http://saxon.sf.net/feature/linenumbering");
        this.applyProperty(props, "markDefaultedAttributes", "http://saxon.sf.net/feature/markDefaultedAttributes");
        this.applyProperty(props, "maxCompiledClasses", "http://saxon.sf.net/feature/maxCompiledClasses");
        this.applyProperty(props, "monitorHotSpotByteCode", "http://saxon.sf.net/feature/monitorHotSpotByteCode");
        this.applyProperty(props, "optimizationLevel", "http://saxon.sf.net/feature/optimizationLevel");
        this.applyProperty(props, "parser", "http://saxon.sf.net/feature/sourceParserClass");
        this.applyProperty(props, "preEvaluateDoc", "http://saxon.sf.net/feature/preEvaluateDocFunction");
        this.applyProperty(props, "preferJaxpParser", "http://saxon.sf.net/feature/preferJaxpParser");
        this.applyProperty(props, "recognizeUriQueryParameters", "http://saxon.sf.net/feature/recognize-uri-query-parameters");
        this.applyProperty(props, "schemaValidation", "http://saxon.sf.net/feature/schema-validation-mode");
        this.applyProperty(props, "serializerFactory", "http://saxon.sf.net/feature/serializerFactoryClass");
        this.applyProperty(props, "sourceResolver", "http://saxon.sf.net/feature/sourceResolverClass");
        this.applyProperty(props, "stableCollectionUri", "http://saxon.sf.net/feature/stableCollectionUri");
        this.applyProperty(props, "stableUnparsedText", "http://saxon.sf.net/feature/stableUnparsedText");
        this.applyProperty(props, "standardErrorOutputFile", "http://saxon.sf.net/feature/standardErrorOutputFile");
        this.applyProperty(props, "streamability", "http://saxon.sf.net/feature/streamability");
        this.applyProperty(props, "streamingFallback", "http://saxon.sf.net/feature/streamingFallback");
        this.applyProperty(props, "stripSpace", "http://saxon.sf.net/feature/strip-whitespace");
        this.applyProperty(props, "styleParser", "http://saxon.sf.net/feature/styleParserClass");
        this.applyProperty(props, "suppressEvaluationExpiryWarning", "http://saxon.sf.net/feature/suppressEvaluationExpiryWarning");
        this.applyProperty(props, "suppressXPathWarnings", "http://saxon.sf.net/feature/suppressXPathWarnings");
        this.applyProperty(props, "suppressXsltNamespaceCheck", "http://saxon.sf.net/feature/suppressXsltNamespaceCheck");
        this.applyProperty(props, "timing", "http://saxon.sf.net/feature/timing");
        this.applyProperty(props, "traceExternalFunctions", "http://saxon.sf.net/feature/trace-external-functions");
        this.applyProperty(props, "traceListener", "http://saxon.sf.net/feature/traceListenerClass");
        this.applyProperty(props, "traceListenerOutputFile", "http://saxon.sf.net/feature/traceListenerOutputFile");
        this.applyProperty(props, "traceOptimizerDecisions", "http://saxon.sf.net/feature/trace-optimizer-decisions");
        this.applyProperty(props, "treeModel", "http://saxon.sf.net/feature/treeModelName");
        this.applyProperty(props, "unparsedTextUriResolver", "http://saxon.sf.net/feature/unparsedTextURIResolverClass");
        this.applyProperty(props, "uriResolver", "http://saxon.sf.net/feature/uriResolverClass");
        this.applyProperty(props, "usePiDisableOutputEscaping", "http://saxon.sf.net/feature/use-pi-disable-output-escaping");
        this.applyProperty(props, "useTypedValueCache", "http://saxon.sf.net/feature/use-typed-value-cache");
        this.applyProperty(props, "validationComments", "http://saxon.sf.net/feature/validation-comments");
        this.applyProperty(props, "validationWarnings", "http://saxon.sf.net/feature/validation-warnings");
        this.applyProperty(props, "versionOfXml", "http://saxon.sf.net/feature/xml-version");
        this.applyProperty(props, "xInclude", "http://saxon.sf.net/feature/xinclude-aware");
    }

    private void applyProperty(Properties props, String propertyName, String featureKey) {
        String value = props.getProperty(propertyName);
        if (value != null) {
            try {
                this.config.setConfigurationProperty(featureKey, value);
            }
            catch (IllegalArgumentException e) {
                String message = e.getMessage();
                if (message.startsWith(featureKey)) {
                    message = message.replace(featureKey, "Value");
                }
                if (message.startsWith("Unknown configuration property")) {
                    message = "Property not available in Saxon-" + this.config.getEditionCode();
                }
                this.error(props.getProperty("#element"), propertyName, value, message);
            }
        }
    }

    private void readSerializationElement(Attributes atts) {
        Properties props = new Properties();
        for (int i = 0; i < atts.getLength(); ++i) {
            String uri = atts.getURI(i);
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (value.isEmpty()) continue;
            try {
                ResultDocument.setSerializationProperty(props, uri, name, value, this, false, this.config);
                continue;
            }
            catch (XPathException e) {
                this.errors.add(e);
            }
        }
        this.config.setDefaultSerializationProperties(props);
    }

    private void readCollation(Attributes atts) {
        Properties props = new Properties();
        String collationUri = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getURI(i).isEmpty()) continue;
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (value.isEmpty()) continue;
            if ("uri".equals(name)) {
                collationUri = value;
                continue;
            }
            props.put(name, value);
        }
        if (collationUri == null) {
            this.errors.add(new XPathException("collation specified with no uri"));
        }
        StringCollator collator = null;
        try {
            collator = Version.platform.makeCollation(this.config, props, collationUri);
        }
        catch (XPathException e) {
            this.errors.add(e);
        }
        this.config.registerCollation(collationUri, collator);
    }

    private void readLocalizationsElement(Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getURI(i).isEmpty()) continue;
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if ("defaultLanguage".equals(name) && value.length() > 0) {
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/defaultLanguage", value);
            }
            if (!"defaultCountry".equals(name) || value.length() <= 0) continue;
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/defaultCountry", value);
        }
    }

    private void readLocalization(Attributes atts) {
        LocalizerFactory factory;
        String lang = null;
        Properties properties = new Properties();
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getURI(i).isEmpty()) continue;
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if ("lang".equals(name) && value.length() > 0) {
                lang = value;
                continue;
            }
            if (value.length() <= 0) continue;
            properties.setProperty(name, value);
        }
        if (lang != null && (factory = this.config.getLocalizerFactory()) != null) {
            factory.setLanguageProperties(lang, properties);
        }
    }

    private void readFileExtension(Attributes atts) {
        String extension = atts.getValue("", "extension");
        String mediaType = atts.getValue("", "mediaType");
        if (extension == null) {
            this.error("fileExtension", "extension", null, null);
        }
        if (mediaType == null) {
            this.error("fileExtension", "mediaType", null, null);
        }
        this.config.registerFileExtension(extension, mediaType);
    }

    protected void readExtensionElement(Attributes atts) {
        XPathException err = new XPathException("Extension elements are not available in Saxon-HE");
        err.setLocator(ExplicitLocation.makeFromSax(this.locator));
        this.errors.add(err);
    }

    protected void readXsltPackage(Attributes atts) {
        String name = atts.getValue("name");
        if (name == null) {
            String attName = "exportLocation";
            String location = atts.getValue("exportLocation");
            URI uri = null;
            if (location == null) {
                attName = "sourceLocation";
                location = atts.getValue("sourceLocation");
            }
            if (location == null) {
                this.error("package", attName, null, null);
            }
            try {
                uri = ResolveURI.makeAbsolute(location, this.locator.getSystemId());
            }
            catch (URISyntaxException e) {
                this.error("package", attName, location, "Requires a valid URI.");
            }
            File file = new File(uri);
            try {
                this.packageLibrary.addPackage(file);
            }
            catch (XPathException e) {
                this.error(e);
            }
        } else {
            String priority;
            String exportLoc;
            String version = atts.getValue("version");
            if (version == null) {
                version = "1";
            }
            VersionedPackageName vpn = null;
            PackageDetails details = new PackageDetails();
            try {
                vpn = new VersionedPackageName(name, version);
            }
            catch (XPathException err) {
                this.error("package", "version", version, null);
            }
            details.nameAndVersion = vpn;
            this.currentPackage = details;
            String sourceLoc = atts.getValue("sourceLocation");
            StreamSource source = null;
            if (sourceLoc != null) {
                try {
                    source = new StreamSource(ResolveURI.makeAbsolute(sourceLoc, this.locator.getSystemId()).toString());
                }
                catch (URISyntaxException e) {
                    this.error("package", "sourceLocation", sourceLoc, "Requires a valid URI.");
                }
                details.sourceLocation = source;
            }
            if ((exportLoc = atts.getValue("exportLocation")) != null) {
                try {
                    source = new StreamSource(ResolveURI.makeAbsolute(exportLoc, this.locator.getSystemId()).toString());
                }
                catch (URISyntaxException e) {
                    this.error("package", "exportLocation", exportLoc, "Requires a valid URI.");
                }
                details.exportLocation = source;
            }
            if ((priority = atts.getValue("priority")) != null) {
                try {
                    details.priority = Integer.parseInt(priority);
                }
                catch (NumberFormatException err) {
                    this.error("package", "priority", priority, "Requires an integer.");
                }
            }
            details.baseName = atts.getValue("base");
            details.shortName = atts.getValue("shortName");
            this.packageLibrary.addPackage(details);
        }
    }

    protected void readWithParam(Attributes atts) {
        String name;
        if (this.currentPackage.exportLocation != null) {
            this.error("withParam", null, null, "Not allowed when @exportLocation exists");
        }
        if ((name = atts.getValue("name")) == null) {
            this.error("withParam", "name", null, null);
        }
        QNameParser qp = new QNameParser(this);
        qp.setAcceptEQName(true);
        StructuredQName qName = null;
        try {
            qName = qp.parse(name);
        }
        catch (XPathException e) {
            this.error("withParam", "name", name, "Requires valid QName");
        }
        String select = atts.getValue("select");
        if (select == null) {
            this.error("withParam", "select", null, null);
        }
        IndependentContext env = new IndependentContext(this.config);
        env.setNamespaceResolver(this);
        XPathParser parser = new XPathParser();
        GroundedValue value = null;
        try {
            Expression exp = parser.parse(select, 0, 0, env);
            value = SequenceExtent.makeSequenceExtent(exp.iterate(env.makeEarlyEvaluationContext()));
        }
        catch (XPathException e) {
            this.error(e);
        }
        if (this.currentPackage.staticParams == null) {
            this.currentPackage.staticParams = new HashMap<StructuredQName, Sequence>();
        }
        this.currentPackage.staticParams.put(qName, value);
    }

    private void readXQueryElement(Attributes atts) {
        Properties props = new Properties();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (value.length() == 0 || !atts.getURI(i).isEmpty()) continue;
            props.put(name, value);
        }
        props.put("#element", "xquery");
        this.applyProperty(props, "allowUpdate", "http://saxon.sf.net/feature/xqueryAllowUpdate");
        this.applyProperty(props, "constructionMode", "http://saxon.sf.net/feature/xqueryConstructionMode");
        this.applyProperty(props, "defaultElementNamespace", "http://saxon.sf.net/feature/xqueryDefaultElementNamespace");
        this.applyProperty(props, "defaultFunctionNamespace", "http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace");
        this.applyProperty(props, "emptyLeast", "http://saxon.sf.net/feature/xqueryEmptyLeast");
        this.applyProperty(props, "inheritNamespaces", "http://saxon.sf.net/feature/xqueryInheritNamespaces");
        this.applyProperty(props, "moduleUriResolver", "http://saxon.sf.net/feature/moduleURIResolverClass");
        this.applyProperty(props, "preserveBoundarySpace", "http://saxon.sf.net/feature/xqueryPreserveBoundarySpace");
        this.applyProperty(props, "preserveNamespaces", "http://saxon.sf.net/feature/xqueryPreserveNamespaces");
        this.applyProperty(props, "requiredContextItemType", "http://saxon.sf.net/feature/xqueryRequiredContextItemType");
        this.applyProperty(props, "schemaAware", "http://saxon.sf.net/feature/xquerySchemaAware");
        this.applyProperty(props, "staticErrorListener", "http://saxon.sf.net/feature/xqueryStaticErrorListenerClass");
        this.applyProperty(props, "version", "http://saxon.sf.net/feature/xqueryVersion");
    }

    private void readXsltElement(Attributes atts) {
        Properties props = new Properties();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (value.length() == 0 || !atts.getURI(i).isEmpty()) continue;
            props.put(name, value);
        }
        props.put("#element", "xslt");
        this.applyProperty(props, "disableXslEvaluate", "http://saxon.sf.net/feature/disableXslEvaluate");
        this.applyProperty(props, "enableAssertions", "http://saxon.sf.net/feature/enableAssertions");
        this.applyProperty(props, "initialMode", "http://saxon.sf.net/feature/initialMode");
        this.applyProperty(props, "initialTemplate", "http://saxon.sf.net/feature/initialTemplate");
        this.applyProperty(props, "messageEmitter", "http://saxon.sf.net/feature/messageEmitterClass");
        this.applyProperty(props, "outputUriResolver", "http://saxon.sf.net/feature/outputURIResolverClass");
        this.applyProperty(props, "recoveryPolicy", "http://saxon.sf.net/feature/recoveryPolicyName");
        this.applyProperty(props, "resultDocumentThreads", "http://saxon.sf.net/feature/resultDocumentThreads");
        this.applyProperty(props, "schemaAware", "http://saxon.sf.net/feature/xsltSchemaAware");
        this.applyProperty(props, "staticErrorListener", "http://saxon.sf.net/feature/stylesheetErrorListener");
        this.applyProperty(props, "staticUriResolver", "http://saxon.sf.net/feature/stylesheetURIResolver");
        this.applyProperty(props, "strictStreamability", "http://saxon.sf.net/feature/strictStreamability");
        this.applyProperty(props, "styleParser", "http://saxon.sf.net/feature/styleParserClass");
        this.applyProperty(props, "version", "http://saxon.sf.net/feature/xsltVersion");
    }

    private void readXsdElement(Attributes atts) {
        Properties props = new Properties();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (value.length() == 0 || !atts.getURI(i).isEmpty()) continue;
            props.put(name, value);
        }
        props.put("#element", "xsd");
        this.applyProperty(props, "assertionsCanSeeComments", "http://saxon.sf.net/feature/assertionsCanSeeComments");
        this.applyProperty(props, "implicitSchemaImports", "http://saxon.sf.net/feature/implicitSchemaImports");
        this.applyProperty(props, "multipleSchemaImports", "http://saxon.sf.net/feature/multipleSchemaImports");
        this.applyProperty(props, "occurrenceLimits", "http://saxon.sf.net/feature/occurrenceLimits");
        this.applyProperty(props, "schemaUriResolver", "http://saxon.sf.net/feature/schemaURIResolverClass");
        this.applyProperty(props, "thresholdForCompilingTypes", "http://saxon.sf.net/feature/thresholdForCompilingTypes");
        this.applyProperty(props, "useXsiSchemaLocation", "http://saxon.sf.net/feature/useXsiSchemaLocation");
        this.applyProperty(props, "version", "http://saxon.sf.net/feature/xsd-version");
    }

    private void error(String element, String attribute, String actual, String required) {
        XPathException err = attribute == null ? new XPathException("Invalid configuration element " + element) : (actual == null ? new XPathException("Missing configuration property " + element + "/@" + attribute) : new XPathException("Invalid configuration property " + element + "/@" + attribute + ". Supplied value '" + actual + "'. " + required));
        err.setLocator(ExplicitLocation.makeFromSax(this.locator));
        this.errors.add(err);
    }

    protected void error(XPathException err) {
        err.setLocator(ExplicitLocation.makeFromSax(this.locator));
        this.errors.add(err);
    }

    protected void errorClass(String element, String attribute, String actual, Class required, Exception cause) {
        XPathException err = new XPathException("Invalid configuration property " + element + (attribute == null ? "" : "/@" + attribute) + ". Supplied value '" + actual + "', required value is the name of a class that implements '" + required.getName() + "'", cause);
        err.setLocator(ExplicitLocation.makeFromSax(this.locator));
        this.errors.add(err);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String content;
        if (this.level == 3 && "resources".equals(this.section) && (content = this.buffer.toString()).length() != 0) {
            if ("externalObjectModel".equals(localName)) {
                try {
                    ExternalObjectModel model = (ExternalObjectModel)this.config.getInstance(content, null);
                    this.config.registerExternalObjectModel(model);
                }
                catch (XPathException e) {
                    this.errorClass("externalObjectModel", null, content, ExternalObjectModel.class, e);
                }
                catch (ClassCastException cce) {
                    this.errorClass("externalObjectModel", null, content, ExternalObjectModel.class, cce);
                }
            } else if ("extensionFunction".equals(localName)) {
                try {
                    ExtensionFunctionDefinition model = (ExtensionFunctionDefinition)this.config.getInstance(content, null);
                    this.config.registerExtensionFunction(model);
                }
                catch (XPathException e) {
                    this.errorClass("extensionFunction", null, content, ExtensionFunctionDefinition.class, e);
                }
                catch (ClassCastException cce) {
                    this.errorClass("extensionFunction", null, content, ExtensionFunctionDefinition.class, cce);
                }
                catch (IllegalArgumentException iae) {
                    this.errorClass("extensionFunction", null, content, ExtensionFunctionDefinition.class, iae);
                }
            } else if ("schemaDocument".equals(localName)) {
                try {
                    Source source = this.getInputSource(content);
                    this.config.addSchemaSource(source);
                }
                catch (SchemaException e) {
                    this.errors.add(XPathException.makeXPathException(e));
                }
                catch (XPathException e) {
                    this.errors.add(e);
                }
            } else if ("schemaComponentModel".equals(localName)) {
                try {
                    Source source = this.getInputSource(content);
                    this.config.importComponents(source);
                }
                catch (XPathException e) {
                    this.errors.add(e);
                }
            } else if (!"fileExtension".equals(localName)) {
                this.error(localName, null, null, null);
            }
        }
        --this.level;
        this.buffer.setLength(0);
        this.namespaceStack.pop();
    }

    private Source getInputSource(String href) throws XPathException {
        try {
            String base = this.locator.getSystemId();
            URI abs = ResolveURI.makeAbsolute(href, base);
            return new StreamSource(abs.toString());
        }
        catch (URISyntaxException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            List list = (List)this.namespaceStack.get(i);
            for (String[] pair : list) {
                if (!pair[0].equals(prefix)) continue;
                return pair[1];
            }
        }
        return null;
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        HashSet<String> prefixes = new HashSet<String>();
        for (List list : this.namespaceStack) {
            for (String[] pair : list) {
                prefixes.add(pair[0]);
            }
        }
        return prefixes.iterator();
    }
}

