/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.CounterImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.dom.RGBColorImpl;
import com.gargoylesoftware.css.dom.RectImpl;
import com.gargoylesoftware.css.parser.AbstractLocatable;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.parser.LexicalUnit;
import com.gargoylesoftware.css.parser.LexicalUnitImpl;
import com.gargoylesoftware.css.util.LangUtils;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSValueImpl
extends AbstractLocatable
implements CSSPrimitiveValue,
CSSValueList,
Serializable {
    private Object value_;

    public Object getValue() {
        return this.value_;
    }

    public CSSValueImpl(LexicalUnit value, boolean forcePrimitive) {
        LexicalUnit parameters = null;
        if (value != null) {
            parameters = value.getParameters();
        }
        this.value_ = !forcePrimitive && value != null && value.getNextLexicalUnit() != null ? this.getValues(value) : (parameters != null ? (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.RECT_FUNCTION ? new RectImpl(value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.RGBCOLOR ? new RGBColorImpl(value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.COUNTER_FUNCTION ? new CounterImpl(false, value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.COUNTERS_FUNCTION ? new CounterImpl(true, value.getParameters()) : value)))) : value);
        if (value != null) {
            this.setLocator(value.getLocator());
        }
    }

    private List<CSSValueImpl> getValues(LexicalUnit value) {
        ArrayList<CSSValueImpl> values = new ArrayList<CSSValueImpl>();
        for (LexicalUnit lu = value; lu != null; lu = lu.getNextLexicalUnit()) {
            values.add(new CSSValueImpl(lu, true));
        }
        return values;
    }

    public CSSValueImpl(LexicalUnit value) {
        this(value, false);
    }

    @Override
    public String getCssText() {
        if (this.getCssValueType() == 2) {
            StringBuilder sb = new StringBuilder();
            List list = (List)this.value_;
            Iterator it = list.iterator();
            boolean separate = false;
            while (it.hasNext()) {
                Object o = it.next();
                CSSValueImpl cssValue = (CSSValueImpl)o;
                if (separate) {
                    if (cssValue.value_ instanceof LexicalUnit) {
                        LexicalUnit lu = (LexicalUnit)cssValue.value_;
                        if (lu.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                            sb.append(" ");
                        }
                    } else {
                        sb.append(" ");
                    }
                }
                sb.append(o.toString());
                separate = true;
            }
            return sb.toString();
        }
        return this.value_ != null ? this.value_.toString() : "";
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSValueImpl v2 = (CSSValueImpl)parser.parsePropertyValue(is);
            this.value_ = v2.value_;
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public short getCssValueType() {
        if (this.value_ instanceof List) {
            return 2;
        }
        if (this.value_ instanceof LexicalUnit && ((LexicalUnit)this.value_).getLexicalUnitType() == LexicalUnit.LexicalUnitType.INHERIT) {
            return 0;
        }
        return 1;
    }

    @Override
    public short getPrimitiveType() {
        if (this.value_ instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.value_;
            switch (lu.getLexicalUnitType()) {
                case INHERIT: {
                    return 21;
                }
                case INTEGER: 
                case REAL: {
                    return 1;
                }
                case EM: {
                    return 3;
                }
                case EX: {
                    return 4;
                }
                case PIXEL: {
                    return 5;
                }
                case INCH: {
                    return 8;
                }
                case CENTIMETER: {
                    return 6;
                }
                case MILLIMETER: {
                    return 7;
                }
                case POINT: {
                    return 9;
                }
                case PICA: {
                    return 10;
                }
                case PERCENTAGE: {
                    return 2;
                }
                case URI: {
                    return 20;
                }
                case COUNTER_FUNCTION: {
                    return 23;
                }
                case DEGREE: {
                    return 11;
                }
                case GRADIAN: {
                    return 13;
                }
                case RADIAN: {
                    return 12;
                }
                case MILLISECOND: {
                    return 14;
                }
                case SECOND: {
                    return 15;
                }
                case HERTZ: {
                    return 16;
                }
                case KILOHERTZ: {
                    return 17;
                }
                case IDENT: {
                    return 21;
                }
                case STRING_VALUE: {
                    return 19;
                }
                case ATTR: {
                    return 22;
                }
                case UNICODERANGE: 
                case SUB_EXPRESSION: 
                case FUNCTION: {
                    return 19;
                }
                case DIMENSION: {
                    return 18;
                }
            }
            return 0;
        }
        if (this.value_ instanceof RectImpl) {
            return 24;
        }
        if (this.value_ instanceof RGBColorImpl) {
            return 25;
        }
        if (this.value_ instanceof CounterImpl) {
            return 23;
        }
        return 0;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        this.value_ = LexicalUnitImpl.createNumber(null, floatValue);
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (this.value_ instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.value_;
            return lu.getFloatValue();
        }
        throw new DOMExceptionImpl(15, 9);
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        switch (stringType) {
            case 19: {
                this.value_ = LexicalUnitImpl.createString(null, stringValue);
                break;
            }
            case 20: {
                this.value_ = LexicalUnitImpl.createURI(null, stringValue);
                break;
            }
            case 21: {
                this.value_ = LexicalUnitImpl.createIdent(null, stringValue);
                break;
            }
            case 22: {
                throw new DOMExceptionImpl(9, 18);
            }
            default: {
                throw new DOMExceptionImpl(15, 10);
            }
        }
    }

    @Override
    public String getStringValue() throws DOMException {
        if (this.value_ instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.value_;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.IDENT || lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.STRING_VALUE || lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.URI || lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.INHERIT || lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.ATTR) {
                return lu.getStringValue();
            }
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.FUNCTION) {
                return lu.toString();
            }
        } else if (this.value_ instanceof List) {
            return null;
        }
        throw new DOMExceptionImpl(15, 10);
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        if (this.value_ instanceof Counter) {
            return (Counter)this.value_;
        }
        throw new DOMExceptionImpl(15, 11);
    }

    @Override
    public Rect getRectValue() throws DOMException {
        if (this.value_ instanceof Rect) {
            return (Rect)this.value_;
        }
        throw new DOMExceptionImpl(15, 12);
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        if (this.value_ instanceof RGBColor) {
            return (RGBColor)this.value_;
        }
        throw new DOMExceptionImpl(15, 13);
    }

    @Override
    public int getLength() {
        if (this.value_ instanceof List) {
            return ((List)this.value_).size();
        }
        return 0;
    }

    @Override
    public CSSValue item(int index) {
        if (this.value_ instanceof List) {
            List list = (List)this.value_;
            return (CSSValue)list.get(index);
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSValue)) {
            return false;
        }
        CSSValue cv = (CSSValue)obj;
        return super.equals(obj) && this.getCssValueType() == cv.getCssValueType() && LangUtils.equals(this.getCssText(), cv.getCssText());
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.value_);
        return hash;
    }
}

