/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.parser.selector;

import com.gargoylesoftware.css.parser.condition.AttributeCondition;
import com.gargoylesoftware.css.parser.condition.BeginHyphenAttributeCondition;
import com.gargoylesoftware.css.parser.condition.Condition;
import com.gargoylesoftware.css.parser.condition.OneOfAttributeCondition;
import com.gargoylesoftware.css.parser.condition.PrefixAttributeCondition;
import com.gargoylesoftware.css.parser.condition.SubstringAttributeCondition;
import com.gargoylesoftware.css.parser.condition.SuffixAttributeCondition;
import com.gargoylesoftware.css.parser.selector.ChildSelector;
import com.gargoylesoftware.css.parser.selector.DescendantSelector;
import com.gargoylesoftware.css.parser.selector.DirectAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.ElementSelector;
import com.gargoylesoftware.css.parser.selector.GeneralAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.PseudoElementSelector;
import com.gargoylesoftware.css.parser.selector.Selector;
import java.io.Serializable;

public class SelectorSpecificity
implements Comparable<SelectorSpecificity>,
Serializable {
    public static final SelectorSpecificity FROM_STYLE_ATTRIBUTE = new SelectorSpecificity(1, 0, 0, 0);
    public static final SelectorSpecificity DEFAULT_STYLE_ATTRIBUTE = new SelectorSpecificity(0, 0, 0, 0);
    private int fieldA_;
    private int fieldB_;
    private int fieldC_;
    private int fieldD_;

    public SelectorSpecificity(Selector selector) {
        this.readSelectorSpecificity(selector);
    }

    private SelectorSpecificity(int a, int b, int c, int d) {
        this.fieldA_ = a;
        this.fieldB_ = b;
        this.fieldC_ = c;
        this.fieldD_ = d;
    }

    private void readSelectorSpecificity(Selector selector) {
        switch (selector.getSelectorType()) {
            case DESCENDANT_SELECTOR: {
                DescendantSelector ds = (DescendantSelector)selector;
                this.readSelectorSpecificity(ds.getAncestorSelector());
                this.readSelectorSpecificity(ds.getSimpleSelector());
                return;
            }
            case CHILD_SELECTOR: {
                ChildSelector cs = (ChildSelector)selector;
                this.readSelectorSpecificity(cs.getAncestorSelector());
                this.readSelectorSpecificity(cs.getSimpleSelector());
                return;
            }
            case ELEMENT_NODE_SELECTOR: {
                ElementSelector es = (ElementSelector)selector;
                if (es.getLocalName() != null) {
                    ++this.fieldD_;
                }
                if (es.getConditions() != null) {
                    for (Condition condition : es.getConditions()) {
                        this.readSelectorSpecificity(condition);
                    }
                }
                return;
            }
            case PSEUDO_ELEMENT_SELECTOR: {
                PseudoElementSelector pes = (PseudoElementSelector)selector;
                String pesName = pes.getLocalName();
                if (pesName != null) {
                    ++this.fieldD_;
                }
                return;
            }
            case DIRECT_ADJACENT_SELECTOR: {
                DirectAdjacentSelector das = (DirectAdjacentSelector)selector;
                this.readSelectorSpecificity(das.getSelector());
                this.readSelectorSpecificity(das.getSimpleSelector());
                return;
            }
            case GENERAL_ADJACENT_SELECTOR: {
                GeneralAdjacentSelector gas = (GeneralAdjacentSelector)selector;
                this.readSelectorSpecificity(gas.getSelector());
                this.readSelectorSpecificity(gas.getSimpleSelector());
                return;
            }
        }
        throw new RuntimeException("Unhandled CSS selector type for specificity computation: '" + (Object)((Object)selector.getSelectorType()) + "'.");
    }

    private void readSelectorSpecificity(Condition condition) {
        switch (condition.getConditionType()) {
            case ID_CONDITION: {
                ++this.fieldB_;
                return;
            }
            case CLASS_CONDITION: {
                ++this.fieldC_;
                return;
            }
            case ATTRIBUTE_CONDITION: {
                if ("id".equalsIgnoreCase(((AttributeCondition)condition).getLocalName())) {
                    ++this.fieldB_;
                } else {
                    ++this.fieldC_;
                }
                return;
            }
            case SUBSTRING_ATTRIBUTE_CONDITION: {
                if ("id".equalsIgnoreCase(((SubstringAttributeCondition)condition).getLocalName())) {
                    ++this.fieldB_;
                } else {
                    ++this.fieldC_;
                }
                return;
            }
            case SUFFIX_ATTRIBUTE_CONDITION: {
                if ("id".equalsIgnoreCase(((SuffixAttributeCondition)condition).getLocalName())) {
                    ++this.fieldB_;
                } else {
                    ++this.fieldC_;
                }
                return;
            }
            case PREFIX_ATTRIBUTE_CONDITION: {
                if ("id".equalsIgnoreCase(((PrefixAttributeCondition)condition).getLocalName())) {
                    ++this.fieldB_;
                } else {
                    ++this.fieldC_;
                }
                return;
            }
            case BEGIN_HYPHEN_ATTRIBUTE_CONDITION: {
                if ("id".equalsIgnoreCase(((BeginHyphenAttributeCondition)condition).getLocalName())) {
                    ++this.fieldB_;
                } else {
                    ++this.fieldC_;
                }
                return;
            }
            case ONE_OF_ATTRIBUTE_CONDITION: {
                if ("id".equalsIgnoreCase(((OneOfAttributeCondition)condition).getLocalName())) {
                    ++this.fieldB_;
                } else {
                    ++this.fieldC_;
                }
                return;
            }
            case PSEUDO_CLASS_CONDITION: {
                ++this.fieldD_;
                return;
            }
            case LANG_CONDITION: {
                ++this.fieldC_;
                return;
            }
        }
        throw new RuntimeException("Unhandled CSS condition type for specifity computation: '" + (Object)((Object)condition.getConditionType()) + "'.");
    }

    public String toString() {
        return this.fieldA_ + "," + this.fieldB_ + "," + this.fieldC_ + "," + this.fieldD_;
    }

    @Override
    public int compareTo(SelectorSpecificity other) {
        if (this.fieldA_ != other.fieldA_) {
            return this.fieldA_ - other.fieldA_;
        }
        if (this.fieldB_ != other.fieldB_) {
            return this.fieldB_ - other.fieldB_;
        }
        if (this.fieldC_ != other.fieldC_) {
            return this.fieldC_ - other.fieldC_;
        }
        if (this.fieldD_ != other.fieldD_) {
            return this.fieldD_ - other.fieldD_;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fieldA_;
        result = 31 * result + this.fieldB_;
        result = 31 * result + this.fieldC_;
        result = 31 * result + this.fieldD_;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectorSpecificity other = (SelectorSpecificity)obj;
        if (this.fieldA_ != other.fieldA_) {
            return false;
        }
        if (this.fieldB_ != other.fieldB_) {
            return false;
        }
        if (this.fieldC_ != other.fieldC_) {
            return false;
        }
        return this.fieldD_ == other.fieldD_;
    }
}

