/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import nl.basjes.parse.useragent.PackagedRules;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.MatcherList;
import nl.basjes.parse.useragent.analyze.UselessMatcherException;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.calculate.CalculateAgentEmail;
import nl.basjes.parse.useragent.calculate.CalculateAgentName;
import nl.basjes.parse.useragent.calculate.CalculateDeviceBrand;
import nl.basjes.parse.useragent.calculate.CalculateDeviceName;
import nl.basjes.parse.useragent.calculate.CalculateNetworkType;
import nl.basjes.parse.useragent.calculate.ConcatNONDuplicatedCalculator;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.calculate.MajorVersionCalculator;
import nl.basjes.parse.useragent.parse.UserAgentTreeFlattener;
import nl.basjes.parse.useragent.utils.YamlUtils;
import nl.basjes.parse.useragent.utils.YauaaVersion;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import nl.basjes.shaded.org.springframework.core.io.Resource;
import nl.basjes.shaded.org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import nl.basjes.shaded.org.yaml.snakeyaml.LoaderOptions;
import nl.basjes.shaded.org.yaml.snakeyaml.Yaml;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.Node;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.SequenceNode;
import nl.basjes.shaded.org.yaml.snakeyaml.reader.UnicodeReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultSerializer(value=KryoSerializer.class)
public abstract class AbstractUserAgentAnalyzerDirect
implements Analyzer,
Serializable {
    private static final int INFORM_ACTIONS_HASHMAP_CAPACITY = 1000000;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUserAgentAnalyzerDirect.class);
    private final ArrayList<Matcher> allMatchers = new ArrayList(5000);
    private final ArrayList<Matcher> zeroInputMatchers = new ArrayList(100);
    private final Map<String, Set<MatcherAction>> informMatcherActions = new LinkedHashMap<String, Set<MatcherAction>>(1000000);
    private transient Map<String, List<MappingNode>> matcherConfigs = new HashMap<String, List<MappingNode>>();
    private boolean showMatcherStats = false;
    private boolean doingOnlyASingleTest = false;
    protected Set<String> wantedFieldNames = null;
    private final ArrayList<Map<String, Map<String, String>>> testCases = new ArrayList(2048);
    private Map<String, Map<String, String>> lookups = new LinkedHashMap<String, Map<String, String>>(128);
    private final Map<String, Set<String>> lookupSets = new LinkedHashMap<String, Set<String>>(128);
    private final Map<String, Set<String>> lookupSetMerge = new LinkedHashMap<String, Set<String>>(128);
    protected UserAgentTreeFlattener flattener;
    public static final int DEFAULT_USER_AGENT_MAX_LENGTH = 2048;
    private int userAgentMaxLength = 2048;
    private boolean loadTests = false;
    private static final String DEFAULT_RESOURCES = "classpath*:UserAgents/**/*.yaml";
    private boolean delayInitialization = true;
    private boolean matchersHaveBeenInitialized = false;
    private volatile transient Set<String> allPossibleFieldNamesCache = null;
    private volatile transient List<String> allPossibleFieldNamesSortedCache = null;
    private final Map<String, Set<WordRangeVisitor.Range>> informMatcherActionRanges = new HashMap<String, Set<WordRangeVisitor.Range>>(10000);
    public static final int MAX_PREFIX_HASH_MATCH = 3;
    private final Map<String, Set<Integer>> informMatcherActionPrefixesLengths = new HashMap<String, Set<Integer>>(1000);
    private boolean verbose = false;
    private transient MatcherList touchedMatchers = null;
    private static final List<String> HARD_CODED_GENERATED_FIELDS = new ArrayList<String>();
    private final List<FieldCalculator> fieldCalculators = new ArrayList<FieldCalculator>();
    private static final long MAX_PRE_HEAT_ITERATIONS = 1000000L;

    protected List<Matcher> getAllMatchers() {
        return this.allMatchers;
    }

    public List<Map<String, Map<String, String>>> getTestCases() {
        return this.testCases;
    }

    @Override
    public Map<String, Map<String, String>> getLookups() {
        return this.lookups;
    }

    @Override
    public Map<String, Set<String>> getLookupSets() {
        return this.lookupSets;
    }

    private void initTransientFields() {
        this.matcherConfigs = new HashMap<String, List<MappingNode>>(64);
        this.touchedMatchers = new MatcherList(32);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.initTransientFields();
        stream.defaultReadObject();
        this.showDeserializationStats();
    }

    private void showDeserializationStats() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("This Analyzer instance was deserialized.");
        lines.add("");
        lines.add("Lookups      : " + (this.lookups == null ? 0 : this.lookups.size()));
        lines.add("LookupSets   : " + this.lookupSets.size());
        lines.add("Matchers     : " + this.allMatchers.size());
        lines.add("Hashmap size : " + this.informMatcherActions.size());
        lines.add("Ranges map   : " + this.informMatcherActionRanges.size());
        lines.add("Testcases    : " + this.testCases.size());
        YauaaVersion.logVersion(lines);
    }

    protected AbstractUserAgentAnalyzerDirect() {
    }

    public void delayInitialization() {
        this.delayInitialization = true;
    }

    public void immediateInitialization() {
        this.delayInitialization = false;
    }

    public AbstractUserAgentAnalyzerDirect setShowMatcherStats(boolean newShowMatcherStats) {
        this.showMatcherStats = newShowMatcherStats;
        return this;
    }

    public AbstractUserAgentAnalyzerDirect dropTests() {
        this.loadTests = false;
        this.testCases.clear();
        return this;
    }

    public AbstractUserAgentAnalyzerDirect keepTests() {
        this.loadTests = true;
        return this;
    }

    public boolean willKeepTests() {
        return this.loadTests;
    }

    public long getNumberOfTestCases() {
        return this.testCases.size();
    }

    public synchronized void destroy() {
        this.allMatchers.forEach(Matcher::destroy);
        this.allMatchers.clear();
        this.allMatchers.trimToSize();
        this.zeroInputMatchers.forEach(Matcher::destroy);
        this.zeroInputMatchers.clear();
        this.zeroInputMatchers.trimToSize();
        this.informMatcherActions.clear();
        this.matcherConfigs.clear();
        if (this.wantedFieldNames != null) {
            this.wantedFieldNames.clear();
        }
        this.testCases.clear();
        this.testCases.trimToSize();
        this.lookups.clear();
        this.lookupSets.clear();
        this.flattener.clear();
    }

    public void loadResources(String resourceString) {
        this.loadResources(resourceString, true, false);
    }

    private Yaml createYaml() {
        LoaderOptions yamlLoaderOptions = new LoaderOptions();
        yamlLoaderOptions.setMaxAliasesForCollections(100);
        return new Yaml(yamlLoaderOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResources(String resourceString, boolean showLoadMessages, boolean optionalResources) {
        int maxFilenameLength;
        TreeMap<String, Resource> resources;
        boolean loadingDefaultResources;
        Yaml yaml;
        long startFiles;
        block43: {
            Object object;
            if (this.matchersHaveBeenInitialized) {
                throw new IllegalStateException("Refusing to load additional resources after the datastructures have been initialized.");
            }
            this.allPossibleFieldNamesCache = null;
            this.allPossibleFieldNamesSortedCache = null;
            startFiles = System.nanoTime();
            yaml = this.createYaml();
            loadingDefaultResources = DEFAULT_RESOURCES.equals(resourceString);
            resources = new TreeMap<String, Resource>();
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            try {
                Resource[] resourceArray = resolver.getResources(resourceString);
                if (!loadingDefaultResources && showLoadMessages) {
                    LOG.info("Loading {} rule files using expression: {}", (Object)resourceArray.length, (Object)resourceString);
                }
                object = resourceArray;
                int n = ((Resource[])object).length;
                for (int i = 0; i < n; ++i) {
                    Resource resource = object[i];
                    if (!loadingDefaultResources && showLoadMessages) {
                        LOG.info("- Preparing {} ({} bytes)", (Object)resource.getFilename(), (Object)resource.contentLength());
                    }
                    resources.put(resource.getFilename(), resource);
                }
            }
            catch (IOException e) {
                if (optionalResources) {
                    LOG.error("The specified (optional) resource string is invalid: {}", (Object)resourceString);
                    return;
                }
                throw new InvalidParserConfigurationException("Error reading resources: " + e.getMessage(), e);
            }
            this.doingOnlyASingleTest = false;
            maxFilenameLength = 0;
            if (!resources.isEmpty() && (object = resources.entrySet().iterator()).hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                Resource resource = (Resource)entry.getValue();
                InputStream ignored = null;
                try {
                    ignored = resource.getInputStream();
                }
                catch (IOException e) {
                    LOG.error("Cannot load the resources (usually classloading problem).");
                    LOG.error("- Resource   : {}", (Object)resource);
                    LOG.error("- Filename   : {}", (Object)resource.getFilename());
                    LOG.error("- Description: {}", (Object)resource.getDescription());
                    if (loadingDefaultResources) {
                        LOG.warn("Falling back to the built in list of resources");
                        resources.clear();
                        break block43;
                    }
                    LOG.error("FATAL: Unable to load the specified resources for {}", (Object)resourceString);
                    throw new InvalidParserConfigurationException("Error reading resources (" + resourceString + "): " + e.getMessage(), e);
                }
                finally {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        if (resources.isEmpty()) {
            if (optionalResources) {
                LOG.warn("NO optional resources were loaded from expression: {}", (Object)resourceString);
            } else {
                LOG.error("NO config files were found matching this expression: {}", (Object)resourceString);
                if (loadingDefaultResources) {
                    LOG.warn("Unable to load the default resources, usually caused by classloader problems.");
                    LOG.warn("Retrying with built in list.");
                    PackagedRules.getRuleFileNames().forEach(s -> this.loadResources((String)s, false, false));
                } else {
                    LOG.warn("If you are using wildcards in your expression then try explicitly naming all yamls files explicitly.");
                    throw new InvalidParserConfigurationException("There were no resources found for the expression: " + resourceString);
                }
            }
            return;
        }
        Set resourceBasenames = resources.keySet().stream().map(k -> k.replaceAll("^.*/", "")).collect(Collectors.toSet());
        Set alreadyLoadedResourceBasenames = this.matcherConfigs.keySet().stream().map(k -> k.replaceAll("^.*/", "")).collect(Collectors.toSet());
        alreadyLoadedResourceBasenames.retainAll(resourceBasenames);
        if (!alreadyLoadedResourceBasenames.isEmpty()) {
            LOG.error("Trying to load these {} resources for the second time: {}", (Object)alreadyLoadedResourceBasenames.size(), alreadyLoadedResourceBasenames);
            throw new InvalidParserConfigurationException("Trying to load " + alreadyLoadedResourceBasenames.size() + " resources for the second time");
        }
        for (Map.Entry resourceEntry : resources.entrySet()) {
            try {
                Resource resource = (Resource)resourceEntry.getValue();
                String filename = resource.getFilename();
                if (filename == null) continue;
                maxFilenameLength = Math.max(maxFilenameLength, filename.length());
                this.loadYaml(yaml, resource.getInputStream(), filename);
            }
            catch (IOException e) {
                throw new InvalidParserConfigurationException("Error reading resources: " + e.getMessage(), e);
            }
        }
        long stopFiles = System.nanoTime();
        try (Formatter msg = new Formatter(Locale.ENGLISH);){
            msg.format("- Loaded %2d files in %4d msec using expression: %s", resources.size(), (stopFiles - startFiles) / 1000000L, resourceString);
            LOG.info(msg.toString());
        }
        if (resources.isEmpty()) {
            throw new InvalidParserConfigurationException("No matchers were loaded at all.");
        }
    }

    protected synchronized void finalizeLoadingRules() {
        YauaaVersion.logVersion(new String[0]);
        this.flattener = new UserAgentTreeFlattener(this);
        if (this.wantedFieldNames != null) {
            int wantedSize = this.wantedFieldNames.size();
            if (this.wantedFieldNames.contains("__Set_ALL_Fields__")) {
                --wantedSize;
            }
            LOG.info("Building all needed matchers for the requested {} fields.", (Object)wantedSize);
        } else {
            LOG.info("Building all matchers for all possible fields.");
        }
        if (this.matcherConfigs.isEmpty()) {
            throw new InvalidParserConfigurationException("No matchers were loaded at all.");
        }
        if (this.lookups != null && !this.lookups.isEmpty()) {
            LinkedHashMap<String, Map<String, String>> cleanedLookups = new LinkedHashMap<String, Map<String, String>>(this.lookups.size());
            for (Map.Entry<String, Map<String, String>> lookupsEntry : this.lookups.entrySet()) {
                LinkedHashMap<String, String> cleanedLookup = new LinkedHashMap<String, String>(lookupsEntry.getValue().size());
                for (Map.Entry<String, String> entry : lookupsEntry.getValue().entrySet()) {
                    cleanedLookup.put(entry.getKey().toLowerCase(), entry.getValue());
                }
                cleanedLookups.put(lookupsEntry.getKey(), cleanedLookup);
            }
            this.lookups = cleanedLookups;
        }
        if (!this.lookupSetMerge.isEmpty()) {
            this.lookupSetMerge.forEach((set, allExtraToLoad) -> {
                Set<String> theSet = this.lookupSets.get(set);
                if (theSet != null) {
                    allExtraToLoad.forEach(extraToLoad -> {
                        Set<String> extralookupSet;
                        Map<String, String> extralookup = this.lookups.get(extraToLoad);
                        if (extralookup != null) {
                            theSet.addAll(extralookup.keySet());
                        }
                        if ((extralookupSet = this.lookupSets.get(extraToLoad)) != null) {
                            theSet.addAll(extralookupSet);
                        }
                    });
                }
            });
        }
        this.allMatchers.clear();
        for (Map.Entry<String, List<MappingNode>> matcherConfigEntry : this.matcherConfigs.entrySet()) {
            int skippedMatchers = 0;
            String configFilename = matcherConfigEntry.getKey();
            List<MappingNode> matcherConfig = matcherConfigEntry.getValue();
            if (matcherConfig == null) continue;
            long start = System.nanoTime();
            int startSkipped = skippedMatchers;
            for (MappingNode map : matcherConfig) {
                try {
                    this.allMatchers.add(new Matcher(this, this.wantedFieldNames, map, configFilename));
                }
                catch (UselessMatcherException ume) {
                    ++skippedMatchers;
                }
            }
            long stop = System.nanoTime();
            int stopSkipped = skippedMatchers;
            if (!this.showMatcherStats) continue;
            Formatter msg = new Formatter(Locale.ENGLISH);
            Throwable throwable = null;
            try {
                String format = "Loading %4d (dropped %4d) matchers from %-20s took %5d msec";
                msg.format(format, matcherConfig.size() - (stopSkipped - startSkipped), stopSkipped - startSkipped, configFilename, (stop - start) / 1000000L);
                LOG.info(msg.toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (msg == null) continue;
                if (throwable != null) {
                    try {
                        msg.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                msg.close();
            }
        }
        this.verifyWeAreNotAskingForImpossibleFields();
        if (!this.delayInitialization) {
            this.initializeMatchers();
        }
    }

    protected void verifyWeAreNotAskingForImpossibleFields() {
        if (this.wantedFieldNames == null) {
            return;
        }
        ArrayList<String> impossibleFields = new ArrayList<String>();
        List<String> allPossibleFields = this.getAllPossibleFieldNamesSorted();
        for (String wantedFieldName : this.wantedFieldNames) {
            if (UserAgent.MutableUserAgent.isSystemField(wantedFieldName) || allPossibleFields.contains(wantedFieldName)) continue;
            impossibleFields.add(wantedFieldName);
        }
        if (impossibleFields.isEmpty()) {
            return;
        }
        throw new InvalidParserConfigurationException("We cannot provide these fields:" + ((Object)impossibleFields).toString());
    }

    public void initializeMatchers() {
        if (this.matchersHaveBeenInitialized) {
            return;
        }
        LOG.info("Initializing Analyzer data structures");
        if (this.allMatchers.isEmpty()) {
            throw new InvalidParserConfigurationException("No matchers were loaded at all.");
        }
        long start = System.nanoTime();
        this.allMatchers.forEach(Matcher::initialize);
        long stop = System.nanoTime();
        this.matchersHaveBeenInitialized = true;
        LOG.info("Built in {} msec : Hashmap {}, Ranges map:{}", new Object[]{(stop - start) / 1000000L, this.informMatcherActions.size(), this.informMatcherActionRanges.size()});
        for (Matcher matcher : this.allMatchers) {
            if (matcher.getActionsThatRequireInput() != 0L) continue;
            this.zeroInputMatchers.add(matcher);
        }
        for (Matcher matcher : this.allMatchers) {
            matcher.reset();
        }
        this.touchedMatchers = new MatcherList(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllPossibleFieldNames() {
        if (this.allPossibleFieldNamesCache == null) {
            AbstractUserAgentAnalyzerDirect abstractUserAgentAnalyzerDirect = this;
            synchronized (abstractUserAgentAnalyzerDirect) {
                if (this.allPossibleFieldNamesCache == null) {
                    TreeSet<String> names = new TreeSet<String>(HARD_CODED_GENERATED_FIELDS);
                    for (Matcher matcher : this.allMatchers) {
                        names.addAll(matcher.getAllPossibleFieldNames());
                    }
                    this.allPossibleFieldNamesCache = names;
                }
            }
        }
        return this.allPossibleFieldNamesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllPossibleFieldNamesSorted() {
        if (this.allPossibleFieldNamesSortedCache == null) {
            AbstractUserAgentAnalyzerDirect abstractUserAgentAnalyzerDirect = this;
            synchronized (abstractUserAgentAnalyzerDirect) {
                if (this.allPossibleFieldNamesSortedCache == null) {
                    ArrayList<String> fieldNames = new ArrayList<String>(this.getAllPossibleFieldNames());
                    Collections.sort(fieldNames);
                    ArrayList<String> names = new ArrayList<String>();
                    for (String fieldName : UserAgent.PRE_SORTED_FIELDS_LIST) {
                        fieldNames.remove(fieldName);
                        names.add(fieldName);
                    }
                    names.addAll(fieldNames);
                    this.allPossibleFieldNamesSortedCache = names;
                }
            }
        }
        return this.allPossibleFieldNamesSortedCache;
    }

    void loadYaml(String yamlString, String filename) {
        this.loadYaml(this.createYaml(), new ByteArrayInputStream(yamlString.getBytes(StandardCharsets.UTF_8)), filename);
    }

    private synchronized void loadYaml(Yaml yaml, InputStream yamlStream, String filename) {
        Node loadedYaml;
        try {
            loadedYaml = yaml.compose(new UnicodeReader(yamlStream));
        }
        catch (Exception e) {
            throw new InvalidParserConfigurationException("Parse error in the file " + filename + ": " + e.getMessage(), e);
        }
        if (loadedYaml == null) {
            LOG.warn("The file {} is empty", (Object)filename);
            return;
        }
        YamlUtils.requireNodeInstanceOf(MappingNode.class, loadedYaml, filename, "File must be a Map");
        MappingNode rootNode = (MappingNode)loadedYaml;
        NodeTuple configNodeTuple = null;
        for (NodeTuple tuple : rootNode.getValue()) {
            String name = YamlUtils.getKeyAsString(tuple, filename);
            if ("config".equals(name)) {
                configNodeTuple = tuple;
                break;
            }
            if (!"version".equals(name)) continue;
            YauaaVersion.assertSameVersion(tuple, filename);
            return;
        }
        YamlUtils.require(configNodeTuple != null, loadedYaml, filename, "The top level entry MUST be 'config'.");
        SequenceNode configNode = YamlUtils.getValueAsSequenceNode(configNodeTuple, filename);
        List<Node> configList = configNode.getValue();
        block15: for (Node configEntry : configList) {
            String entryType;
            YamlUtils.requireNodeInstanceOf(MappingNode.class, configEntry, filename, "The entry MUST be a mapping");
            NodeTuple entry = YamlUtils.getExactlyOneNodeTuple((MappingNode)configEntry, filename);
            MappingNode actualEntry = YamlUtils.getValueAsMappingNode(entry, filename);
            switch (entryType = YamlUtils.getKeyAsString(entry, filename)) {
                case "lookup": {
                    this.loadYamlLookup(actualEntry, filename);
                    continue block15;
                }
                case "set": {
                    this.loadYamlLookupSets(actualEntry, filename);
                    continue block15;
                }
                case "matcher": {
                    this.loadYamlMatcher(actualEntry, filename);
                    continue block15;
                }
                case "test": {
                    if (!this.loadTests) continue block15;
                    this.loadYamlTestcase(actualEntry, filename);
                    continue block15;
                }
            }
            throw new InvalidParserConfigurationException("Yaml config.(" + filename + ":" + actualEntry.getStartMark().getLine() + "): Found unexpected config entry: " + entryType + ", allowed are 'lookup', 'set', 'matcher' and 'test'");
        }
    }

    private void loadYamlLookup(MappingNode entry, String filename) {
        String name = null;
        HashMap<String, String> map = null;
        block8: for (NodeTuple tuple : entry.getValue()) {
            switch (YamlUtils.getKeyAsString(tuple, filename)) {
                case "name": {
                    name = YamlUtils.getValueAsString(tuple, filename);
                    break;
                }
                case "map": {
                    if (map == null) {
                        map = new HashMap<String, String>();
                    }
                    List<NodeTuple> mappings = YamlUtils.getValueAsMappingNode(tuple, filename).getValue();
                    for (NodeTuple mapping : mappings) {
                        String key = YamlUtils.getKeyAsString(mapping, filename);
                        String value = YamlUtils.getValueAsString(mapping, filename);
                        if (map.containsKey(key)) {
                            throw new InvalidParserConfigurationException("In the lookup \"" + name + "\" the key \"" + key + "\" appears multiple times.");
                        }
                        map.put(key, value);
                    }
                    continue block8;
                }
            }
        }
        YamlUtils.require(name != null && map != null, entry, filename, "Invalid lookup specified");
        this.lookups.put(name, map);
    }

    private void loadYamlLookupSets(MappingNode entry, String filename) {
        String name = null;
        LinkedHashSet<String> lookupSet = new LinkedHashSet<String>();
        LinkedHashSet<String> merge = new LinkedHashSet<String>();
        block10: for (NodeTuple tuple : entry.getValue()) {
            switch (YamlUtils.getKeyAsString(tuple, filename)) {
                case "name": {
                    name = YamlUtils.getValueAsString(tuple, filename);
                    break;
                }
                case "merge": {
                    merge.addAll(YamlUtils.getStringValues(YamlUtils.getValueAsSequenceNode(tuple, filename), filename));
                    break;
                }
                case "values": {
                    SequenceNode node = YamlUtils.getValueAsSequenceNode(tuple, filename);
                    for (String value : YamlUtils.getStringValues(node, filename)) {
                        lookupSet.add(value.toLowerCase(Locale.ENGLISH));
                    }
                    continue block10;
                }
            }
        }
        if (!merge.isEmpty()) {
            this.lookupSetMerge.put(name, merge);
        }
        this.lookupSets.put(name, lookupSet);
    }

    private void loadYamlMatcher(MappingNode entry, String filename) {
        List matcherConfigList = this.matcherConfigs.computeIfAbsent(filename, k -> new ArrayList(32));
        matcherConfigList.add(entry);
    }

    private void loadYamlTestcase(MappingNode entry, String filename) {
        if (!this.doingOnlyASingleTest) {
            HashMap<String, String> metaData = new HashMap<String, String>();
            metaData.put("filename", filename);
            metaData.put("fileline", String.valueOf(entry.getStartMark().getLine()));
            HashMap<String, String> input = null;
            List<String> options = null;
            LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
            block10: for (NodeTuple tuple : entry.getValue()) {
                String name;
                switch (name = YamlUtils.getKeyAsString(tuple, filename)) {
                    case "options": {
                        options = YamlUtils.getStringValues(tuple.getValueNode(), filename);
                        if (!options.contains("only")) break;
                        this.doingOnlyASingleTest = true;
                        this.testCases.clear();
                        break;
                    }
                    case "input": {
                        for (NodeTuple inputTuple : YamlUtils.getValueAsMappingNode(tuple, filename).getValue()) {
                            String inputName = YamlUtils.getKeyAsString(inputTuple, filename);
                            if (!"user_agent_string".equals(inputName)) continue;
                            String inputString = YamlUtils.getValueAsString(inputTuple, filename);
                            input = new HashMap<String, String>();
                            input.put(inputName, inputString);
                        }
                        continue block10;
                    }
                    case "expected": {
                        List<NodeTuple> mappings = YamlUtils.getValueAsMappingNode(tuple, filename).getValue();
                        for (NodeTuple mapping : mappings) {
                            String key = YamlUtils.getKeyAsString(mapping, filename);
                            String value = YamlUtils.getValueAsString(mapping, filename);
                            expected.put(key, value);
                        }
                        continue block10;
                    }
                }
            }
            YamlUtils.require(input != null, entry, filename, "Test is missing input");
            if (expected.isEmpty()) {
                this.doingOnlyASingleTest = true;
                this.testCases.clear();
            }
            LinkedHashMap testCase = new LinkedHashMap();
            testCase.put("input", input);
            if (!expected.isEmpty()) {
                testCase.put("expected", expected);
            }
            if (options != null) {
                LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>(options.size());
                for (String option : options) {
                    optionsMap.put(option, option);
                }
                testCase.put("options", optionsMap);
            }
            testCase.put("metaData", metaData);
            this.testCases.add(testCase);
        }
    }

    @Override
    public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        Set ranges = this.informMatcherActionRanges.computeIfAbsent(treeName, k -> new LinkedHashSet(4));
        ranges.add(range);
    }

    public static int firstCharactersForPrefixHashLength(String input, int maxChars) {
        return Math.min(maxChars, Math.min(3, input.length()));
    }

    public static String firstCharactersForPrefixHash(String input, int maxChars) {
        return input.substring(0, AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHashLength(input, maxChars));
    }

    @Override
    public void informMeAboutPrefix(MatcherAction matcherAction, String treeName, String prefix) {
        this.informMeAbout(matcherAction, treeName + "{\"" + AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHash(prefix, 3) + "\"");
        Set lengths = this.informMatcherActionPrefixesLengths.computeIfAbsent(treeName, k -> new LinkedHashSet(4));
        lengths.add(AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHashLength(prefix, 3));
    }

    @Override
    public Set<Integer> getRequiredPrefixLengths(String treeName) {
        return this.informMatcherActionPrefixesLengths.get(treeName);
    }

    @Override
    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        String hashKey = keyPattern.toLowerCase();
        Set analyzerSet = this.informMatcherActions.computeIfAbsent(hashKey, k -> new LinkedHashSet());
        analyzerSet.add(matcherAction);
    }

    public synchronized void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
        this.flattener.setVerbose(newVerbose);
    }

    public void setUserAgentMaxLength(int newUserAgentMaxLength) {
        this.userAgentMaxLength = newUserAgentMaxLength <= 0 ? 2048 : newUserAgentMaxLength;
    }

    public int getUserAgentMaxLength() {
        return this.userAgentMaxLength;
    }

    private void setAsHacker(UserAgent.MutableUserAgent userAgent, int confidence) {
        userAgent.set("DeviceClass", "Hacker", confidence);
        userAgent.set("DeviceBrand", "Hacker", confidence);
        userAgent.set("DeviceName", "Hacker", confidence);
        userAgent.set("DeviceVersion", "Hacker", confidence);
        userAgent.set("OperatingSystemClass", "Hacker", confidence);
        userAgent.set("OperatingSystemName", "Hacker", confidence);
        userAgent.set("OperatingSystemVersion", "Hacker", confidence);
        userAgent.set("LayoutEngineClass", "Hacker", confidence);
        userAgent.set("LayoutEngineName", "Hacker", confidence);
        userAgent.set("LayoutEngineVersion", "Hacker", confidence);
        userAgent.set("LayoutEngineVersionMajor", "Hacker", confidence);
        userAgent.set("AgentClass", "Hacker", confidence);
        userAgent.set("AgentName", "Hacker", confidence);
        userAgent.set("AgentVersion", "Hacker", confidence);
        userAgent.set("AgentVersionMajor", "Hacker", confidence);
        userAgent.set("HackerToolkit", "Unknown", confidence);
        userAgent.set("HackerAttackVector", "Unknown", confidence);
    }

    @Override
    public void receivedInput(Matcher matcher) {
        if (this.zeroInputMatchers.contains(matcher)) {
            return;
        }
        this.touchedMatchers.add(matcher);
    }

    public void reset() {
        for (Matcher matcher : this.touchedMatchers) {
            matcher.reset();
        }
        this.touchedMatchers.clear();
        for (Matcher matcher : this.zeroInputMatchers) {
            matcher.reset();
        }
    }

    public UserAgent.ImmutableUserAgent parse(String userAgentString) {
        UserAgent.MutableUserAgent userAgent = new UserAgent.MutableUserAgent(userAgentString, this.wantedFieldNames);
        return this.parse(userAgent);
    }

    public synchronized UserAgent.ImmutableUserAgent parse(UserAgent.MutableUserAgent userAgent) {
        this.initializeMatchers();
        String useragentString = userAgent.getUserAgentString();
        if (useragentString != null && useragentString.length() > this.userAgentMaxLength) {
            this.setAsHacker(userAgent, 100);
            userAgent.setForced("HackerAttackVector", "Buffer overflow", 100L);
            return new UserAgent.ImmutableUserAgent(this.hardCodedPostProcessing(userAgent));
        }
        this.reset();
        if (userAgent.isDebug()) {
            for (Matcher matcher : this.allMatchers) {
                matcher.setVerboseTemporarily(true);
            }
        }
        try {
            userAgent = this.flattener.parse(userAgent);
            this.inform("__SyntaxError__", userAgent.getValue("__SyntaxError__"), null);
            if (this.verbose) {
                LOG.info("=========== Checking all Touched Matchers: {}", (Object)this.touchedMatchers.size());
            }
            for (Matcher matcher : this.touchedMatchers) {
                matcher.analyze(userAgent);
            }
            if (this.verbose) {
                LOG.info("=========== Checking all Zero Input Matchers: {}", (Object)this.zeroInputMatchers.size());
            }
            for (Matcher matcher : this.zeroInputMatchers) {
                matcher.analyze(userAgent);
            }
            userAgent.processSetAll();
        }
        catch (RuntimeException rte) {
            userAgent.reset();
            this.setAsHacker(userAgent, 10000);
            userAgent.setForced("HackerAttackVector", "Yauaa Exploit", 10000L);
        }
        return new UserAgent.ImmutableUserAgent(this.hardCodedPostProcessing(userAgent));
    }

    public boolean isWantedField(String fieldName) {
        if (this.wantedFieldNames == null) {
            return true;
        }
        return this.wantedFieldNames.contains(fieldName);
    }

    protected void setFieldCalculators(List<FieldCalculator> newFieldCalculators) {
        this.fieldCalculators.addAll(newFieldCalculators);
    }

    private UserAgent.MutableUserAgent hardCodedPostProcessing(UserAgent.MutableUserAgent userAgent) {
        if ("true".equals(userAgent.getValue("__SyntaxError__")) && userAgent.get("DeviceClass").getConfidence() == -1L) {
            this.setAsHacker(userAgent, 10);
        }
        for (FieldCalculator fieldCalculator : this.fieldCalculators) {
            if (this.verbose) {
                LOG.info("Running FieldCalculator: {}", (Object)fieldCalculator);
            }
            fieldCalculator.calculate(userAgent);
        }
        return userAgent;
    }

    @Override
    public Set<WordRangeVisitor.Range> getRequiredInformRanges(String treeName) {
        return this.informMatcherActionRanges.computeIfAbsent(treeName, k -> Collections.emptySet());
    }

    @Override
    public void inform(String key, String value, ParseTree ctx) {
        this.inform(key, key, value, ctx);
        this.inform(key + "=\"" + value + '\"', key, value, ctx);
        Set<Integer> lengths = this.getRequiredPrefixLengths(key);
        if (lengths != null) {
            int valueLength = value.length();
            for (Integer prefixLength : lengths) {
                if (valueLength < prefixLength) continue;
                this.inform(key + "{\"" + AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHash(value, prefixLength) + '\"', key, value, ctx);
            }
        }
    }

    private void inform(String match, String key, String value, ParseTree ctx) {
        Set<MatcherAction> relevantActions = this.informMatcherActions.get(match.toLowerCase(Locale.ENGLISH));
        if (this.verbose) {
            if (relevantActions == null) {
                LOG.info("--- Have (0): {}", (Object)match);
            } else {
                LOG.info("+++ Have ({}): {}", (Object)relevantActions.size(), (Object)match);
                int count = 1;
                for (MatcherAction action : relevantActions) {
                    LOG.info("+++ -------> ({}): {}", (Object)count, (Object)action);
                    ++count;
                }
            }
        }
        if (relevantActions != null) {
            for (MatcherAction matcherAction : relevantActions) {
                matcherAction.inform(key, value, ctx);
            }
        }
    }

    public long preHeat() {
        return this.preHeat(this.testCases.size(), true);
    }

    public long preHeat(long preheatIterations) {
        return this.preHeat(preheatIterations, true);
    }

    public long preHeat(long preheatIterations, boolean log) {
        if (this.testCases.isEmpty()) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because there are no test cases available.");
            return 0L;
        }
        if (preheatIterations <= 0L) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because you asked for {} to run.", (Object)preheatIterations);
            return 0L;
        }
        if (preheatIterations > 1000000L) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because you asked for too many ({} > {}) to run.", (Object)preheatIterations, (Object)1000000L);
            return 0L;
        }
        if (log) {
            LOG.info("Preheating JVM by running {} testcases.", (Object)preheatIterations);
        }
        long remainingIterations = preheatIterations;
        long goodResults = 0L;
        block0: while (remainingIterations > 0L) {
            for (Map<String, Map<String, String>> test : this.testCases) {
                Map<String, String> input = test.get("input");
                String userAgentString = input.get("user_agent_string");
                --remainingIterations;
                if (!this.parse(userAgentString).hasSyntaxError()) {
                    ++goodResults;
                }
                if (remainingIterations > 0L) continue;
                continue block0;
            }
        }
        if (log) {
            LOG.info("Preheating JVM completed. ({} of {} were proper results)", (Object)goodResults, (Object)preheatIterations);
        }
        return preheatIterations;
    }

    public static List<String> getAllPaths(String agent) {
        return new GetAllPathsAnalyzer(agent).getValues();
    }

    public static GetAllPathsAnalyzer getAllPathsAnalyzer(String agent) {
        return new GetAllPathsAnalyzer(agent);
    }

    public String toString() {
        return "UserAgentAnalyzerDirect{\nallMatchers=" + this.allMatchers + "\n, zeroInputMatchers=" + this.zeroInputMatchers + "\n, informMatcherActions=" + this.informMatcherActions + "\n, showMatcherStats=" + this.showMatcherStats + "\n, doingOnlyASingleTest=" + this.doingOnlyASingleTest + "\n, wantedFieldNames=" + this.wantedFieldNames + "\n, testCases=" + this.testCases + "\n, lookups=" + this.lookups + "\n, lookupSets=" + this.lookupSets + "\n, flattener=" + this.flattener + "\n, userAgentMaxLength=" + this.userAgentMaxLength + "\n, loadTests=" + this.loadTests + "\n, delayInitialization=" + this.delayInitialization + "\n, matchersHaveBeenInitialized=" + this.matchersHaveBeenInitialized + "\n, verbose=" + this.verbose + "\n, fieldCalculators=" + this.fieldCalculators + "\n}";
    }

    static {
        HARD_CODED_GENERATED_FIELDS.add("__SyntaxError__");
        HARD_CODED_GENERATED_FIELDS.add("AgentVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("AgentNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("AgentNameVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineNameVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("OperatingSystemNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("OperatingSystemNameVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("WebviewAppVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("WebviewAppNameVersionMajor");
    }

    public static abstract class AbstractUserAgentAnalyzerDirectBuilder<UAA extends AbstractUserAgentAnalyzerDirect, B extends AbstractUserAgentAnalyzerDirectBuilder<UAA, B>> {
        private final UAA uaa;
        private boolean didBuildStep = false;
        private int preheatIterations = 0;
        private final List<String> resources = new ArrayList<String>();
        private final List<String> optionalResources = new ArrayList<String>();
        private final List<String> yamlRules = new ArrayList<String>();
        private final List<FieldCalculator> fieldCalculators = new ArrayList<FieldCalculator>();

        protected void failIfAlreadyBuilt() {
            if (this.didBuildStep) {
                throw new IllegalStateException("A builder can provide only a single instance. It is not allowed to set values after doing build()");
            }
        }

        protected AbstractUserAgentAnalyzerDirectBuilder(UAA newUaa) {
            this.uaa = newUaa;
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setShowMatcherStats(false);
            this.resources.add(AbstractUserAgentAnalyzerDirect.DEFAULT_RESOURCES);
        }

        public B dropDefaultResources() {
            this.failIfAlreadyBuilt();
            this.resources.remove(AbstractUserAgentAnalyzerDirect.DEFAULT_RESOURCES);
            return (B)this;
        }

        public B addResources(String resourceString) {
            this.failIfAlreadyBuilt();
            this.resources.add(resourceString);
            return (B)this;
        }

        public B addOptionalResources(String resourceString) {
            this.failIfAlreadyBuilt();
            this.optionalResources.add(resourceString);
            return (B)this;
        }

        public B addYamlRule(String yamlRule) {
            this.failIfAlreadyBuilt();
            this.yamlRules.add(yamlRule);
            return (B)this;
        }

        public B preheat(int iterations) {
            this.failIfAlreadyBuilt();
            this.preheatIterations = iterations;
            return (B)this;
        }

        public B preheat() {
            this.failIfAlreadyBuilt();
            this.preheatIterations = -1;
            return (B)this;
        }

        public B withField(String fieldName) {
            this.failIfAlreadyBuilt();
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames == null) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames = new TreeSet<String>();
            }
            ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames.add(fieldName);
            return (B)this;
        }

        public B withFields(Collection<String> fieldNames) {
            for (String fieldName : fieldNames) {
                this.withField(fieldName);
            }
            return (B)this;
        }

        public B withFields(String ... fieldNames) {
            for (String fieldName : fieldNames) {
                this.withField(fieldName);
            }
            return (B)this;
        }

        public B withAllFields() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames = null;
            return (B)this;
        }

        public B showMatcherLoadStats() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setShowMatcherStats(true);
            return (B)this;
        }

        public B hideMatcherLoadStats() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setShowMatcherStats(false);
            return (B)this;
        }

        public B withUserAgentMaxLength(int newUserAgentMaxLength) {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setUserAgentMaxLength(newUserAgentMaxLength);
            return (B)this;
        }

        public B keepTests() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).keepTests();
            return (B)this;
        }

        public B dropTests() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).dropTests();
            return (B)this;
        }

        public B delayInitialization() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).delayInitialization();
            return (B)this;
        }

        public B immediateInitialization() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzerDirect)this.uaa).immediateInitialization();
            return (B)this;
        }

        private void addCalculator(FieldCalculator calculator) {
            this.fieldCalculators.add(calculator);
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames != null) {
                Collections.addAll(((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames, calculator.getDependencies());
            }
        }

        private void addCalculatedMajorVersionField(String result, String dependency) {
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).isWantedField(result)) {
                this.fieldCalculators.add(new MajorVersionCalculator(result, dependency));
                if (((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames != null) {
                    Collections.addAll(((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames, dependency);
                }
            }
        }

        private void addCalculatedConcatNONDuplicated(String result, String first, String second) {
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).isWantedField(result)) {
                this.fieldCalculators.add(new ConcatNONDuplicatedCalculator(result, first, second));
                if (((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames != null) {
                    Collections.addAll(((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames, first, second);
                }
            }
        }

        public UAA build() {
            boolean mustDropTestsLater;
            this.failIfAlreadyBuilt();
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames != null) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames.add("__Set_ALL_Fields__");
                ((AbstractUserAgentAnalyzerDirect)this.uaa).wantedFieldNames.add("DeviceClass");
            }
            this.addCalculatedConcatNONDuplicated("AgentNameVersionMajor", "AgentName", "AgentVersionMajor");
            this.addCalculatedConcatNONDuplicated("AgentNameVersion", "AgentName", "AgentVersion");
            this.addCalculatedMajorVersionField("AgentVersionMajor", "AgentVersion");
            this.addCalculatedConcatNONDuplicated("WebviewAppNameVersionMajor", "WebviewAppName", "WebviewAppVersionMajor");
            this.addCalculatedMajorVersionField("WebviewAppVersionMajor", "WebviewAppVersion");
            this.addCalculatedConcatNONDuplicated("LayoutEngineNameVersionMajor", "LayoutEngineName", "LayoutEngineVersionMajor");
            this.addCalculatedConcatNONDuplicated("LayoutEngineNameVersion", "LayoutEngineName", "LayoutEngineVersion");
            this.addCalculatedMajorVersionField("LayoutEngineVersionMajor", "LayoutEngineVersion");
            this.addCalculatedMajorVersionField("OperatingSystemNameVersionMajor", "OperatingSystemNameVersion");
            this.addCalculatedConcatNONDuplicated("OperatingSystemNameVersion", "OperatingSystemName", "OperatingSystemVersion");
            this.addCalculatedMajorVersionField("OperatingSystemVersionMajor", "OperatingSystemVersion");
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).isWantedField("AgentName")) {
                this.addCalculator(new CalculateAgentName());
            }
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).isWantedField("NetworkType")) {
                this.addCalculator(new CalculateNetworkType());
            }
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).isWantedField("DeviceName")) {
                this.addCalculator(new CalculateDeviceName());
            }
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).isWantedField("DeviceBrand")) {
                this.addCalculator(new CalculateDeviceBrand());
            }
            if (((AbstractUserAgentAnalyzerDirect)this.uaa).isWantedField("AgentInformationEmail")) {
                this.addCalculator(new CalculateAgentEmail());
            }
            Collections.reverse(this.fieldCalculators);
            ((AbstractUserAgentAnalyzerDirect)this.uaa).setFieldCalculators(this.fieldCalculators);
            boolean bl = mustDropTestsLater = !((AbstractUserAgentAnalyzerDirect)this.uaa).willKeepTests();
            if (this.preheatIterations != 0) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).keepTests();
            }
            this.optionalResources.forEach(resource -> ((AbstractUserAgentAnalyzerDirect)this.uaa).loadResources((String)resource, true, true));
            this.resources.forEach(resource -> ((AbstractUserAgentAnalyzerDirect)this.uaa).loadResources((String)resource, true, false));
            int yamlRuleCount = 1;
            for (String yamlRule : this.yamlRules) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).loadYaml(yamlRule, "Manually Inserted Rules " + yamlRuleCount++);
            }
            ((AbstractUserAgentAnalyzerDirect)this.uaa).finalizeLoadingRules();
            if (this.preheatIterations < 0) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).preHeat();
            } else if (this.preheatIterations > 0) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).preHeat(this.preheatIterations);
            }
            if (mustDropTestsLater) {
                ((AbstractUserAgentAnalyzerDirect)this.uaa).dropTests();
            }
            this.didBuildStep = true;
            return this.uaa;
        }
    }

    public static class GetAllPathsAnalyzer
    implements Analyzer {
        private final List<String> values = new ArrayList<String>(128);
        private final UserAgent result;

        GetAllPathsAnalyzer(String useragent) {
            UserAgentTreeFlattener flattener = new UserAgentTreeFlattener(this);
            this.result = flattener.parse(useragent);
        }

        public List<String> getValues() {
            return this.values;
        }

        public UserAgent getResult() {
            return this.result;
        }

        @Override
        public void inform(String path, String value, ParseTree ctx) {
            this.values.add(path);
            this.values.add(path + "=\"" + value + "\"");
            this.values.add(path + "{\"" + AbstractUserAgentAnalyzerDirect.firstCharactersForPrefixHash(value, 3) + "\"");
        }

        @Override
        public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        }

        @Override
        public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        }

        @Override
        public Set<WordRangeVisitor.Range> getRequiredInformRanges(String treeName) {
            return Collections.emptySet();
        }

        @Override
        public void informMeAboutPrefix(MatcherAction matcherAction, String treeName, String prefix) {
        }

        @Override
        public Set<Integer> getRequiredPrefixLengths(String treeName) {
            return Collections.emptySet();
        }

        @Override
        public Map<String, Map<String, String>> getLookups() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Set<String>> getLookupSets() {
            return Collections.emptyMap();
        }
    }

    public static class KryoSerializer
    extends FieldSerializer<AbstractUserAgentAnalyzerDirect> {
        public KryoSerializer(Kryo kryo, Class<?> type) {
            super(kryo, type);
        }

        public AbstractUserAgentAnalyzerDirect read(Kryo kryo, Input input, Class<AbstractUserAgentAnalyzerDirect> type) {
            AbstractUserAgentAnalyzerDirect uaa = (AbstractUserAgentAnalyzerDirect)super.read(kryo, input, type);
            uaa.initTransientFields();
            uaa.showDeserializationStats();
            return uaa;
        }
    }
}

