/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.VersionSplitter;

public class MajorVersionCalculator
implements FieldCalculator {
    private String versionName;
    private String majorVersionName;

    public MajorVersionCalculator(String majorVersionName, String versionName) {
        this.majorVersionName = majorVersionName;
        this.versionName = versionName;
    }

    private MajorVersionCalculator() {
    }

    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        AgentField agentVersionMajor = userAgent.get(this.majorVersionName);
        if (agentVersionMajor.isDefaultValue()) {
            AgentField agentVersion = userAgent.get(this.versionName);
            String version = "<<<null>>>";
            if (!agentVersion.isDefaultValue()) {
                version = VersionSplitter.getInstance().getSingleSplit(agentVersion.getValue(), 1);
            }
            userAgent.setForced(this.majorVersionName, version, agentVersion.getConfidence());
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{this.versionName};
    }

    public String toString() {
        return "Calculate " + this.versionName + " --> " + this.majorVersionName;
    }
}

