/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.editor.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.editor.constants.ModelDataJsonConstants;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.apache.commons.lang3.StringUtils;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelEditorJsonRestResource
extends ServerResource
implements ModelDataJsonConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ModelEditorJsonRestResource.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    @Get(value="json")
    public ObjectNode getEditorJson() {
        ObjectNode modelNode = null;
        String modelId = (String)this.getRequest().getAttributes().get("modelId");
        RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
        Model model = repositoryService.getModel(modelId);
        if (model != null) {
            try {
                if (StringUtils.isNotEmpty((CharSequence)model.getMetaInfo())) {
                    modelNode = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
                } else {
                    modelNode = this.objectMapper.createObjectNode();
                    modelNode.put("name", model.getName());
                }
                modelNode.put("modelId", model.getId());
                ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(new String(repositoryService.getModelEditorSource(model.getId()), "utf-8"));
                modelNode.put("model", (JsonNode)editorJsonNode);
            }
            catch (Exception e) {
                LOGGER.error("Error creating model JSON", (Throwable)e);
                this.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
        }
        return modelNode;
    }
}

