/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.lc.ibps.base.core.util.AppUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.ext.factory.BpmDelegateExecutionFactory;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ExecutionListenerInvocation;
import org.activiti.engine.impl.entity.SubProcessStartOrEndEventModel;
import org.activiti.engine.impl.event.SubProcessMultiInstanceStartEvent;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public abstract class MultiInstanceActivityBehavior
extends FlowNodeActivityBehavior
implements CompositeActivityBehavior,
org.activiti.engine.impl.pvm.delegate.SubProcessActivityBehavior {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MultiInstanceActivityBehavior.class);
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected ActivityImpl activity;
    protected AbstractBpmnActivityBehavior innerActivityBehavior;
    protected Expression loopCardinalityExpression;
    protected Expression completionConditionExpression;
    protected Expression collectionExpression;
    protected String collectionVariable;
    protected String collectionElementVariable;
    protected String collectionElementIndexVariable = "loopCounter";

    public MultiInstanceActivityBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.activity = activity;
        this.setInnerActivityBehavior(innerActivityBehavior);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        if (this.getLocalLoopVariable(execution, this.getCollectionElementIndexVariable()) == null) {
            try {
                SubProcessStartOrEndEventModel model = new SubProcessStartOrEndEventModel();
                model.bpmDelegateExecution = BpmDelegateExecutionFactory.getBpmDelegateExecution(execution);
                model.setNoteType("subMultiStartGateway");
                SubProcessMultiInstanceStartEvent event = new SubProcessMultiInstanceStartEvent(model);
                AppUtil.publishEvent((ApplicationEvent)event);
                execution.setVariableLocal("token_", 0);
                this.createInstances(execution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, execution);
            }
        } else {
            this.innerActivityBehavior.execute(execution);
        }
    }

    protected abstract void createInstances(ActivityExecution var1) throws Exception;

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        this.innerActivityBehavior.signal(execution, signalName, signalData);
    }

    @Override
    public void lastExecutionEnded(ActivityExecution execution) {
        ScopeUtil.createEventScopeExecution((ExecutionEntity)execution);
        this.leave(execution);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
    }

    @Override
    public void completed(ActivityExecution execution) throws Exception {
        this.leave(execution);
    }

    protected int resolveNrOfInstances(ActivityExecution execution) {
        int nrOfInstances = -1;
        if (this.loopCardinalityExpression != null) {
            nrOfInstances = this.resolveLoopCardinality(execution);
        } else if (this.collectionExpression != null) {
            Object obj = this.collectionExpression.getValue(execution);
            if (!(obj instanceof Collection)) {
                throw new ActivitiIllegalArgumentException(this.collectionExpression.getExpressionText() + "' didn't resolve to a Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else if (this.collectionVariable != null) {
            Object obj = execution.getVariable(this.collectionVariable);
            if (obj == null) {
                throw new ActivitiIllegalArgumentException("Variable " + this.collectionVariable + " is not found");
            }
            if (!(obj instanceof Collection)) {
                throw new ActivitiIllegalArgumentException("Variable " + this.collectionVariable + "' is not a Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else {
            throw new ActivitiIllegalArgumentException("Couldn't resolve collection expression nor variable reference");
        }
        return nrOfInstances;
    }

    protected void executeOriginalBehavior(ActivityExecution execution, int loopCounter) throws Exception {
        if (this.usesCollection() && this.collectionElementVariable != null) {
            Collection collection = null;
            if (this.collectionExpression != null) {
                collection = (Collection)this.collectionExpression.getValue(execution);
            } else if (this.collectionVariable != null) {
                collection = (Collection)execution.getVariable(this.collectionVariable);
            }
            Object value = null;
            Iterator it = collection.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
            this.setLoopVariable(execution, this.collectionElementVariable, value);
        }
        if (loopCounter == 0) {
            this.innerActivityBehavior.execute(execution);
        } else {
            execution.executeActivity(this.activity);
        }
    }

    protected boolean usesCollection() {
        return this.collectionExpression != null || this.collectionVariable != null;
    }

    protected boolean isExtraScopeNeeded() {
        return this.innerActivityBehavior instanceof SubProcessActivityBehavior;
    }

    protected int resolveLoopCardinality(ActivityExecution execution) {
        Object value = this.loopCardinalityExpression.getValue(execution);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new ActivitiIllegalArgumentException("Could not resolve loopCardinality expression '" + this.loopCardinalityExpression.getExpressionText() + "': not a number nor number String");
    }

    protected boolean completionConditionSatisfied(ActivityExecution execution) {
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue(execution);
            if (!(value instanceof Boolean)) {
                throw new ActivitiIllegalArgumentException("completionCondition '" + this.completionConditionExpression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    protected void setLoopVariable(ActivityExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected Integer getLoopVariable(ActivityExecution execution, String variableName) {
        Object value = execution.getVariableLocal(variableName);
        for (ActivityExecution parent = execution.getParent(); value == null && parent != null; parent = parent.getParent()) {
            value = parent.getVariableLocal(variableName);
        }
        return (Integer)value;
    }

    protected Integer getLocalLoopVariable(ActivityExecution execution, String variableName) {
        return (Integer)execution.getVariableLocal(variableName);
    }

    protected void callActivityEndListeners(ActivityExecution execution) {
        List<ExecutionListener> listeners = this.activity.getExecutionListeners("end");
        CallActivityEndListenersOperation atomicOperation = new CallActivityEndListenersOperation(listeners);
        Context.getCommandContext().performOperation(atomicOperation, (InterpretableExecution)execution);
    }

    protected void logLoopDetails(ActivityExecution execution, String custom, int loopCounter, int nrOfCompletedInstances, int nrOfActiveInstances, int nrOfInstances) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Multi-instance '" + execution.getActivity() + "' " + custom + ". Details: loopCounter=" + loopCounter + ", nrOrCompletedInstances=" + nrOfCompletedInstances + ",nrOfActiveInstances=" + nrOfActiveInstances + ",nrOfInstances=" + nrOfInstances + "");
        }
    }

    public Expression getLoopCardinalityExpression() {
        return this.loopCardinalityExpression;
    }

    public void setLoopCardinalityExpression(Expression loopCardinalityExpression) {
        this.loopCardinalityExpression = loopCardinalityExpression;
    }

    public Expression getCompletionConditionExpression() {
        return this.completionConditionExpression;
    }

    public void setCompletionConditionExpression(Expression completionConditionExpression) {
        this.completionConditionExpression = completionConditionExpression;
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public String getCollectionVariable() {
        return this.collectionVariable;
    }

    public void setCollectionVariable(String collectionVariable) {
        this.collectionVariable = collectionVariable;
    }

    public String getCollectionElementVariable() {
        return this.collectionElementVariable;
    }

    public void setCollectionElementVariable(String collectionElementVariable) {
        this.collectionElementVariable = collectionElementVariable;
    }

    public String getCollectionElementIndexVariable() {
        return this.collectionElementIndexVariable;
    }

    public void setCollectionElementIndexVariable(String collectionElementIndexVariable) {
        this.collectionElementIndexVariable = collectionElementIndexVariable;
    }

    public void setInnerActivityBehavior(AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.innerActivityBehavior = innerActivityBehavior;
        this.innerActivityBehavior.setMultiInstanceActivityBehavior(this);
    }

    public AbstractBpmnActivityBehavior getInnerActivityBehavior() {
        return this.innerActivityBehavior;
    }

    private static final class CallActivityEndListenersOperation
    implements AtomicOperation {
        private List<ExecutionListener> listeners;

        private CallActivityEndListenersOperation(List<ExecutionListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void execute(InterpretableExecution execution) {
            for (ExecutionListener executionListener : this.listeners) {
                try {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(executionListener, execution));
                }
                catch (Exception e) {
                    throw new ActivitiException("Couldn't execute end listener", e);
                }
            }
        }

        @Override
        public boolean isAsync(InterpretableExecution execution) {
            return false;
        }
    }
}

