/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cmd.ActivateProcessDefinitionCmd;
import org.activiti.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.repository.DeploymentBuilderImpl;
import org.activiti.engine.repository.Deployment;

public class DeployCmd<T>
implements Command<Deployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected DeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    @Override
    public Deployment execute(CommandContext commandContext) {
        DeploymentEntity existingDeployment;
        DeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        if (this.deploymentBuilder.isDuplicateFilterEnabled() && (existingDeployment = Context.getCommandContext().getDeploymentEntityManager().findLatestDeploymentByName(deployment.getName())) != null && !this.deploymentsDiffer(deployment, existingDeployment)) {
            return existingDeployment;
        }
        deployment.setNew(true);
        Context.getCommandContext().getDeploymentEntityManager().insertDeployment(deployment);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, deployment));
        }
        HashMap<String, Object> deploymentSettings = new HashMap<String, Object>();
        deploymentSettings.put("isBpmn20XsdValidationEnabled", this.deploymentBuilder.isBpmn20XsdValidationEnabled());
        deploymentSettings.put("isProcessValidationEnabled", this.deploymentBuilder.isProcessValidationEnabled());
        Context.getProcessEngineConfiguration().getDeploymentManager().deploy(deployment, deploymentSettings);
        if (this.deploymentBuilder.getProcessDefinitionsActivationDate() != null) {
            this.scheduleProcessDefinitionActivation(commandContext, deployment);
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, deployment));
        }
        return deployment;
    }

    protected boolean deploymentsDiffer(DeploymentEntity deployment, DeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map<String, ResourceEntity> resources = deployment.getResources();
        Map<String, ResourceEntity> savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            ResourceEntity resource;
            byte[] bytes;
            ResourceEntity savedResource = savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            if (savedResource.isGenerated() || Arrays.equals(bytes = (resource = resources.get(resourceName)).getBytes(), savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }

    protected void scheduleProcessDefinitionActivation(CommandContext commandContext, DeploymentEntity deployment) {
        for (ProcessDefinitionEntity processDefinitionEntity : deployment.getDeployedArtifacts(ProcessDefinitionEntity.class)) {
            SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionEntity, false, null, deployment.getTenantId());
            suspendProcessDefinitionCmd.execute(commandContext);
            ActivateProcessDefinitionCmd activateProcessDefinitionCmd = new ActivateProcessDefinitionCmd(processDefinitionEntity, false, this.deploymentBuilder.getProcessDefinitionsActivationDate(), deployment.getTenantId());
            activateProcessDefinitionCmd.execute(commandContext);
        }
    }
}

