/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import com.lc.ibps.base.core.engine.script.GroovyScriptEngine;
import com.lc.ibps.base.core.util.AppUtil;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.bpmn.api.cmd.ActionCmd;
import com.lc.ibps.bpmn.api.cmd.TaskFinishCmd;
import com.lc.ibps.bpmn.api.context.BpmnContextUtil;
import com.lc.ibps.bpmn.api.exception.WorkFlowException;
import java.util.Map;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.Condition;
import org.apache.commons.lang3.StringUtils;

public class GroovyCondition
implements Condition {
    private static final long serialVersionUID = -5577703954744892854L;
    private String script = "";

    public GroovyCondition(String condition) {
        this.script = condition;
    }

    @Override
    public boolean evaluate(DelegateExecution execution) {
        Map boMap;
        if (StringUtil.isBlank((CharSequence)this.script) || "null".equalsIgnoreCase(this.script)) {
            return true;
        }
        Map<String, Object> maps = execution.getVariables();
        String instId = (String)maps.get("instanceId_");
        maps.put("execution", execution);
        ActionCmd cmd = BpmnContextUtil.getActionCmd((String)instId);
        if (cmd instanceof TaskFinishCmd) {
            TaskFinishCmd taskCmd = (TaskFinishCmd)cmd;
            maps.put("taskCmd", taskCmd);
        }
        if (BeanUtils.isNotEmpty((Object)(boMap = (Map)cmd.getTransitVars("bo_inst_")))) {
            maps.putAll(boMap);
            maps.put("boMap", boMap);
        }
        GroovyScriptEngine engine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        String newScript = this.replaceSpecialChar(this.script);
        try {
            return engine.executeBoolean(newScript, maps);
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer("\u6761\u4ef6\u811a\u672c\u89e3\u6790\u5f02\u5e38\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            message.append("<br/><br/>\u8282\u70b9\uff1a" + execution.getCurrentActivityName() + "\u2014\u2014" + execution.getCurrentActivityId());
            message.append("<br/><br/>\u811a\u672c\uff1a" + this.script);
            message.append("<br/><br/>\u6d41\u7a0b\u53d8\u91cf\uff1a" + maps.toString());
            throw new WorkFlowException(message.toString());
        }
    }

    private String replaceSpecialChar(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        if ((str = str.trim()).startsWith("${")) {
            return str.substring(2, str.length() - 1);
        }
        return str;
    }
}

