/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.lc.ibps.base.core.util.AppUtil;
import java.util.List;
import org.activiti.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.entity.GatewayMetJoinEventModel;
import org.activiti.engine.impl.entity.GatewayUnmetJoinEventModel;
import org.activiti.engine.impl.event.GatewayMetJoinEvent;
import org.activiti.engine.impl.event.GatewayUnmetJoinEvent;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class ParallelGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ParallelGatewayActivityBehavior.class);

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        PvmActivity activity = execution.getActivity();
        List<PvmTransition> outgoingTransitions = execution.getActivity().getOutgoingTransitions();
        execution.inactivate();
        this.lockConcurrentRoot(execution);
        List<ActivityExecution> joinedExecutions = execution.findInactiveConcurrentExecutions(activity);
        int nbrOfExecutionsToJoin = execution.getActivity().getIncomingTransitions().size();
        int nbrOfExecutionsJoined = joinedExecutions.size();
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution);
        if (nbrOfExecutionsJoined == nbrOfExecutionsToJoin) {
            if (log.isDebugEnabled()) {
                log.debug("parallel gateway '" + activity.getId() + "' activates: " + nbrOfExecutionsJoined + " of " + nbrOfExecutionsToJoin + " joined");
            }
            if (execution.isEnded()) {
                GatewayMetJoinEventModel model = new GatewayMetJoinEventModel();
                model.activity = activity;
                model.activityExecution = execution;
                model.noteType = "parallelGateway";
                model.flag = "parallelGatewayEnd";
                GatewayMetJoinEvent event = new GatewayMetJoinEvent(model);
                AppUtil.publishEvent((ApplicationEvent)event);
            }
            execution.takeAll(outgoingTransitions, joinedExecutions);
        } else {
            GatewayUnmetJoinEventModel model = new GatewayUnmetJoinEventModel();
            model.activity = activity;
            model.activityExecution = execution;
            model.noteType = "parallelGateway";
            GatewayUnmetJoinEvent event = new GatewayUnmetJoinEvent(model);
            AppUtil.publishEvent((ApplicationEvent)event);
            if (log.isDebugEnabled()) {
                log.debug("parallel gateway '" + activity.getId() + "' does not activate: " + nbrOfExecutionsJoined + " of " + nbrOfExecutionsToJoin + " joined");
            }
        }
    }
}

