/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.lc.ibps.base.core.util.AppUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.entity.GatewayMetJoinEventModel;
import org.activiti.engine.impl.entity.GatewayUnmetJoinEventModel;
import org.activiti.engine.impl.event.GatewayMetJoinEvent;
import org.activiti.engine.impl.event.GatewayUnmetJoinEvent;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.springframework.context.ApplicationEvent;

public class ParallelMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    public ParallelMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    @Override
    protected void createInstances(ActivityExecution execution) throws Exception {
        ActivityExecution concurrentExecution;
        int loopCounter;
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances <= 0) {
            throw new ActivitiIllegalArgumentException("Invalid number of instances: must be positive integer value, but was " + nrOfInstances);
        }
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = execution.createExecution();
            concurrentExecution.setVariableLocal("token_", loopCounter + 100);
            concurrentExecution.setActive(true);
            concurrentExecution.setConcurrent(true);
            concurrentExecution.setScope(false);
            if (this.isExtraScopeNeeded()) {
                ActivityExecution extraScopedExecution = concurrentExecution.createExecution();
                extraScopedExecution.setActive(true);
                extraScopedExecution.setConcurrent(false);
                extraScopedExecution.setScope(true);
                concurrentExecution = extraScopedExecution;
            }
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = (ActivityExecution)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, this.getCollectionElementIndexVariable(), loopCounter);
            this.executeOriginalBehavior(concurrentExecution, loopCounter);
        }
        if (!concurrentExecutions.isEmpty()) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            executionEntity.setActive(false);
        }
    }

    @Override
    public void leave(ActivityExecution execution) {
        this.callActivityEndListeners(execution);
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
        if (this.isExtraScopeNeeded()) {
            ExecutionEntity extraScope = (ExecutionEntity)execution;
            execution = execution.getParent();
            extraScope.remove();
        }
        this.setLoopVariable(execution.getParent(), "nrOfCompletedInstances", nrOfCompletedInstances);
        this.setLoopVariable(execution.getParent(), "nrOfActiveInstances", nrOfActiveInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        executionEntity.inactivate();
        executionEntity.getParent().forceUpdate();
        List<ActivityExecution> joinedExecutions = executionEntity.findInactiveConcurrentExecutions(execution.getActivity());
        if (this.completionConditionSatisfied(execution) || joinedExecutions.size() == nrOfInstances) {
            ArrayList<ExecutionEntity> executionsToRemove = new ArrayList<ExecutionEntity>();
            for (ActivityExecution activityExecution : executionEntity.getParent().getExecutions()) {
                if (!activityExecution.isActive()) continue;
                executionsToRemove.add((ExecutionEntity)activityExecution);
            }
            for (ExecutionEntity executionEntity2 : executionsToRemove) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Execution {} still active, but multi-instance is completed. Removing this execution.", (Object)executionEntity2);
                }
                executionEntity2.inactivate();
                executionEntity2.deleteCascade("multi-instance completed");
            }
            ActivityImpl activity2 = (ActivityImpl)execution.getActivity();
            Map<String, Object> map = activity2.getProperties();
            if (map.get("type") != null && !map.get("type").toString().equals("userTask")) {
                GatewayMetJoinEventModel model = new GatewayMetJoinEventModel();
                model.activity = activity2;
                model.activityExecution = execution;
                model.noteType = "subEndGateway";
                model.flag = "ParallelMultiInstanceEnd";
                GatewayMetJoinEvent event = new GatewayMetJoinEvent(model);
                AppUtil.publishEvent((ApplicationEvent)event);
            }
            executionEntity.takeAll(executionEntity.getActivity().getOutgoingTransitions(), joinedExecutions);
        } else {
            ActivityImpl activity2 = (ActivityImpl)execution.getActivity();
            Map<String, Object> props = activity2.getProperties();
            if (props.get("type") != null && !props.get("type").toString().equals("userTask")) {
                GatewayUnmetJoinEventModel gatewayUnmetJoinEventModel = new GatewayUnmetJoinEventModel();
                gatewayUnmetJoinEventModel.activity = activity2;
                gatewayUnmetJoinEventModel.activityExecution = execution;
                gatewayUnmetJoinEventModel.noteType = "subEndGateway";
                gatewayUnmetJoinEventModel.flag = "ParallelMultiInstanceEnd";
                GatewayUnmetJoinEvent event = new GatewayUnmetJoinEvent(gatewayUnmetJoinEventModel);
                AppUtil.publishEvent((ApplicationEvent)event);
            }
        }
    }
}

