/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.form.AbstractFormType;
import org.apache.commons.lang3.StringUtils;

public class DateFormType
extends AbstractFormType {
    protected String datePattern;
    protected Format dateFormat;

    public DateFormType(String datePattern) {
        this.datePattern = datePattern;
        this.dateFormat = new SimpleDateFormat(datePattern);
    }

    @Override
    public String getName() {
        return "date";
    }

    @Override
    public Object getInformation(String key) {
        if ("datePattern".equals(key)) {
            return this.datePattern;
        }
        return null;
    }

    @Override
    public Object convertFormValueToModelValue(String propertyValue) {
        if (StringUtils.isEmpty((CharSequence)propertyValue)) {
            return null;
        }
        try {
            return this.dateFormat.parseObject(propertyValue);
        }
        catch (ParseException e) {
            throw new ActivitiIllegalArgumentException("invalid date value " + propertyValue);
        }
    }

    @Override
    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue == null) {
            return null;
        }
        return this.dateFormat.format(modelValue);
    }
}

