/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import com.lc.ibps.base.core.util.AppUtil;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.ext.factory.BpmDelegateExecutionFactory;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.entity.GatewayUnmetJoinEventModel;
import org.activiti.engine.impl.entity.SubProcessStartOrEndEventModel;
import org.activiti.engine.impl.event.GatewayUnmetJoinEvent;
import org.activiti.engine.impl.event.SubProcessEndEvent;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.runtime.AbstractEventAtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.springframework.context.ApplicationEvent;

public class AtomicOperationActivityEnd
extends AbstractEventAtomicOperation {
    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        return (ScopeImpl)((Object)execution.getActivity());
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        ActivityImpl activity;
        ActivityImpl parentActivity;
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_COMPLETED, execution.getActivity().getId(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId()));
        }
        if ((parentActivity = (activity = (ActivityImpl)execution.getActivity()).getParentActivity()) != null && !parentActivity.isScope()) {
            execution.setActivity(parentActivity);
            execution.performOperation(ACTIVITY_END);
        } else if (execution.isProcessInstanceType()) {
            execution.performOperation(PROCESS_END);
        } else if (execution.isScope()) {
            ActivityBehavior parentActivityBehavior;
            ActivityBehavior activityBehavior = parentActivityBehavior = parentActivity != null ? parentActivity.getActivityBehavior() : null;
            if (parentActivityBehavior instanceof CompositeActivityBehavior) {
                CompositeActivityBehavior compositeActivityBehavior = (CompositeActivityBehavior)parentActivity.getActivityBehavior();
                if (activity.isScope() && activity.getOutgoingTransitions().isEmpty()) {
                    InterpretableExecution parentScopeExecution = (InterpretableExecution)execution.getParent();
                    execution.destroy();
                    execution.remove();
                    parentScopeExecution.setActivity(parentActivity);
                    compositeActivityBehavior.lastExecutionEnded(parentScopeExecution);
                } else {
                    if (activity.getProperty("type").equals("endEvent") && parentActivity != null && parentActivity.getProperty("type").equals("subProcess")) {
                        SubProcessStartOrEndEventModel model = new SubProcessStartOrEndEventModel();
                        model.bpmDelegateExecution = BpmDelegateExecutionFactory.getBpmDelegateExecution(execution);
                        model.setNodeId(activity.getId());
                        model.setNoteType("subEndGateway");
                        SubProcessEndEvent subProcessEndEvent = new SubProcessEndEvent(model);
                        AppUtil.publishEvent((ApplicationEvent)subProcessEndEvent);
                    }
                    execution.setActivity(parentActivity);
                    compositeActivityBehavior.lastExecutionEnded(execution);
                }
            } else {
                InterpretableExecution parentScopeExecution = (InterpretableExecution)execution.getParent();
                execution.destroy();
                execution.remove();
                if (activity.getParent() == activity.getProcessDefinition()) {
                    parentScopeExecution.setActivity(activity);
                    if (activity.getOutgoingTransitions().isEmpty()) {
                        parentScopeExecution.end();
                    } else {
                        parentScopeExecution.performOperation(PROCESS_END);
                    }
                } else {
                    parentScopeExecution.setActivity(parentActivity);
                    parentScopeExecution.performOperation(ACTIVITY_END);
                }
            }
        } else {
            InterpretableExecution concurrentRoot;
            execution.remove();
            if (activity.getProperty("type").equals("endEvent") && parentActivity != null && parentActivity.getProperty("type").equals("subProcess")) {
                GatewayUnmetJoinEventModel model = new GatewayUnmetJoinEventModel();
                model.activity = activity;
                model.activityExecution = execution;
                model.noteType = "subEndGateway";
                GatewayUnmetJoinEvent event = new GatewayUnmetJoinEvent(model);
                AppUtil.publishEvent((ApplicationEvent)event);
            }
            if ((concurrentRoot = (InterpretableExecution)execution.getParent()).getExecutions().size() == 1) {
                InterpretableExecution lastConcurrent = (InterpretableExecution)concurrentRoot.getExecutions().get(0);
                if (!lastConcurrent.isScope()) {
                    concurrentRoot.setActivity((ActivityImpl)lastConcurrent.getActivity());
                    lastConcurrent.setReplacedBy(concurrentRoot);
                    if (lastConcurrent.getExecutions().size() > 0) {
                        concurrentRoot.getExecutions().clear();
                        for (ActivityExecution activityExecution : lastConcurrent.getExecutions()) {
                            InterpretableExecution childInterpretableExecution = (InterpretableExecution)activityExecution;
                            concurrentRoot.getExecutions().add(activityExecution);
                            childInterpretableExecution.setParent(concurrentRoot);
                        }
                        lastConcurrent.getExecutions().clear();
                    }
                    concurrentRoot.setVariablesLocal(lastConcurrent.getVariablesLocal());
                    if (!concurrentRoot.isActive() && lastConcurrent.isActive()) {
                        concurrentRoot.setActive(true);
                    }
                    lastConcurrent.remove();
                } else {
                    lastConcurrent.setConcurrent(false);
                }
            }
        }
    }

    protected boolean isExecutionAloneInParent(InterpretableExecution execution) {
        ScopeImpl parentScope = (ScopeImpl)execution.getActivity().getParent();
        for (InterpretableExecution interpretableExecution : execution.getParent().getExecutions()) {
            if (interpretableExecution == execution || !parentScope.contains((ActivityImpl)interpretableExecution.getActivity())) continue;
            return false;
        }
        return true;
    }
}

