/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class SequentialMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    public SequentialMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    @Override
    protected void createInstances(ActivityExecution execution) throws Exception {
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances <= 0) {
            throw new ActivitiIllegalArgumentException("Invalid number of instances: must be positive integer value, but was " + nrOfInstances);
        }
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", 1);
        this.logLoopDetails(execution, "initialized", 0, 0, 1, nrOfInstances);
        this.executeOriginalBehavior(execution, 0);
    }

    @Override
    public void leave(ActivityExecution execution) {
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances");
        boolean isComplete = this.completionConditionSatisfied(execution);
        if (loopCounter != nrOfInstances && !isComplete) {
            this.callActivityEndListeners(execution);
        }
        this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), loopCounter);
        this.setLoopVariable(execution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        if (isComplete || loopCounter == nrOfInstances) {
            super.leave(execution);
        } else {
            try {
                this.executeOriginalBehavior(execution, loopCounter);
            }
            catch (BpmnError error) {
                throw error;
            }
            catch (Exception e) {
                throw new ActivitiException("Could not execute inner activity behavior of multi instance behavior", e);
            }
        }
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        super.execute(execution);
        if (this.innerActivityBehavior instanceof SubProcessActivityBehavior && !execution.isActive() && execution.isEnded() && (execution.getExecutions() == null || execution.getExecutions().size() == 0)) {
            execution.setActive(true);
        }
    }
}

