/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.diagram;

import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.impl.bpmn.diagram.LcProcessDiagramCanvas;
import org.activiti.engine.impl.bpmn.diagram.ProcessDiagramGenerator;

public class LcProcessDiagramGenerator
extends ProcessDiagramGenerator {
    public static InputStream generatePngDiagram(BpmnModel bpmnModel) {
        return LcProcessDiagramGenerator.generateDiagram(bpmnModel, Collections.emptyMap(), "png");
    }

    public static InputStream generatePngDiagram(BpmnModel bpmnModel, Map<String, String> highLightedActivities) {
        return LcProcessDiagramGenerator.generateDiagram(bpmnModel, highLightedActivities, "png");
    }

    public static InputStream generateDiagram(BpmnModel bpmnModel, Map<String, String> highLightedActivities, String imageType) {
        LcProcessDiagramCanvas canvas = LcProcessDiagramGenerator.generateDiagram(bpmnModel, highLightedActivities);
        return canvas.generateImage(imageType);
    }

    public static LcProcessDiagramCanvas generateDiagram(BpmnModel bpmnModel, Map<String, String> highLightedActivities) {
        LcProcessDiagramCanvas processDiagramCanvas = LcProcessDiagramGenerator.initProcessDiagramCanvas(bpmnModel);
        for (Pool pool : bpmnModel.getPools()) {
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(pool.getId());
            processDiagramCanvas.drawPoolOrLane(pool.getName(), (int)graphicInfo.getX(), (int)graphicInfo.getY(), (int)graphicInfo.getWidth(), (int)graphicInfo.getHeight());
        }
        for (Process process : bpmnModel.getProcesses()) {
            for (Lane lane : process.getLanes()) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(lane.getId());
                processDiagramCanvas.drawPoolOrLane(lane.getName(), (int)graphicInfo.getX(), (int)graphicInfo.getY(), (int)graphicInfo.getWidth(), (int)graphicInfo.getHeight());
            }
        }
        for (FlowNode flowNode : ((Process)bpmnModel.getProcesses().get(0)).findFlowElementsOfType(FlowNode.class)) {
            LcProcessDiagramGenerator.drawActivity(processDiagramCanvas, bpmnModel, flowNode, highLightedActivities, Collections.emptyList());
        }
        for (Process process : bpmnModel.getProcesses()) {
            for (Artifact artifact : process.getArtifacts()) {
                LcProcessDiagramGenerator.drawArtifact(processDiagramCanvas, bpmnModel, artifact);
            }
        }
        return processDiagramCanvas;
    }

    protected static void drawActivity(LcProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode, Map<String, String> highLightedActivities, List<String> highLightedFlows) {
        ProcessDiagramGenerator.ActivityDrawInstruction drawInstruction = (ProcessDiagramGenerator.ActivityDrawInstruction)activityDrawInstructions.get(flowNode.getClass());
        if (drawInstruction != null) {
            Activity activity;
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics;
            drawInstruction.draw(processDiagramCanvas, bpmnModel, flowNode);
            boolean multiInstanceSequential = false;
            boolean multiInstanceParallel = false;
            boolean collapsed = false;
            if (flowNode instanceof Activity && (multiInstanceLoopCharacteristics = (activity = (Activity)flowNode).getLoopCharacteristics()) != null) {
                multiInstanceSequential = multiInstanceLoopCharacteristics.isSequential();
                multiInstanceParallel = !multiInstanceSequential;
            }
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            if (flowNode instanceof SubProcess) {
                collapsed = graphicInfo.getExpanded() != null && graphicInfo.getExpanded() == false;
            } else if (flowNode instanceof CallActivity) {
                collapsed = true;
            }
            processDiagramCanvas.drawActivityMarkers((int)graphicInfo.getX(), (int)graphicInfo.getY(), (int)graphicInfo.getWidth(), (int)graphicInfo.getHeight(), multiInstanceSequential, multiInstanceParallel, collapsed);
            if (highLightedActivities.containsKey(flowNode.getId())) {
                String color = highLightedActivities.get(flowNode.getId());
                LcProcessDiagramGenerator.drawHighLight(processDiagramCanvas, bpmnModel.getGraphicInfo(flowNode.getId()), color);
            }
        }
        for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
            boolean highLighted = highLightedFlows.contains(sequenceFlow.getId());
            boolean isDefault = sequenceFlow.getConditionExpression() == null && flowNode instanceof Gateway;
            boolean drawConditionalIndicator = sequenceFlow.getConditionExpression() != null && !(flowNode instanceof Gateway);
            String sourceRef = sequenceFlow.getSourceRef();
            String targetRef = sequenceFlow.getTargetRef();
            FlowElement sourceElement = bpmnModel.getFlowElement(sourceRef);
            FlowElement targetElement = bpmnModel.getFlowElement(targetRef);
            List<GraphicInfo> graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId());
            graphicInfoList = LcProcessDiagramGenerator.connectionPerfectionizer(processDiagramCanvas, bpmnModel, (BaseElement)sourceElement, (BaseElement)targetElement, graphicInfoList);
            int[] xPoints = new int[graphicInfoList.size()];
            int[] yPoints = new int[graphicInfoList.size()];
            for (int i = 1; i < graphicInfoList.size(); ++i) {
                GraphicInfo graphicInfo = graphicInfoList.get(i);
                GraphicInfo previousGraphicInfo = graphicInfoList.get(i - 1);
                if (i == 1) {
                    xPoints[0] = (int)previousGraphicInfo.getX();
                    yPoints[0] = (int)previousGraphicInfo.getY();
                }
                xPoints[i] = (int)graphicInfo.getX();
                yPoints[i] = (int)graphicInfo.getY();
            }
            processDiagramCanvas.drawSequenceflow(xPoints, yPoints, drawConditionalIndicator, isDefault, highLighted);
            GraphicInfo labelGraphicInfo = bpmnModel.getLabelGraphicInfo(sequenceFlow.getId());
            if (labelGraphicInfo == null) continue;
            GraphicInfo lineCenter = null;
            if (labelGraphicInfo.getX() < 0.0 && labelGraphicInfo.getY() == 0.0) {
                lineCenter = LcProcessDiagramGenerator.getLineCenter(graphicInfoList);
            }
            if (lineCenter == null) {
                processDiagramCanvas.drawLabel(sequenceFlow.getName(), (int)labelGraphicInfo.getX(), (int)(labelGraphicInfo.getY() - labelGraphicInfo.getHeight()), (int)labelGraphicInfo.getWidth(), (int)labelGraphicInfo.getHeight(), false);
                continue;
            }
            processDiagramCanvas.drawLabel(sequenceFlow.getName(), (int)lineCenter.getX(), (int)lineCenter.getY(), (int)labelGraphicInfo.getWidth(), (int)labelGraphicInfo.getHeight(), false);
        }
        if (flowNode instanceof FlowElementsContainer) {
            for (FlowElement nestedFlowElement : ((FlowElementsContainer)flowNode).getFlowElements()) {
                if (!(nestedFlowElement instanceof FlowNode)) continue;
                LcProcessDiagramGenerator.drawActivity(processDiagramCanvas, bpmnModel, (FlowNode)nestedFlowElement, highLightedActivities, highLightedFlows);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static LcProcessDiagramCanvas initProcessDiagramCanvas(BpmnModel bpmnModel) {
        void var11_12;
        double minX = Double.MAX_VALUE;
        double maxX = 0.0;
        double minY = Double.MAX_VALUE;
        double maxY = 0.0;
        for (Object pool : bpmnModel.getPools()) {
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(pool.getId());
            minX = graphicInfo.getX();
            maxX = graphicInfo.getX() + graphicInfo.getWidth();
            minY = graphicInfo.getY();
            maxY = graphicInfo.getY() + graphicInfo.getHeight();
        }
        List<FlowNode> flowNodes = LcProcessDiagramGenerator.gatherAllFlowNodes(bpmnModel);
        for (FlowNode flowNode : flowNodes) {
            GraphicInfo flowNodeGraphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            if (flowNodeGraphicInfo.getX() + flowNodeGraphicInfo.getWidth() > maxX) {
                maxX = flowNodeGraphicInfo.getX() + flowNodeGraphicInfo.getWidth();
            }
            if (flowNodeGraphicInfo.getX() < minX) {
                minX = flowNodeGraphicInfo.getX();
            }
            if (flowNodeGraphicInfo.getY() + flowNodeGraphicInfo.getHeight() > maxY) {
                maxY = flowNodeGraphicInfo.getY() + flowNodeGraphicInfo.getHeight();
            }
            if (flowNodeGraphicInfo.getY() < minY) {
                minY = flowNodeGraphicInfo.getY();
            }
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId());
                Iterator iterator = graphicInfoList.iterator();
                while (iterator.hasNext()) {
                    GraphicInfo graphicInfo = (GraphicInfo)iterator.next();
                    if (graphicInfo.getX() > maxX) {
                        maxX = graphicInfo.getX();
                    }
                    if (graphicInfo.getX() < minX) {
                        minX = graphicInfo.getX();
                    }
                    if (graphicInfo.getY() > maxY) {
                        maxY = graphicInfo.getY();
                    }
                    if (!(graphicInfo.getY() < minY)) continue;
                    minY = graphicInfo.getY();
                }
                GraphicInfo labelGraphicInfo = bpmnModel.getLabelGraphicInfo(sequenceFlow.getId());
                if (labelGraphicInfo == null || labelGraphicInfo.getY() == 0.0 && labelGraphicInfo.getX() < 0.0) continue;
                if (labelGraphicInfo.getX() < minX) {
                    minX = labelGraphicInfo.getX();
                }
                if (labelGraphicInfo.getY() < minY) {
                    minY = labelGraphicInfo.getY();
                }
                if (labelGraphicInfo.getX() + labelGraphicInfo.getWidth() > maxX) {
                    maxX = labelGraphicInfo.getX() + labelGraphicInfo.getWidth();
                }
                if (!(labelGraphicInfo.getY() + labelGraphicInfo.getHeight() > maxY)) continue;
                maxY = labelGraphicInfo.getY() + labelGraphicInfo.getHeight();
            }
        }
        List<Artifact> artifacts = LcProcessDiagramGenerator.gatherAllArtifacts(bpmnModel);
        for (Artifact artifact : artifacts) {
            List graphicInfoList;
            GraphicInfo artifactGraphicInfo = bpmnModel.getGraphicInfo(artifact.getId());
            if (artifactGraphicInfo != null) {
                if (artifactGraphicInfo.getX() + artifactGraphicInfo.getWidth() > maxX) {
                    maxX = artifactGraphicInfo.getX() + artifactGraphicInfo.getWidth();
                }
                if (artifactGraphicInfo.getX() < minX) {
                    minX = artifactGraphicInfo.getX();
                }
                if (artifactGraphicInfo.getY() + artifactGraphicInfo.getHeight() > maxY) {
                    maxY = artifactGraphicInfo.getY() + artifactGraphicInfo.getHeight();
                }
                if (artifactGraphicInfo.getY() < minY) {
                    minY = artifactGraphicInfo.getY();
                }
            }
            if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(artifact.getId())) == null) continue;
            for (GraphicInfo graphicInfo : graphicInfoList) {
                if (graphicInfo.getX() > maxX) {
                    maxX = graphicInfo.getX();
                }
                if (graphicInfo.getX() < minX) {
                    minX = graphicInfo.getX();
                }
                if (graphicInfo.getY() > maxY) {
                    maxY = graphicInfo.getY();
                }
                if (!(graphicInfo.getY() < minY)) continue;
                minY = graphicInfo.getY();
            }
        }
        boolean bl = false;
        for (Process process : bpmnModel.getProcesses()) {
            for (Lane l : process.getLanes()) {
                GraphicInfo graphicInfo;
                ++var11_12;
                graphicInfo = bpmnModel.getGraphicInfo(l.getId());
                if (graphicInfo.getX() + graphicInfo.getWidth() > maxX) {
                    maxX = graphicInfo.getX() + graphicInfo.getWidth();
                }
                if (graphicInfo.getX() < minX) {
                    minX = graphicInfo.getX();
                }
                if (graphicInfo.getY() + graphicInfo.getHeight() > maxY) {
                    maxY = graphicInfo.getY() + graphicInfo.getHeight();
                }
                if (!(graphicInfo.getY() < minY)) continue;
                minY = graphicInfo.getY();
            }
        }
        if (flowNodes.size() == 0 && bpmnModel.getPools().size() == 0 && var11_12 == false) {
            minX = 0.0;
            minY = 0.0;
        }
        return new LcProcessDiagramCanvas((int)maxX + 10, (int)maxY + 10, (int)minX, (int)minY);
    }

    private static void drawHighLight(LcProcessDiagramCanvas processDiagramCanvas, GraphicInfo graphicInfo, String color) {
        processDiagramCanvas.drawHighLight((int)graphicInfo.getX(), (int)graphicInfo.getY(), (int)graphicInfo.getWidth(), (int)graphicInfo.getHeight(), color);
    }
}

