/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;

public class HasTaskVariableCmd
implements Command<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String variableName;
    protected boolean isLocal;

    public HasTaskVariableCmd(String taskId, String variableName, boolean isLocal) {
        this.taskId = taskId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiIllegalArgumentException("taskId is null");
        }
        if (this.variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        TaskEntity task = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiObjectNotFoundException("task " + this.taskId + " doesn't exist", Task.class);
        }
        boolean hasVariable = false;
        hasVariable = this.isLocal ? task.hasVariableLocal(this.variableName) : task.hasVariable(this.variableName);
        return hasVariable;
    }
}

