/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.NoExecutionVariableScope;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationType;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;

public class TimerDeclarationImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Expression description;
    protected TimerDeclarationType type;
    protected String jobHandlerType;
    protected String jobHandlerConfiguration = null;
    protected String repeat;
    protected boolean exclusive = true;
    protected int retries = 3;
    protected boolean isInterruptingTimer;

    public TimerDeclarationImpl(Expression expression, TimerDeclarationType type, String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
        this.description = expression;
        this.type = type;
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public boolean isInterruptingTimer() {
        return this.isInterruptingTimer;
    }

    public void setInterruptingTimer(boolean isInterruptingTimer) {
        this.isInterruptingTimer = isInterruptingTimer;
    }

    public TimerEntity prepareTimerEntity(ExecutionEntity executionEntity) {
        Object dueDateValue;
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.type.calendarName);
        if (this.description == null) {
            throw new ActivitiIllegalArgumentException("Timer '" + executionEntity.getActivityId() + "' was not configured with a valid duration/time");
        }
        String dueDateString = null;
        Date duedate = null;
        VariableScope scopeForExpression = executionEntity;
        if (scopeForExpression == null) {
            scopeForExpression = NoExecutionVariableScope.getSharedInstance();
        }
        if ((dueDateValue = this.description.getValue(scopeForExpression)) instanceof String) {
            dueDateString = (String)dueDateValue;
        } else if (dueDateValue instanceof Date) {
            duedate = (Date)dueDateValue;
        } else {
            throw new ActivitiException("Timer '" + executionEntity.getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
        }
        if (duedate == null) {
            duedate = businessCalendar.resolveDuedate(dueDateString);
        }
        TimerEntity timer = new TimerEntity(this);
        timer.setDuedate(duedate);
        if (executionEntity != null) {
            timer.setExecution(executionEntity);
            timer.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
            if (executionEntity != null && executionEntity.getTenantId() != null) {
                timer.setTenantId(executionEntity.getTenantId());
            }
        }
        if (this.type == TimerDeclarationType.CYCLE) {
            boolean repeat;
            boolean bl = repeat = !this.isInterruptingTimer;
            if ("timer-intermediate-transition".equals(this.jobHandlerType)) {
                repeat = false;
            }
            if (repeat) {
                String prepared = this.prepareRepeat(dueDateString);
                timer.setRepeat(prepared);
            }
        }
        return timer;
    }

    private String prepareRepeat(String dueDate) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return dueDate.replace("/", "/" + sdf.format(Context.getProcessEngineConfiguration().getClock().getCurrentTime()) + "/");
        }
        return dueDate;
    }
}

