/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.EngineServices;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmException;
import org.activiti.engine.impl.pvm.PvmExecution;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.ExecutionListenerExecution;
import org.activiti.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.impl.pvm.runtime.OutgoingExecution;
import org.activiti.engine.impl.pvm.runtime.StartingExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionImpl
implements Serializable,
ActivityExecution,
ExecutionListenerExecution,
PvmExecution,
InterpretableExecution {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExecutionImpl.class);
    protected ProcessDefinitionImpl processDefinition;
    protected ActivityImpl activity;
    protected TransitionImpl transition = null;
    protected ExecutionImpl processInstance;
    protected ExecutionImpl parent;
    protected List<ExecutionImpl> executions;
    protected ExecutionImpl superExecution;
    protected ExecutionImpl subProcessInstance;
    protected StartingExecution startingExecution;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent = false;
    protected boolean isEnded = false;
    protected boolean isEventScope = false;
    protected Map<String, Object> variables = null;
    protected String eventName;
    protected PvmProcessElement eventSource;
    protected int executionListenerIndex = 0;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected ExecutionImpl replacedBy;
    protected AtomicOperation nextOperation;
    protected boolean isOperating = false;

    public ExecutionImpl() {
    }

    public ExecutionImpl(ActivityImpl initial) {
        this.startingExecution = new StartingExecution(initial);
    }

    @Override
    public ExecutionImpl createExecution() {
        ExecutionImpl createdExecution = this.newExecution();
        this.ensureExecutionsInitialized();
        this.executions.add(createdExecution);
        createdExecution.setParent(this);
        createdExecution.setProcessDefinition(this.getProcessDefinition());
        createdExecution.setProcessInstance(this.getProcessInstance());
        createdExecution.setActivity(this.getActivity());
        return createdExecution;
    }

    protected ExecutionImpl newExecution() {
        return new ExecutionImpl();
    }

    @Override
    public PvmProcessInstance createSubProcessInstance(PvmProcessDefinition processDefinition) {
        ExecutionImpl subProcessInstance = this.newExecution();
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        return subProcessInstance;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void destroy() {
        this.setScope(false);
    }

    @Override
    public void remove() {
        this.ensureParentInitialized();
        if (this.parent != null) {
            this.parent.ensureExecutionsInitialized();
            this.parent.executions.remove(this);
        }
        ArrayList<ExecutionImpl> childExecutions = new ArrayList<ExecutionImpl>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : childExecutions) {
            if (!interpretableExecution.isEventScope()) continue;
            log.debug("removing eventScope {}", (Object)interpretableExecution);
            interpretableExecution.destroy();
            interpretableExecution.remove();
        }
    }

    @Override
    public void destroyScope(String reason) {
        log.debug("performing destroy scope behavior for execution {}", (Object)this);
        ArrayList<ExecutionImpl> executions = new ArrayList<ExecutionImpl>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : executions) {
            if (interpretableExecution.getSubProcessInstance() != null) {
                interpretableExecution.getSubProcessInstance().deleteCascade(reason);
            }
            interpretableExecution.deleteCascade(reason);
        }
    }

    @Override
    public ExecutionImpl getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    @Override
    public String getParentId() {
        this.ensureActivityInitialized();
        if (this.parent != null) {
            return this.parent.getId();
        }
        return null;
    }

    @Override
    public void setParent(InterpretableExecution parent) {
        this.parent = (ExecutionImpl)parent;
    }

    protected void ensureParentInitialized() {
    }

    public List<ExecutionImpl> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    @Override
    public ExecutionImpl getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    public void setSuperExecution(ExecutionImpl superExecution) {
        this.superExecution = superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
    }

    protected void ensureSuperExecutionInitialized() {
    }

    @Override
    public ExecutionImpl getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(InterpretableExecution subProcessInstance) {
        this.subProcessInstance = (ExecutionImpl)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(AtomicOperation.DELETE_CASCADE);
    }

    @Override
    public void end() {
        this.isActive = false;
        this.isEnded = true;
        this.performOperation(AtomicOperation.ACTIVITY_END);
    }

    @Override
    public ExecutionImpl findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (ExecutionImpl nestedExecution : this.getExecutions()) {
            ExecutionImpl result = nestedExecution.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        this.ensureActivityInitialized();
        if (this.isActive && this.activity != null) {
            activeActivityIds.add(this.activity.getId());
        }
        this.ensureExecutionsInitialized();
        for (ExecutionImpl execution : this.executions) {
            execution.collectActiveActivityIds(activeActivityIds);
        }
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            this.executions = new ArrayList<ExecutionImpl>();
        }
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        this.ensureProcessDefinitionInitialized();
        return this.processDefinition;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.getProcessDefinition().getId();
    }

    protected void ensureProcessDefinitionInitialized() {
    }

    public ExecutionImpl getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    @Override
    public String getProcessInstanceId() {
        return this.getProcessInstance().getId();
    }

    @Override
    public String getBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public void setProcessInstance(InterpretableExecution processInstance) {
        this.processInstance = (ExecutionImpl)processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
    }

    @Override
    public ActivityImpl getActivity() {
        this.ensureActivityInitialized();
        return this.activity;
    }

    @Override
    public void setActivity(ActivityImpl activity) {
        this.activity = activity;
    }

    protected void ensureActivityInitialized() {
    }

    protected void ensureScopeInitialized() {
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public void start() {
        if (this.startingExecution == null && this.isProcessInstanceType()) {
            this.startingExecution = new StartingExecution(this.processDefinition.getInitial());
        }
        this.performOperation(AtomicOperation.PROCESS_START);
    }

    @Override
    public void signal(String signalName, Object signalData) {
        this.ensureActivityInitialized();
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            activityBehavior.signal(this, signalName, signalData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void take(PvmTransition transition) {
        if (this.transition != null) {
            throw new PvmException("already taking a transition");
        }
        if (transition == null) {
            throw new PvmException("transition is null");
        }
        this.setTransition((TransitionImpl)transition);
        this.performOperation(AtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        this.setActivity((ActivityImpl)activity);
        this.performOperation(AtomicOperation.ACTIVITY_START);
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        ArrayList<ActivityExecution> otherConcurrentExecutions = new ArrayList<ActivityExecution>();
        if (this.isConcurrent()) {
            List<ExecutionImpl> concurrentExecutions = this.getParent().getExecutions();
            for (ActivityExecution activityExecution : concurrentExecutions) {
                if (activityExecution.getActivity() == activity) {
                    if (activityExecution.isActive()) {
                        throw new PvmException("didn't expect active execution in " + activity + ". bug?");
                    }
                    inactiveConcurrentExecutionsInActivity.add(activityExecution);
                    continue;
                }
                otherConcurrentExecutions.add(activityExecution);
            }
        } else if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        } else {
            otherConcurrentExecutions.add(this);
        }
        if (log.isDebugEnabled()) {
            log.debug("inactive concurrent executions in '{}': {}", (Object)activity, inactiveConcurrentExecutionsInActivity);
            log.debug("other concurrent executions: {}", otherConcurrentExecutions);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void takeAll(List<PvmTransition> transitions, List<ActivityExecution> recyclableExecutions) {
        transitions = new ArrayList<PvmTransition>(transitions);
        List<ActivityExecution> list = recyclableExecutions = recyclableExecutions != null ? new ArrayList<ActivityExecution>(recyclableExecutions) : new ArrayList();
        if (recyclableExecutions.size() > 1) {
            for (ActivityExecution recyclableExecution : recyclableExecutions) {
                if (!((ExecutionImpl)recyclableExecution).isScope()) continue;
                throw new PvmException("joining scope executions is not allowed");
            }
        }
        ExecutionImpl concurrentRoot = this.isConcurrent && !this.isScope ? this.getParent() : this;
        ArrayList<ExecutionImpl> concurrentActiveExecutions = new ArrayList<ExecutionImpl>();
        for (ExecutionImpl executionImpl : concurrentRoot.getExecutions()) {
            if (!executionImpl.isActive()) continue;
            concurrentActiveExecutions.add(executionImpl);
        }
        if (log.isDebugEnabled()) {
            log.debug("transitions to take concurrent: {}", transitions);
            log.debug("active concurrent executions: {}", concurrentActiveExecutions);
        }
        if (transitions.size() == 1 && concurrentActiveExecutions.isEmpty()) {
            List<ActivityExecution> recyclableExecutionImpls = recyclableExecutions;
            for (ExecutionImpl executionImpl : recyclableExecutionImpls) {
                if (executionImpl.isEnded()) continue;
                log.debug("pruning execution {}", (Object)executionImpl);
                executionImpl.remove();
            }
            log.debug("activating the concurrent root {} as the single path of execution going forward", (Object)concurrentRoot);
            concurrentRoot.setActive(true);
            concurrentRoot.setActivity(this.activity);
            concurrentRoot.setConcurrent(false);
            concurrentRoot.take(transitions.get(0));
        } else {
            ArrayList<OutgoingExecution> outgoingExecutions = new ArrayList<OutgoingExecution>();
            recyclableExecutions.remove(concurrentRoot);
            log.debug("recyclable executions for reused: {}", recyclableExecutions);
            while (!transitions.isEmpty()) {
                void var7_13;
                PvmTransition pvmTransition = transitions.remove(0);
                Object var7_14 = null;
                if (recyclableExecutions.isEmpty()) {
                    ExecutionImpl executionImpl = concurrentRoot.createExecution();
                    log.debug("new {} created to take transition {}", (Object)executionImpl, (Object)pvmTransition);
                } else {
                    ExecutionImpl executionImpl = (ExecutionImpl)recyclableExecutions.remove(0);
                    log.debug("recycled {} to take transition {}", (Object)executionImpl, (Object)pvmTransition);
                }
                var7_13.setActive(true);
                var7_13.setScope(false);
                var7_13.setConcurrent(true);
                outgoingExecutions.add(new OutgoingExecution((InterpretableExecution)var7_13, pvmTransition, true));
            }
            for (ActivityExecution activityExecution : recyclableExecutions) {
                log.debug("pruning execution {}", (Object)activityExecution);
                activityExecution.end();
            }
            for (OutgoingExecution outgoingExecution : outgoingExecutions) {
                outgoingExecution.take();
            }
        }
    }

    @Override
    public void performOperation(AtomicOperation executionOperation) {
        this.nextOperation = executionOperation;
        if (!this.isOperating) {
            this.isOperating = true;
            while (this.nextOperation != null) {
                AtomicOperation currentOperation = this.nextOperation;
                this.nextOperation = null;
                if (log.isTraceEnabled()) {
                    log.trace("AtomicOperation: {} on {}", (Object)currentOperation, (Object)this);
                }
                currentOperation.execute(this);
            }
            this.isOperating = false;
        }
    }

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public Object getVariable(String variableName) {
        this.ensureVariablesInitialized();
        if (this.variables.containsKey(variableName)) {
            return this.variables.get(variableName);
        }
        this.ensureParentInitialized();
        if (this.parent != null) {
            return this.parent.getVariable(variableName);
        }
        return null;
    }

    @Override
    public Map<String, Object> getVariables() {
        HashMap<String, Object> collectedVariables = new HashMap<String, Object>();
        this.collectVariables(collectedVariables);
        return collectedVariables;
    }

    protected void collectVariables(Map<String, Object> collectedVariables) {
        this.ensureParentInitialized();
        if (this.parent != null) {
            this.parent.collectVariables(collectedVariables);
        }
        this.ensureVariablesInitialized();
        for (String variableName : this.variables.keySet()) {
            collectedVariables.put(variableName, this.variables.get(variableName));
        }
    }

    @Override
    public void setVariables(Map<String, ? extends Object> variables) {
        this.ensureVariablesInitialized();
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void setVariable(String variableName, Object value) {
        this.ensureVariablesInitialized();
        if (this.variables.containsKey(variableName)) {
            this.setVariableLocally(variableName, value);
        } else {
            this.ensureParentInitialized();
            if (this.parent != null) {
                this.parent.setVariable(variableName, value);
            } else {
                this.setVariableLocally(variableName, value);
            }
        }
    }

    public void setVariableLocally(String variableName, Object value) {
        log.debug("setting variable '{}' to value '{}' on {}", new Object[]{variableName, value, this});
        this.variables.put(variableName, value);
    }

    @Override
    public boolean hasVariable(String variableName) {
        this.ensureVariablesInitialized();
        if (this.variables.containsKey(variableName)) {
            return true;
        }
        this.ensureParentInitialized();
        if (this.parent != null) {
            return this.parent.hasVariable(variableName);
        }
        return false;
    }

    protected void ensureVariablesInitialized() {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
    }

    @Override
    public EngineServices getEngineServices() {
        return Context.getProcessEngineConfiguration();
    }

    public String toString() {
        if (this.isProcessInstanceType()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isEventScope ? "EventScope" : "") + (this.isConcurrent ? "Concurrent" : "") + (this.isScope() ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return Integer.toString(System.identityHashCode(this));
    }

    @Override
    public boolean isProcessInstanceType() {
        this.ensureParentInitialized();
        return this.parent == null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    @Override
    public void setTransition(TransitionImpl transition) {
        this.transition = transition;
    }

    @Override
    public Integer getExecutionListenerIndex() {
        return this.executionListenerIndex;
    }

    @Override
    public void setExecutionListenerIndex(Integer executionListenerIndex) {
        this.executionListenerIndex = executionListenerIndex;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public PvmProcessElement getEventSource() {
        return this.eventSource;
    }

    @Override
    public void setEventSource(PvmProcessElement eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public ExecutionImpl getReplacedBy() {
        return this.replacedBy;
    }

    @Override
    public void setReplacedBy(InterpretableExecution replacedBy) {
        this.replacedBy = (ExecutionImpl)replacedBy;
    }

    public void setExecutions(List<ExecutionImpl> executions) {
        this.executions = executions;
    }

    @Override
    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    @Override
    public String getCurrentActivityId() {
        String currentActivityId = null;
        if (this.activity != null) {
            currentActivityId = this.activity.getId();
        }
        return currentActivityId;
    }

    @Override
    public String getCurrentActivityName() {
        String currentActivityName = null;
        if (this.activity != null) {
            currentActivityName = (String)this.activity.getProperty("name");
        }
        return currentActivityName;
    }

    @Override
    public void createVariableLocal(String variableName, Object value) {
    }

    public void createVariablesLocal(Map<String, ? extends Object> variables) {
    }

    @Override
    public Object getVariableLocal(String variableName) {
        return null;
    }

    @Override
    public Set<String> getVariableNames() {
        return null;
    }

    @Override
    public Set<String> getVariableNamesLocal() {
        return null;
    }

    @Override
    public Map<String, Object> getVariablesLocal() {
        return null;
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        return false;
    }

    @Override
    public boolean hasVariables() {
        return false;
    }

    @Override
    public boolean hasVariablesLocal() {
        return false;
    }

    @Override
    public void removeVariable(String variableName) {
    }

    @Override
    public void removeVariableLocal(String variableName) {
    }

    @Override
    public void removeVariables(Collection<String> variableNames) {
    }

    @Override
    public void removeVariablesLocal(Collection<String> variableNames) {
    }

    @Override
    public void removeVariables() {
    }

    @Override
    public void removeVariablesLocal() {
    }

    public void deleteVariablesLocal() {
    }

    @Override
    public Object setVariableLocal(String variableName, Object value) {
        return null;
    }

    @Override
    public void setVariablesLocal(Map<String, ? extends Object> variables) {
    }

    @Override
    public boolean isEventScope() {
        return this.isEventScope;
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    @Override
    public StartingExecution getStartingExecution() {
        return this.startingExecution;
    }

    @Override
    public void disposeStartingExecution() {
        this.startingExecution = null;
    }

    public String updateProcessBusinessKey(String bzKey) {
        return this.getProcessInstance().updateProcessBusinessKey(bzKey);
    }

    @Override
    public String getTenantId() {
        return null;
    }
}

