/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.init.AbstractJDBCAdapter;
import org.anyline.data.jdbc.adapter.init.alias.MySQLGenusTypeMetadataAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.VariableValue;
import org.anyline.entity.authorize.Privilege;
import org.anyline.entity.authorize.User;
import org.anyline.exception.NotSupportException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.TableComment;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.refer.MetadataFieldRefer;
import org.anyline.metadata.refer.MetadataReferHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.RegularUtil;

public abstract class MySQLGenusAdapter
extends AbstractJDBCAdapter {
    private static Map<Type, String> types = new HashMap<Type, String>();

    public MySQLGenusAdapter() {
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.CHAR, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 0, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TEXT, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BOOLEAN, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BYTES, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 0, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BLOB, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.INT, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", "NUMERIC_PRECISION", null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.FLOAT, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", "NUMERIC_PRECISION", "NUMERIC_SCALE", 1, 2, 2));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATE, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIME, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATETIME, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIMESTAMP, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.COLLECTION, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.GEOMETRY, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.OTHER, (TypeMetadata.Refer)new TypeMetadata.Refer("CHARACTER_MAXIMUM_LENGTH", null, null, 1, 1, 1));
        for (MySQLGenusTypeMetadataAlias alias : MySQLGenusTypeMetadataAlias.values()) {
            this.reg(alias);
            this.alias(alias.name(), alias.standard());
        }
    }

    @Override
    public boolean supportCatalog() {
        return false;
    }

    @Override
    public boolean supportSchema() {
        return super.supportSchema();
    }

    public String columnAliasGuidd() {
        return " AS ";
    }

    public String tableAliasGuidd() {
        return " AS ";
    }

    @Override
    public String name(Type type) {
        return types.get(type);
    }

    @Override
    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, configs, columns);
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.buildInsertRun(runtime, batch, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, set, configs, placeholder, unicode, columns);
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, list, configs, placeholder, unicode, columns);
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        return super.confirmInsertColumns(runtime, dest, obj, configs, columns, batch);
    }

    @Override
    public String batchInsertSeparator() {
        return ",";
    }

    @Override
    public boolean supportInsertPlaceholder() {
        return true;
    }

    @Override
    protected void setPrimaryValue(Object obj, Object value) {
        super.setPrimaryValue(obj, value);
    }

    @Override
    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.createInsertRun(runtime, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.createInsertRunFromCollection(runtime, batch, dest, list, configs, placeholder, unicode, columns);
    }

    @Override
    public String generatedKey() {
        return "GENERATED_KEY";
    }

    @Override
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        return super.insert(runtime, random, data, configs, run, pks);
    }

    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.buildUpdateRun(runtime, batch, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromEntity(runtime, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromDataRow(runtime, dest, row, configs, placeholder, unicode, columns);
    }

    @Override
    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, placeholder, unicode, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, RunPrepare prepare, DataRow data, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        return super.buildUpdateRun(runtime, prepare, data, configs, placeholder, unicode, conditions);
    }

    public void fillUpdateContent(DataRuntime runtime, TableRun run, StringBuilder builder, DataRow data, ConfigStore configs, Boolean placeholder, Boolean unicode) {
        String master;
        TablePrepare prepare = (TablePrepare)run.getPrepare();
        builder.append("UPDATE ");
        this.name(runtime, builder, (Metadata)prepare.getTable());
        String alias = prepare.getAlias();
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(this.tableAliasGuidd());
            this.delimiter(builder, alias);
        }
        builder.append("\n");
        List joins = prepare.getJoins();
        if (null != joins) {
            for (RunPrepare join : joins) {
                this.fillJoinTableContent(runtime, builder, run, join);
            }
        }
        if (BasicUtil.isEmpty((Object)(master = alias))) {
            master = prepare.getTableName();
        }
        builder.append("SET").append("\n");
        List keys = data.keys();
        boolean first = true;
        for (String key : keys) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            if (!key.contains(".")) {
                builder.append(master).append(".");
            }
            builder.append(key).append(" = ");
            Object value = data.get(key);
            if (value instanceof VariableValue) {
                VariableValue var = (VariableValue)value;
                this.delimiter(builder, var.value());
                continue;
            }
            builder.append("?");
            RunValue rv = new RunValue();
            rv.setValue(value);
            run.addValue(rv);
        }
        run.appendCondition(builder, (DriverAdapter)this, true, placeholder, unicode);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, row, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, obj, configs, columns);
    }

    public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        return super.update(runtime, random, dest, data, configs, run);
    }

    public long save(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.save(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        return super.saveCollection(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.saveObject(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected Boolean checkOverride(Object obj, ConfigStore configs) {
        return super.checkOverride(obj, configs);
    }

    @Override
    protected Boolean checkOverrideSync(Object obj, ConfigStore configs) {
        return super.checkOverrideSync(obj, configs);
    }

    @Override
    protected Map<String, Object> checkPv(Object obj) {
        return super.checkPv(obj);
    }

    @Override
    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        return super.isMultipleValue(runtime, run, key);
    }

    @Override
    protected boolean isMultipleValue(Column column) {
        return super.isMultipleValue(column);
    }

    @Override
    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.checkMetadata(runtime, table, configs, columns);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        return super.querys(runtime, random, procedure, navi);
    }

    @Override
    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return super.selects(runtime, random, prepare, clazz, configs, conditions);
    }

    @Override
    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, clazz, table, configs, run);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.maps(runtime, random, prepare, configs, conditions);
    }

    @Override
    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        return super.buildQueryRun(runtime, prepare, configs, placeholder, unicode, conditions);
    }

    @Override
    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        return super.buildQuerySequence(runtime, next, names);
    }

    @Override
    public Run fillQueryContent(DataRuntime runtime, Run run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected Run fillQueryContent(DataRuntime runtime, XMLRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected Run fillQueryContent(DataRuntime runtime, TextRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected Run fillQueryContent(DataRuntime runtime, TableRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.pageLimitOffset(runtime, run);
    }

    @Override
    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        return super.createConditionLike(runtime, builder, compare, value, placeholder, unicode);
    }

    @Override
    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) throws NotSupportException {
        List values = BeanUtil.object2list((Object)value);
        if (values.size() > 1) {
            builder.append("(");
        }
        boolean first = true;
        String join = " OR ";
        if (compare == Compare.FIND_IN_SET_AND) {
            join = " AND ";
        }
        for (Object v : values) {
            if (!first) {
                builder.append(join);
            }
            if (placeholder.booleanValue()) {
                if (value instanceof String && value.toString().contains(",")) {
                    builder.append("FIND_IN_SET(").append(column).append(", ?)");
                } else {
                    builder.append("FIND_IN_SET(?, ").append(column).append(")");
                }
            } else if (value instanceof String && value.toString().contains(",")) {
                builder.append("FIND_IN_SET(").append(column).append(", '").append(v).append("')");
            } else {
                builder.append("FIND_IN_SET('").append(v).append("', ").append(column).append(")");
            }
            first = false;
        }
        if (values.size() > 1) {
            builder.append(")");
        }
        return value;
    }

    public Object createConditionJsonContains(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        List values = BeanUtil.object2list((Object)value);
        ArrayList returns = new ArrayList();
        if (values.size() > 1) {
            builder.append("(");
        }
        boolean first = true;
        String join = " OR ";
        if (compare == Compare.JSON_CONTAINS_AND) {
            join = " AND ";
        }
        String key = null;
        if (column.contains(">")) {
            String[] ks = column.split(">");
            column = ks[0];
            key = ks[1];
        }
        for (Object v : values) {
            if (!first) {
                builder.append(join);
            }
            if (BasicUtil.isNumber(v)) {
                v = v.toString();
            } else {
                String str = v.toString();
                if (str.startsWith("${") && str.endsWith("}")) {
                    str = str.substring(2, str.length() - 1);
                } else if (!str.startsWith("\"")) {
                    str = "\"" + str + "\"";
                }
                v = str;
            }
            builder.append("JSON_CONTAINS(").append(column).append(", ");
            if (placeholder.booleanValue()) {
                builder.append("?");
            } else {
                builder.append(v);
            }
            if (BasicUtil.isNotEmpty((Object)key)) {
                builder.append(",'").append(key).append("'");
            }
            builder.append(")");
            returns.add(v);
            first = false;
        }
        if (values.size() > 1) {
            builder.append(")");
        }
        return returns;
    }

    public Object createConditionJsonContainsPath(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        String scope = "one";
        if (compare.getCode() == 76) {
            scope = "all";
        }
        Collection values = new ArrayList<Object>();
        if (value instanceof Collection) {
            values = (Collection)value;
        } else {
            values.add(value);
        }
        builder.append("JSON_CONTAINS_PATH(").append(column).append(", '").append(scope).append("'");
        for (Object v : values) {
            builder.append(", ");
            if (placeholder.booleanValue()) {
                builder.append("?");
                continue;
            }
            builder.append("'").append(v).append("'");
        }
        builder.append(")");
        return value;
    }

    public Object createConditionJsonSearch(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) throws NotSupportException {
        String scope = "one";
        if (compare.getCode() == 78) {
            scope = "all";
        }
        Collection values = new ArrayList<Object>();
        if (value instanceof Collection) {
            values = (Collection)value;
        } else {
            values.add(value);
        }
        builder.append("JSON_SEARCH(").append(column).append(", '").append(scope).append("'");
        for (Object v : values) {
            builder.append(", ");
            if (placeholder.booleanValue()) {
                builder.append("?");
                continue;
            }
            builder.append("'").append(v).append("'");
        }
        builder.append(") IS NOT NULL");
        return value;
    }

    @Override
    public List<RunValue> createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        return super.createConditionIn(runtime, builder, compare, value, placeholder, unicode);
    }

    @Override
    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, system, table, configs, run);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.maps(runtime, random, configs, run);
    }

    @Override
    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.map(runtime, random, configs, run);
    }

    @Override
    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        return super.sequence(runtime, random, next, names);
    }

    @Override
    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return super.process(runtime, list);
    }

    @Override
    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.count(runtime, random, prepare, configs, conditions);
    }

    @Override
    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        return super.mergeFinalTotal(runtime, run);
    }

    @Override
    public long count(DataRuntime runtime, String random, Run run) {
        return super.count(runtime, random, run);
    }

    public Run buildQueryLengthRun(DataRuntime runtime, String cn, ConfigStore configs) {
        SimpleRun run = new SimpleRun(runtime);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT LENGTH('").append(cn).append("') AS CNT");
        return run;
    }

    @Override
    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.exists(runtime, random, prepare, configs, conditions);
    }

    @Override
    public String mergeFinalExists(DataRuntime runtime, Run run) {
        return super.mergeFinalExists(runtime, run);
    }

    @Override
    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.execute(runtime, random, prepare, configs, conditions);
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        return super.execute(runtime, random, batch, configs, prepare, values);
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        return super.execute(runtime, random, procedure);
    }

    @Override
    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        return super.buildExecuteRun(runtime, prepare, configs, placeholder, unicode, conditions);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        super.fillExecuteContent(runtime, run);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, TextRun run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, TableRun run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    @Override
    public void fillExecuteContent(DataRuntime runtime, Run run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    @Override
    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.execute(runtime, random, configs, run);
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String key, Collection<T> values) {
        return super.deletes(runtime, random, batch, table, configs, key, values);
    }

    public long delete(DataRuntime runtime, String random, String dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    @Override
    public long truncate(DataRuntime runtime, String random, Table table) {
        return super.truncate(runtime, random, table);
    }

    @Override
    public List<Run> buildDeleteRun(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return super.buildDeleteRun(runtime, dest, configs, obj, placeholder, unicode, columns);
    }

    public List<Run> buildDeleteRun(DataRuntime runtime, int batch, String table, ConfigStore configs, Boolean placeholder, Boolean unicode, String key, Object values) {
        return super.buildDeleteRun(runtime, batch, table, configs, placeholder, unicode, key, values);
    }

    public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        return super.buildTruncateRun(runtime, table);
    }

    @Override
    public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, ConfigStore configs, Boolean placeholder, Boolean unicode, String column, Object values) {
        return super.buildDeleteRunFromTable(runtime, batch, table, configs, placeholder, unicode, column, values);
    }

    @Override
    public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, Table table, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return super.buildDeleteRunFromEntity(runtime, table, configs, obj, placeholder, unicode, columns);
    }

    @Override
    public void fillDeleteRunContent(DataRuntime runtime, Run run, Boolean placeholder, Boolean unicode) {
        super.fillDeleteRunContent(runtime, run, placeholder, unicode);
    }

    @Override
    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.delete(runtime, random, configs, run);
    }

    @Override
    public Database database(DataRuntime runtime, String random) {
        Schema schema = this.schema(runtime, random);
        if (null != schema) {
            return new Database(schema.getName());
        }
        return super.database(runtime, random);
    }

    @Override
    public String product(DataRuntime runtime, String random) {
        return super.product(runtime, random);
    }

    @Override
    public String version(DataRuntime runtime, String random) {
        return super.version(runtime, random);
    }

    @Override
    public <T extends Database> List<T> databases(DataRuntime runtime, String random, boolean greedy, Database query) {
        return super.databases(runtime, random, greedy, query);
    }

    @Override
    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, String random, Database query) {
        return super.databases(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, Database query) throws Exception {
        String name = query.getName();
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SHOW DATABASES");
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append(" LIKE '").append(name).append("'");
        }
        return runs;
    }

    @Override
    public MetadataFieldRefer initDatabaseFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Database.class);
        refer.map("NAME", "DATABASE");
        return refer;
    }

    @Override
    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Database query, DataSet set) throws Exception {
        return super.databases(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Database> List<T> databases(DataRuntime runtime, int index, boolean create, List<T> previous, Database query, DataSet set) throws Exception {
        return super.databases(runtime, index, create, previous, query, set);
    }

    @Override
    public Database database(DataRuntime runtime, int index, boolean create, Database meta, DataSet set) throws Exception {
        Iterator iterator;
        if (null == meta && (iterator = set.iterator()).hasNext()) {
            DataRow row = (DataRow)iterator.next();
            meta = new Database();
            meta.setName(row.getString("DATABASE"));
            return meta;
        }
        return meta;
    }

    @Override
    public Database database(DataRuntime runtime, boolean create, Database meta) throws Exception {
        return super.database(runtime, create, meta);
    }

    @Override
    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        return super.product(runtime, index, create, product, set);
    }

    @Override
    public String product(DataRuntime runtime, boolean create, String product) {
        return super.product(runtime, create, product);
    }

    @Override
    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        return super.version(runtime, index, create, version, set);
    }

    @Override
    public String version(DataRuntime runtime, boolean create, String version) {
        return super.version(runtime, create, version);
    }

    public <T extends Database> T init(DataRuntime runtime, int index, T meta, Database query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Database> T detail(DataRuntime runtime, int index, T meta, Database query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, String random, Catalog query) {
        return super.catalogs(runtime, random, query);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, String random, boolean greedy, Catalog query) {
        return super.catalogs(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, Catalog query) throws Exception {
        return super.buildQueryCatalogsRun(runtime, greedy, query);
    }

    @Override
    public MetadataFieldRefer initCatalogFieldRefer() {
        return super.initCatalogFieldRefer();
    }

    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog query, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog query, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous) throws Exception {
        return super.catalogs(runtime, create, previous);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, boolean create, List<T> previous) throws Exception {
        return super.catalogs(runtime, create, previous);
    }

    @Override
    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog meta, DataSet set) throws Exception {
        return super.catalog(runtime, index, create, meta, set);
    }

    @Override
    public Catalog catalog(DataRuntime runtime, boolean create, Catalog meta) throws Exception {
        return super.catalog(runtime, create, meta);
    }

    public <T extends Catalog> T init(DataRuntime runtime, int index, T meta, Catalog query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Catalog> T detail(DataRuntime runtime, int index, T meta, Catalog query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, String random, Schema query) {
        return super.schemas(runtime, random, query);
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, String random, boolean greedy, Schema query) {
        return super.schemas(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Schema query) throws Exception {
        String name = query.getName();
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SHOW SCHEMAS");
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append(" LIKE '").append(name).append("'");
        }
        return runs;
    }

    @Override
    public MetadataFieldRefer initSchemaFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Schema.class);
        refer.map("NAME", "DATABASE");
        return refer;
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Schema query, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, int index, boolean create, List<T> previous, Schema query, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, previous, query, set);
    }

    @Override
    public Schema schema(DataRuntime runtime, int index, boolean create, Schema meta, DataSet set) throws Exception {
        return super.schema(runtime, index, create, meta, set);
    }

    @Override
    public Schema schema(DataRuntime runtime, boolean create, Schema meta) throws Exception {
        return super.schema(runtime, create, meta);
    }

    public <T extends Schema> T init(DataRuntime runtime, int index, T meta, Schema query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Schema> T detail(DataRuntime runtime, int index, T meta, Schema query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Table query, int types, int struct, ConfigStore configs) {
        return super.tables(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Table query, ConfigStore configs) {
        super.tableMap(runtime, random, greedy, query, configs);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Table query, int types, int struct, ConfigStore configs) {
        return super.tables(runtime, random, query, types, struct, configs);
    }

    @Override
    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Table query, int types, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM information_schema.TABLES");
        configs.and("TABLE_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "TABLE_NAME", (Object)this.objectName(runtime, query.getName()));
        List tps = this.names(Table.types((int)types));
        if (tps.isEmpty()) {
            tps.add("BASE TABLE");
        }
        configs.in("TABLE_TYPE", (Object)tps);
        return runs;
    }

    @Override
    public MetadataFieldRefer initTableFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Table.class);
        refer.map("NAME", "TABLE_NAME");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("TYPE", "TABLE_TYPE");
        refer.map("ENGINE", "ENGINE");
        refer.map("OBJECT_ID", "OBJECT_ID");
        refer.map("DATA_ROWS", "TABLE_ROWS");
        refer.map("COLLATE", "TABLE_COLLATION");
        refer.map("DATA_LENGTH", "DATA_LENGTH");
        refer.map("DATA_FREE", "DATA_FREE");
        refer.map("INCREMENT", "AUTO_INCREMENT");
        refer.map("INDEX_LENGTH", "INDEX_LENGTH");
        refer.map("CREATE_TIME", "CREATE_TIME");
        refer.map("UPDATE_TIME", "UPDATE_TIME");
        refer.map("TEMPORARY", "IS_TEMPORARY");
        refer.map("COMMENT", "TABLE_COMMENT");
        refer.map("_MASTER_CHECK", "CREATE_OPTIONS");
        refer.map("MASTER_CHECK_VALUE", "partitioned");
        return refer;
    }

    public MetadataFieldRefer initTableCommentFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(TableComment.class);
        refer.map("VALUE", "TABLE_COMMENT");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("CATALOG", "TABLE_CATALOG");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        return refer;
    }

    @Override
    public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Table query, int types) throws Exception {
        return super.buildQueryTablesCommentRun(runtime, query, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        set.removeColumn(new String[]{"TABLE_CATALOG"});
        previous = super.tables(runtime, index, create, previous, query, set);
        return previous;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        set.removeColumn(new String[]{"TABLE_CATALOG"});
        previous = super.tables(runtime, index, create, previous, query, set);
        return previous;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Table query, int types) throws Exception {
        return super.tables(runtime, create, previous, query, types);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> previous, Table query, int types) throws Exception {
        return super.tables(runtime, create, previous, query, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        return super.comments(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        return super.comments(runtime, index, create, previous, query, set);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        return super.ddl(runtime, random, table, init);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("show create table ");
        this.name(runtime, builder, (Metadata)table);
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        for (DataRow row : set) {
            ddls.add(row.getString("CREATE TABLE"));
        }
        if (BasicUtil.isEmpty((Object)table.getCharset())) {
            for (String item : ddls) {
                if (item.contains("CHARSET=")) {
                    String charset = RegularUtil.cut((String)item, (String[])new String[]{"CHARSET=", " "});
                    table.setCharset(charset);
                }
                if (!item.contains("ENGINE=")) continue;
                String engine = RegularUtil.cut((String)item, (String[])new String[]{"ENGINE=", " "});
                table.setEngine(engine);
            }
        }
        return ddls;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, View query, int types, int struct, ConfigStore configs) {
        return super.views(runtime, random, query, types, struct, configs);
    }

    @Override
    public List<Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, View query, int types, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM information_schema.VIEWS");
        configs.and("TABLE_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "TABLE_NAME", (Object)query.getName());
        return runs;
    }

    @Override
    public MetadataFieldRefer initViewFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(View.class);
        refer.map("NAME", "TABLE_NAME");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("DEFINITION", "VIEW_DEFINITION");
        return refer;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, View query, DataSet set) throws Exception {
        return super.views(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, View query, int types) throws Exception {
        return super.views(runtime, create, previous, query, types);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, View view, boolean init) {
        return super.ddl(runtime, random, view, init);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("show create view ");
        this.name(runtime, builder, (Metadata)view);
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        for (DataRow row : set) {
            ddls.add(row.getString("CREATE VIEW"));
        }
        return ddls;
    }

    @Override
    public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, MasterTable query, int types, int struct, ConfigStore configs) {
        return super.masters(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, boolean greedy, MasterTable query, int types, ConfigStore configs) throws Exception {
        return super.buildQueryMasterTablesRun(runtime, greedy, query, types, configs);
    }

    @Override
    public MetadataFieldRefer initMasterTableFieldRefer() {
        return super.initMasterTableFieldRefer();
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, MasterTable query, DataSet set) throws Exception {
        return super.masters(runtime, index, create, previous, query, set);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, MasterTable query, int types) throws Exception {
        return super.masters(runtime, create, previous, query, types);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, MasterTable meta, boolean init) {
        return super.ddl(runtime, random, meta, init);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public Table.Partition partition(DataRuntime runtime, String random, Table table) {
        return super.partition(runtime, random, table);
    }

    public List<Run> buildQueryTablePartitionRun(DataRuntime runtime, Table table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SHOW CREATE TABLE ");
        this.name(runtime, builder, (Metadata)table);
        run = new SimpleRun(runtime);
        runs.add((Run)run);
        builder = run.getBuilder();
        builder.append("SELECT * FROM information_schema.PARTITIONS");
        ConfigStore configs = run.getConfigs();
        configs.and("TABLE_SCHEMA", (Object)table.getSchemaName());
        configs.and("TABLE_NAME", (Object)table.getName());
        return runs;
    }

    public Table.Partition partition(DataRuntime runtime, int index, boolean create, Table.Partition meta, Table table, DataSet set) throws Exception {
        return super.partition(runtime, index, create, meta, table, set);
    }

    public Table.Partition init(DataRuntime runtime, int index, boolean create, Table.Partition meta, Table table, DataRow row) throws Exception {
        String type;
        String txt;
        MetadataFieldRefer refer = this.refer(runtime, Table.Partition.class);
        if (index == 0 && null != (txt = row.getString("Create Table")) && null != (type = RegularUtil.cut((boolean)true, (String)txt, (String[])new String[]{"PARTITION BY", "("}))) {
            String mod;
            String[] columns;
            meta = new Table.Partition();
            type = type.trim();
            Table.Partition.TYPE ty = Table.Partition.TYPE.valueOf((String)type.toUpperCase());
            meta.setType(ty);
            for (String column : columns = RegularUtil.cut((boolean)true, (String)txt, (String[])new String[]{"PARTITION BY", "(", ")"}).split(",")) {
                meta.addColumn(column.replace("`", "").trim());
            }
            if (ty == Table.Partition.TYPE.HASH && null != (mod = RegularUtil.cut((boolean)true, (String)txt, (String[])new String[]{"PARTITION BY", "PARTITIONS", " ", " "}))) {
                meta.setModulus(BasicUtil.parseInt((Object)mod.trim(), (Integer)-1).intValue());
            }
        }
        return meta;
    }

    public Table.Partition detail(DataRuntime runtime, int index, boolean create, Table.Partition meta, Table table, DataRow row) throws Exception {
        if (index == 1) {
            MetadataFieldRefer refer = this.refer(runtime, Table.Partition.Slice.class);
            Table.Partition.Slice slice = new Table.Partition.Slice();
            slice.setName(this.getString(row, refer, "NAME"));
            Table.Partition.TYPE type = meta.getType();
            if (type == Table.Partition.TYPE.LIST) {
                String[] values;
                for (String value : values = row.getString("PARTITION_DESCRIPTION").split(",")) {
                    slice.addValue((Object)value);
                }
            } else if (type == Table.Partition.TYPE.RANGE) {
                String[] less = row.getString("PARTITION_DESCRIPTION").split(",");
                String[] columns = row.getString("PARTITION_EXPRESSION").replace("`", "").split(",");
                int size = columns.length;
                for (int i = 0; i < size; ++i) {
                    slice.setLess(columns[i], (Object)less[i]);
                }
            }
            meta.addSlice(slice);
        }
        return meta;
    }

    public MetadataFieldRefer initTablePartitionFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Table.Partition.class);
        refer.map("TYPE", "PARTITION_METHOD");
        refer.map("COLUMN", "PARTITION_EXPRESSION");
        return refer;
    }

    public MetadataFieldRefer initTablePartitionSliceFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Table.Partition.Slice.class);
        refer.map("NAME", "PARTITION_NAME");
        return refer;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, String random, boolean greedy, PartitionTable query) {
        return super.partitions(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, PartitionTable query, int types) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, greedy, query, types);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, int total, int index, boolean create, LinkedHashMap<String, T> previous, PartitionTable query, DataSet set) throws Exception {
        return super.partitions(runtime, total, index, create, previous, query, set);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, PartitionTable query) throws Exception {
        return super.partitions(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        return super.ddl(runtime, random, table);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildQueryDdlRun(runtime, table);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, Column query, boolean primary, ConfigStore configs) {
        return super.columns(runtime, random, greedy, table, query, primary, configs);
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Column query, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Table table = query.getTable();
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, (Metadata)table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT * FROM INFORMATION_SCHEMA.COLUMNS");
            configs.and("TABLE_SCHEMA", (Object)query.getSchemaName());
            configs.and(Compare.LIKE_SIMPLE, "TABLE_NAME", (Object)this.objectName(runtime, query.getTableName()));
            configs.order("TABLE_NAME").order("ORDINAL_POSITION");
        }
        return runs;
    }

    @Override
    public MetadataFieldRefer initColumnFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Column.class);
        refer.map("NAME", "COLUMN_NAME");
        refer.map("CATALOG", "");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("NULLABLE", "IS_NULLABLE");
        refer.map("CHARSET", "CHARACTER_SET_NAME");
        refer.map("COLLATE", "COLLATION_NAME");
        refer.map("TYPE", "COLUMN_TYPE");
        refer.map("POSITION", "ORDINAL_POSITION");
        refer.map("COMMENT", "COLUMN_COMMENT");
        refer.map("DEFAULT_VALUE", "COLUMN_DEFAULT");
        refer.map("AUTO_INCREMENT_CHECK", "EXTRA");
        refer.map("AUTO_INCREMENT_CHECK_VALUE", "auto_increment");
        refer.map("ON_UPDATE_CHECK", "EXTRA");
        refer.map("ON_UPDATE_CHECK_VALUE", ".*on update.*");
        refer.map("PRIMARY_CHECK", "COLUMN_KEY");
        refer.map("PRIMARY_CHECK_VALUE", "PRI");
        return refer;
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Collection<? extends Table> tables, Column query, ConfigStore configs) throws Exception {
        Schema schema = query.getSchema();
        ArrayList<Run> runs = new ArrayList<Run>();
        Table table = null;
        if (!tables.isEmpty()) {
            table = tables.iterator().next();
        }
        if (null != table) {
            this.checkName(runtime, null, table);
            schema = table.getSchema();
        }
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.COLUMNS");
        if (!this.empty((Metadata)schema)) {
            configs.and("TABLE_SCHEMA", (Object)schema.getName());
        }
        List names = Table.names(tables);
        configs.in("TABLE_NAME", (Object)names);
        configs.order("TABLE_NAME").order("ORDINAL_POSITION");
        return runs;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table table, Column query, DataSet set) throws Exception {
        set.removeColumn(new String[]{"TABLE_CATALOG"});
        return super.columns(runtime, index, create, previous, table, query, set);
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, List<T> previous, Column query, DataSet set) throws Exception {
        set.removeColumn(new String[]{"TABLE_CATALOG"});
        return super.columns(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Column> T init(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Column> T detail(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        T result = super.detail(runtime, index, meta, query, row);
        String onupdate = null;
        String extra = row.getString("EXTRA");
        if (null != extra && extra.contains("on update") && BasicUtil.isEmpty((Object)(onupdate = RegularUtil.cut((String)extra, (String[])new String[]{"on update", " "})))) {
            onupdate = RegularUtil.cut((String)extra, (String[])new String[]{"on update", "${end}"});
        }
        if (null != onupdate) {
            meta.setOnUpdate(onupdate);
        }
        return result;
    }

    public TypeMetadata.Refer dataTypeMetadataRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.dataTypeMetadataRefer(runtime, meta);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table, Tag query) {
        return super.tags(runtime, random, greedy, table, query);
    }

    @Override
    public List<Run> buildQueryTagsRun(DataRuntime runtime, boolean greedy, Tag query) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Tag query, DataSet set) throws Exception {
        return super.tags(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Tag query) throws Exception {
        return super.tags(runtime, create, previous, query);
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, PrimaryKey query) {
        return super.primary(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, boolean greedy, PrimaryKey query) throws Exception {
        Table table = query.getTable();
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SHOW INDEX FROM ");
        this.name(runtime, builder, (Metadata)table);
        return runs;
    }

    @Override
    public MetadataFieldRefer initPrimaryKeyFieldRefer() {
        return super.initPrimaryKeyFieldRefer();
    }

    @Override
    public <T extends PrimaryKey> T init(DataRuntime runtime, int index, T primary, PrimaryKey query, DataSet set) throws Exception {
        if (!(set = set.getRows(new String[]{"Key_name", "PRIMARY"})).isEmpty()) {
            primary = new PrimaryKey();
            for (DataRow row : set) {
                primary.setName(row.getString("Key_name"));
                Column column = new Column(row.getString("Column_name"));
                primary.addColumn(column);
            }
        }
        return primary;
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, ForeignKey query) {
        return super.foreigns(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryForeignsRun(DataRuntime runtime, boolean greedy, ForeignKey query) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE where REFERENCED_TABLE_NAME IS NOT NULL\n");
        configs.and(Compare.LIKE_SIMPLE, "TABLE_NAME", (Object)query.getTableName());
        configs.order("ORDINAL_POSITION");
        return runs;
    }

    public MetadataFieldRefer initForeignKeyFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(ForeignKey.class);
        refer.map("NAME", "CONSTRAINT_NAME");
        refer.map("CATALOG", "");
        refer.map("SCHEMA", "REFERENCED_SCHEMA_NAME");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("COLUMN", "COLUMN_NAME");
        refer.map("COLUMN_POSITION", "ORDINAL_POSITION");
        refer.map("REFERENCE_CATALOG", "");
        refer.map("REFERENCE_SCHEMA", "REFERENCED_SCHEMA_NAME");
        refer.map("REFERENCE_TABLE", "REFERENCED_TABLE_NAME");
        refer.map("REFERENCE_COLUMN", "REFERENCED_COLUMN_NAME");
        return refer;
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, LinkedHashMap<String, T> previous, ForeignKey query, DataSet set) throws Exception {
        return super.foreigns(runtime, index, previous, query, set);
    }

    @Override
    public <T extends ForeignKey> T init(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends ForeignKey> T detail(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        return super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Index query) {
        return super.indexes(runtime, random, greedy, query);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, String random, Index query) {
        return super.indexes(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Index query) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.STATISTICS\n");
        configs.and("TABLE_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "TABLE_NAME", (Object)query.getTableName());
        configs.and(Compare.LIKE_SIMPLE, "INDEX_NAME", (Object)query.getName());
        configs.order("SEQ_IN_INDEX");
        return runs;
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Collection<? extends Table> tables) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.STATISTICS\n");
        if (null != tables && !tables.isEmpty()) {
            Table table = tables.iterator().next();
            configs.and("TABLE_SCHEMA", (Object)table.getSchemaName());
        }
        configs.in("TABLE_NAME", (Object)Table.names(tables));
        configs.order("TABLE_NAME").order("SEQ_IN_INDEX");
        return runs;
    }

    @Override
    public MetadataFieldRefer initIndexFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Index.class);
        refer.map("NAME", "INDEX_NAME");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("COLUMN", "COLUMN_NAME");
        refer.map("ORDER", "COLLATION");
        refer.map("POSITION", "SEQ_IN_INDEX");
        refer.map("PRIMARY_CHECK", "INDEX_NAME");
        refer.map("PRIMARY_CHECK_VALUE", "PRIMARY");
        refer.map("UNIQUE_CHECK", "NON_UNIQUE");
        refer.map("UNIQUE_CHECK_VALUE", "0");
        refer.map("CATALOG", "");
        return refer;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Index query, DataSet set) throws Exception {
        return super.indexes(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, int index, boolean create, List<T> previous, Index query, DataSet set) throws Exception {
        return super.indexes(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, boolean create, List<T> previous, Index query) throws Exception {
        return super.indexes(runtime, create, previous, query);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Index query) throws Exception {
        return super.indexes(runtime, create, previous, query);
    }

    @Override
    public <T extends Index> T init(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Index> T detail(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        meta = super.detail(runtime, index, meta, query, row);
        if (row.getBoolean("PRIMARY_KEY", Boolean.valueOf(false)).booleanValue()) {
            meta.setPrimary(true);
        }
        return meta;
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Constraint query) {
        return super.constraints(runtime, random, greedy, query);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        return super.constraints(runtime, random, table, column, pattern);
    }

    @Override
    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, boolean greedy, Constraint query) {
        Table table = query.getTable();
        LinkedHashMap columns = query.getColumns();
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS");
        configs.and("CONSTRAINT_CATALOG", (Object)query.getCatalogName());
        configs.and("CONSTRAINT_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "TABLE_NAME", (Object)query.getTableName());
        return runs;
    }

    @Override
    public MetadataFieldRefer initConstraintFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Constraint.class);
        refer.map("NAME", "CONSTRAINT_NAME");
        refer.map("SCHEMA", "CONSTRAINT_CATALOG");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("TYPE", "CONSTRAINT_TYPE");
        return refer;
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, List<T> previous, Constraint query, DataSet set) throws Exception {
        set.removeColumn(new String[]{"CONSTRAINT_CATALOG"});
        return super.constraints(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Constraint query, DataSet set) throws Exception {
        set.removeColumn(new String[]{"CONSTRAINT_CATALOG"});
        return super.constraints(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Trigger query) {
        return super.triggers(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryTriggersRun(DataRuntime runtime, boolean greedy, Trigger query) {
        List events = query.getEvents();
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS");
        configs.and("TRIGGER_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "EVENT_OBJECT_TABLE", (Object)query.getTableName());
        configs.in("EVENT_MANIPULATION", (Object)events);
        return runs;
    }

    public MetadataFieldRefer initTriggerFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Trigger.class);
        refer.map("NAME", "TRIGGER_NAME");
        refer.map("SCHEMA", "TRIGGER_SCHEMA");
        refer.map("TABLE", "EVENT_OBJECT_TABLE");
        refer.map("EVENT", "EVENT_MANIPULATION");
        refer.map("DEFINITION", "ACTION_STATEMENT");
        return refer;
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Trigger query, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, previous, query, set);
    }

    public <T extends Trigger> T init(DataRuntime runtime, int index, T meta, Trigger query, DataRow row) {
        if (null == (meta = super.init(runtime, index, meta, query, row))) {
            meta = new Trigger();
        }
        boolean each = false;
        if ("ROW".equalsIgnoreCase(row.getString("ACTION_ORIENTATION"))) {
            each = true;
        }
        meta.setEach(each);
        try {
            String[] events = row.getStringNvl("EVENT_MANIPULATION", new String[0]).split(",");
            String time = row.getString("ACTION_TIMING");
            meta.setTime(Trigger.TIME.valueOf((String)time));
            for (String event : events) {
                meta.addEvent(new Trigger.EVENT[]{Trigger.EVENT.valueOf((String)event)});
            }
        }
        catch (Exception e) {
            log.error("\u5c01\u88c5trigger \u5f02\u5e38:", (Throwable)e);
        }
        return meta;
    }

    public <T extends Trigger> T detail(DataRuntime runtime, int index, T meta, Trigger query, DataRow row) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Trigger> T detail(DataRuntime runtime, int index, T meta, Trigger query, DataRow row)"), (int)37));
        }
        return meta;
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Procedure query) {
        return super.procedures(runtime, random, greedy, query);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Procedure query) {
        return super.procedures(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryProceduresRun(DataRuntime runtime, boolean greedy, Procedure query) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM information_schema.ROUTINES WHERE ROUTINE_TYPE = 'PROCEDURE'");
        configs.and("ROUTINE_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "ROUTINE_NAME", (Object)query.getName());
        return runs;
    }

    public MetadataFieldRefer initProcedureFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Procedure.class);
        refer.map("NAME", "ROUTINE_NAME");
        refer.map("SCHEMA", "ROUTINE_NAME");
        refer.map("DEFINITION", "ROUTINE_DEFINITION");
        return refer;
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Procedure query, DataSet set) throws Exception {
        return super.procedures(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> previous, Procedure query) throws Exception {
        return super.procedures(runtime, create, previous, query);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Procedure query) throws Exception {
        return super.procedures(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        return super.ddl(runtime, random, procedure);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("show create procedure ");
        this.name(runtime, builder, (Metadata)procedure);
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        for (DataRow row : set) {
            ddls.add(row.getString("Create Procedure"));
        }
        return ddls;
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Function query) {
        return super.functions(runtime, random, greedy, query);
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Function query) {
        return super.functions(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryFunctionsRun(DataRuntime runtime, boolean greedy, Function query) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM information_schema.ROUTINES WHERE ROUTINE_TYPE = 'FUNCTION'");
        configs.and("ROUTINE_SCHEMA", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "ROUTINE_NAME", (Object)query.getName());
        return runs;
    }

    @Override
    public MetadataFieldRefer initFunctionFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Function.class);
        refer.map("NAME", "ROUTINE_NAME");
        refer.map("SCHEMA", "ROUTINE_SCHEMA");
        refer.map("CATALOG", "");
        refer.map("DEFINITION", "ROUTINE_DEFINITION");
        return refer;
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> previous, Function query, DataSet set) throws Exception {
        return super.functions(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Function query, DataSet set) throws Exception {
        return super.functions(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> previous, Function query) throws Exception {
        return super.functions(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        return super.ddl(runtime, random, meta);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("show create function ");
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        for (DataRow row : set) {
            ddls.add(row.getString("Create Function"));
        }
        return ddls;
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Sequence query) {
        return super.sequences(runtime, random, greedy, query);
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Sequence query) {
        return super.sequences(runtime, random, query);
    }

    @Override
    public List<Run> buildQuerySequencesRun(DataRuntime runtime, boolean greedy, Sequence query) {
        return super.buildQuerySequencesRun(runtime, greedy, query);
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> previous, Sequence query, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Sequence query, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, boolean create, List<T> previous, Sequence query) throws Exception {
        return super.sequences(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Sequence meta) {
        return super.ddl(runtime, random, meta);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, sequence, ddls, set);
    }

    @Override
    public <T extends Metadata> T search(List<T> metas, Catalog catalog, Schema schema, String name) {
        return super.search(metas, catalog, schema, name);
    }

    @Override
    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        return super.schema(schemas, catalog, name);
    }

    @Override
    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        return super.catalog(catalogs, name);
    }

    @Override
    public <T extends Database> T database(List<T> databases, String name) {
        return super.database(databases, name);
    }

    public boolean slice() {
        return true;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, Run run) {
        return super.execute(runtime, random, meta, action, run);
    }

    public boolean create(DataRuntime runtime, Catalog meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Catalog meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Catalog meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Catalog origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return super.buildChangeCommentRun(runtime, catalog);
    }

    public List<Run> buildAddCommentRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return super.buildAddCommentRun(runtime, catalog);
    }

    public StringBuilder checkCatalogExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkCatalogExists(runtime, builder, exists);
    }

    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.engine(runtime, builder, meta);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.property(runtime, builder, meta);
    }

    public boolean create(DataRuntime runtime, Schema meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Schema meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Schema meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Schema origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Schema schema) throws Exception {
        return super.buildChangeCommentRun(runtime, schema);
    }

    public List<Run> buildAddCommentRun(DataRuntime runtime, Schema schema) throws Exception {
        return super.buildAddCommentRun(runtime, schema);
    }

    public StringBuilder checkSchemaExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkSchemaExists(runtime, builder, exists);
    }

    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.engine(runtime, builder, meta);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.property(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        Table update;
        if (meta.isSort()) {
            this.sort(meta.getColumns());
        }
        if (null != (update = (Table)meta.getUpdate()) && update.isSort()) {
            this.sort(update.getColumns());
        }
        return super.alter(runtime, meta);
    }

    protected void sort(LinkedHashMap<String, Column> columns) {
        String prefix = null;
        for (Column column : columns.values()) {
            if (null == prefix) {
                column.setPosition(Integer.valueOf(0));
            } else {
                column.setAfter(prefix);
            }
            if (column.isDrop()) continue;
            prefix = column.getName();
        }
    }

    @Override
    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public String keyword(Metadata meta) {
        if (meta instanceof Table) {
            return "TABLE";
        }
        return super.keyword(meta);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE ").append(this.keyword((Metadata)meta)).append(" ");
        this.checkTableExists(runtime, builder, false);
        this.name(runtime, builder, (Metadata)meta);
        this.body(runtime, builder, meta);
        this.indexes(runtime, builder, meta);
        this.inherit(runtime, builder, meta);
        this.engine(runtime, builder, meta);
        this.charset(runtime, builder, meta);
        this.keys(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        this.partitionBy(runtime, builder, meta);
        this.partitionFor(runtime, builder, meta);
        this.distribution(runtime, builder, meta);
        this.materialize(runtime, builder, meta);
        this.property(runtime, builder, meta);
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        runs.addAll(this.buildAppendColumnCommentRun(runtime, meta));
        runs.addAll(this.buildAppendPrimaryRun(runtime, meta));
        runs.addAll(this.buildAppendIndexRun(runtime, meta));
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table meta, Collection<Column> columns, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, meta, columns, slice);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("RENAME TABLE ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" TO ");
        this.name(runtime, builder, meta.getUpdate());
        return runs;
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        return runs;
    }

    @Override
    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = meta.getComment();
        if (BasicUtil.isEmpty((Object)comment)) {
            comment = "";
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" COMMENT '").append(comment).append("'");
        return runs;
    }

    @Override
    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTableExists(runtime, builder, exists);
    }

    @Override
    public void checkPrimary(DataRuntime runtime, Table table) {
        super.checkPrimary(runtime, table);
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        pks = null != primary ? primary.getColumns() : meta.primarys();
        if (!pks.isEmpty()) {
            builder.append(",PRIMARY KEY (");
            boolean first = true;
            Column.sort((LinkedHashMap)primary.getPositions(), (LinkedHashMap)pks);
            for (Column pk : pks.values()) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                this.delimiter(builder, pk.getName());
                String order = pk.getOrder();
                if (!BasicUtil.isNotEmpty((Object)order)) continue;
                builder.append(" ").append(order);
            }
            builder.append(")");
            String type = primary.getType();
            if (BasicUtil.isNotEmpty((Object)type)) {
                builder.append(" USING ").append(type);
            }
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        String charset = meta.getCharset();
        String collate = meta.getCollate();
        if (BasicUtil.isNotEmpty((Object)charset)) {
            builder.append(" CHARSET = ").append(charset);
        }
        if (BasicUtil.isNotEmpty((Object)collate)) {
            builder.append(" COLLATE = ").append(collate);
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        String comment;
        if (null != meta && BasicUtil.isNotEmpty((Object)(comment = meta.getComment()))) {
            builder.append("\nCOMMENT '").append(comment).append("'");
        }
        return builder;
    }

    @Override
    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Table.Partition partition = meta.getPartition();
        if (null == partition) {
            return builder;
        }
        builder.append("\nPARTITION BY ").append(partition.getType()).append("(");
        LinkedHashMap columns = partition.getColumns();
        this.delimiter(builder, Column.names((LinkedHashMap)columns));
        builder.append(")");
        return builder;
    }

    @Override
    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        return super.partitionOf(runtime, builder, meta);
    }

    @Override
    public StringBuilder partitionFor(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Table.Partition partition = meta.getPartition();
        if (null == partition) {
            return builder;
        }
        Table.Partition.TYPE type = partition.getType();
        if (null == type) {
            return builder;
        }
        if (type == Table.Partition.TYPE.HASH) {
            builder.append(" PARTITIONS ").append(partition.getModulus());
            return builder;
        }
        List slices = partition.getSlices();
        if (null != slices && !slices.isEmpty()) {
            builder.append("(\n");
            boolean sfirst = true;
            for (Table.Partition.Slice slice : slices) {
                builder.append("\n\t");
                if (!sfirst) {
                    builder.append(", ");
                }
                sfirst = false;
                Object max = slice.getMax();
                List values = slice.getValues();
                LinkedHashMap less = slice.getLess();
                int interval = slice.getInterval();
                String unit = slice.getUnit();
                if (type == Table.Partition.TYPE.RANGE) {
                    LinkedHashMap columns = partition.getColumns();
                    builder.append("PARTITION ").append(slice.getName()).append(" VALUES LESS THAN ");
                    builder.append("(");
                    boolean lfirst = true;
                    for (Column column : columns.values()) {
                        if (!lfirst) {
                            builder.append(", ");
                        }
                        lfirst = false;
                        Object v = less.get(column.getName().toUpperCase());
                        builder.append(this.write(runtime, null, v, false, false));
                    }
                    builder.append(")");
                    continue;
                }
                if (type != Table.Partition.TYPE.LIST) continue;
                builder.append("PARTITION ").append(slice.getName()).append(" VALUES IN(");
                boolean vfirst = true;
                for (Object value : values) {
                    if (!vfirst) {
                        builder.append(", ");
                    }
                    vfirst = false;
                    builder.append(this.write(runtime, null, value, false, false));
                }
                builder.append(")");
            }
            builder.append("\n)");
        }
        return builder;
    }

    @Override
    public boolean create(DataRuntime runtime, View meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE OR REPLACE VIEW ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" AS \n").append(meta.getDefinition());
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        return super.comment(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        boolean rename;
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            Table table = meta.getTable(true);
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)table);
        } else {
            run.slice(slice);
        }
        Column update = (Column)meta.getUpdate();
        if (null == update) {
            update = meta;
        }
        if (rename = meta.isRename()) {
            builder.append(" CHANGE ");
        } else {
            builder.append(" MODIFY ").append(this.alterColumnKeyword(runtime));
        }
        this.delimiter(builder, meta.getName()).append(" ");
        if (rename) {
            this.delimiter(builder, update.getName()).append(" ");
        }
        this.define(runtime, builder, update, ACTION.DDL.COLUMN_ADD);
        return runs;
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildDropRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildRenameRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildChangeTypeRun(runtime, meta, slice);
    }

    @Override
    public String alterColumnKeyword(DataRuntime runtime) {
        return " COLUMN ";
    }

    @Override
    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.addColumnGuide(runtime, builder, meta);
    }

    @Override
    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.dropColumnGuide(runtime, builder, meta);
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildChangeNullableRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildChangeCommentRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAppendCommentRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ((Column)meta.update()).autoIncrement(Boolean.valueOf(false));
        return this.buildAlterRun(runtime, meta, slice);
    }

    @Override
    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.define(runtime, builder, meta, action);
    }

    @Override
    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.type(runtime, builder, meta);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, int ignoreLength, int ignorePrecision, int ignoreScale) {
        return super.type(runtime, builder, meta, type, ignoreLength, ignorePrecision, ignoreScale);
    }

    @Override
    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.nullable(runtime, builder, meta, action);
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        String charset;
        String typeName = meta.getTypeName();
        if (null != typeName && typeName.toLowerCase().contains("char") && BasicUtil.isNotEmpty((Object)(charset = meta.getCharset()))) {
            builder.append(" CHARACTER SET ").append(charset);
            String collate = meta.getCollate();
            if (BasicUtil.isNotEmpty((Object)collate)) {
                builder.append(" COLLATE ").append(collate);
            }
        }
        return builder;
    }

    @Override
    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.defaultValue(runtime, builder, meta);
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        return builder;
    }

    @Override
    public StringBuilder unique(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (meta.isPrimaryKey() != 1 && meta.isUnique() == 1) {
            builder.append(" UNIQUE");
        }
        return builder;
    }

    @Override
    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (meta.isAutoIncrement() == 1) {
            builder.append(" AUTO_INCREMENT");
        }
        return builder;
    }

    @Override
    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        String onUpdate = meta.getOnUpdate();
        if (BasicUtil.isNotEmpty((Object)onUpdate)) {
            builder.append(" ON UPDATE ").append(onUpdate);
        }
        return builder;
    }

    @Override
    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (!ConfigTable.IS_ENABLE_COLUMN_POSITION) {
            return builder;
        }
        Integer position = meta.getPosition();
        String after = meta.getAfter();
        String before = meta.getBefore();
        if (BasicUtil.isEmpty((Object)before) && BasicUtil.isEmpty((Object)after)) {
            if (null != position && 0 == position) {
                builder.append(" FIRST");
            }
        } else if (BasicUtil.isNotEmpty((Object)after)) {
            builder.append(" AFTER ");
            this.delimiter(builder, after);
        } else if (BasicUtil.isNotEmpty((Object)before)) {
            builder.append(" BEFORE ");
            this.delimiter(builder, before);
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        String comment = meta.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT '").append(comment).append("'");
        }
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = meta.getColumns();
        if (null != columns && !columns.isEmpty()) {
            if (!this.slice(slice)) {
                builder.append("ALTER TABLE ");
                this.name(runtime, builder, (Metadata)meta.getTable(true));
            } else {
                run.slice(slice);
            }
            builder.append(" ADD PRIMARY KEY (");
            Column.sort((LinkedHashMap)meta.getPositions(), (LinkedHashMap)columns);
            this.delimiter(builder, Column.names((LinkedHashMap)columns));
            builder.append(")");
            String type = meta.getType();
            if (BasicUtil.isNotEmpty((Object)type)) {
                builder.append(" USING ").append(type);
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, origin, meta, slice);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)meta.getTable(true));
        } else {
            run.slice(slice);
        }
        builder.append(" DROP PRIMARY KEY");
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        LinkedHashMap origins = this.indexes(runtime, null, table, meta.getName());
        if (!origins.isEmpty()) {
            this.drop(runtime, meta);
        }
        return this.add(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAppendIndexRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendIndexRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (Metadata)meta.getTable(true));
        if (meta.isPrimary()) {
            builder.append(" DROP PRIMARY KEY");
        } else {
            builder.append(" DROP INDEX ").append(meta.getName());
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        String type = meta.getType();
        if (BasicUtil.isNotEmpty((Object)type)) {
            builder.append("USING ").append(type).append(" ");
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        String comment = meta.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT '").append(comment).append("'");
        }
        return builder;
    }

    @Override
    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        return super.each(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        log.warn("MySQL\u4e0d\u652f\u6301 rename procedure(" + meta.getName() + ")");
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        return super.parameter(runtime, builder, parameter);
    }

    @Override
    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        log.warn("MySQL\u4e0d\u652f\u6301 rename Function(" + meta.getName() + ")");
        return new ArrayList<Run>();
    }

    @Override
    public boolean create(DataRuntime runtime, Sequence meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Sequence meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Sequence meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Sequence origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Sequence meta) throws Exception {
        log.warn("MySQL\u4e0d\u652f\u6301 rename Sequence(" + meta.getName() + ")");
        return new ArrayList<Run>();
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.Authorize action, Run run) {
        return super.execute(runtime, random, meta, action, run);
    }

    @Override
    public boolean create(DataRuntime runtime, User user) throws Exception {
        return super.create(runtime, user);
    }

    @Override
    public boolean rename(DataRuntime runtime, User origin, User update) throws Exception {
        return super.rename(runtime, origin, update);
    }

    @Override
    public boolean drop(DataRuntime runtime, User user) throws Exception {
        return super.drop(runtime, user);
    }

    @Override
    public <T extends User> List<T> users(DataRuntime runtime, String random, boolean greedy, User query) throws Exception {
        return super.users(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, User user) throws Exception {
        String password;
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE USER '").append(user.getName()).append("'");
        String host = user.getHost();
        if (BasicUtil.isNotEmpty((Object)host)) {
            builder.append("@'").append(host).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)(password = user.getPassword()))) {
            builder.append(" IDENTIFIED BY '").append(password).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, User origin, User update) throws Exception {
        return super.buildRenameRun(runtime, origin, update);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, User user) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP USER '").append(user.getName()).append("'");
        String host = user.getHost();
        if (BasicUtil.isNotEmpty((Object)host)) {
            builder.append("@'").append(host).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildQueryUsersRun(DataRuntime runtime, boolean greedy, User query) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM mysql.user");
        configs.and(Compare.LIKE_SIMPLE, "user", (Object)query.getName());
        configs.and("Host", (Object)query.getHost());
        return runs;
    }

    @Override
    public MetadataFieldRefer initUserFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(User.class);
        refer.map("HOST", "host");
        refer.map("NAME", "user");
        return refer;
    }

    @Override
    public <T extends User> List<T> users(DataRuntime runtime, int index, boolean create, List<T> previous, User query, DataSet set) throws Exception {
        return super.users(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends User> T init(DataRuntime runtime, int index, T meta, User query, DataRow row) {
        MetadataFieldRefer refer = this.refer(runtime, User.class);
        if (null == meta) {
            meta = new User();
        }
        meta.setHost(row.getString(refer.maps("HOST")));
        meta.setName(row.getString(refer.maps("NAME")));
        return meta;
    }

    @Override
    public <T extends User> T detail(DataRuntime runtime, int index, T meta, User query, DataRow row) {
        return super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Privilege> List<T> privileges(DataRuntime runtime, String random, boolean greedy, Privilege query) throws Exception {
        return super.privileges(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryPrivilegesRun(DataRuntime runtime, boolean greedy, Privilege query) throws Exception {
        return super.buildQueryPrivilegesRun(runtime, greedy, query);
    }

    @Override
    public <T extends Privilege> List<T> privileges(DataRuntime runtime, int index, boolean create, List<T> previous, Privilege query, DataSet set) throws Exception {
        return super.privileges(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Privilege> T init(DataRuntime runtime, int index, T meta, Privilege query, DataRow row) {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Privilege> T detail(DataRuntime runtime, int index, T meta, Privilege query, DataRow row) {
        return super.detail(runtime, index, meta, query, row);
    }

    @Override
    public boolean grant(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        return super.grant(runtime, user, privileges);
    }

    @Override
    public List<Run> buildGrantRun(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        for (Privilege privilege : privileges) {
            String objectName;
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            List actions = privilege.getActions();
            if (actions.isEmpty()) {
                actions.add(privilege.getName());
            }
            builder.append("GRANT ").append(BeanUtil.concat((Collection)actions));
            builder.append(" ON ");
            String database = privilege.getDatabaseName();
            if (BasicUtil.isEmpty((Object)database)) {
                database = privilege.getSchemaName();
            }
            if (BasicUtil.isEmpty((Object)database)) {
                database = "*";
            }
            if (BasicUtil.isEmpty((Object)(objectName = privilege.getObjectName()))) {
                objectName = "*";
            }
            builder.append(database).append(".").append(objectName);
            builder.append(" TO '").append(user.getName()).append("'");
            String host = user.getHost();
            if (!BasicUtil.isNotEmpty((Object)host)) continue;
            builder.append("@'").append(host).append("'");
        }
        return runs;
    }

    @Override
    public boolean revoke(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        return super.revoke(runtime, user, privileges);
    }

    @Override
    public List<Run> buildRevokeRun(DataRuntime runtime, User user, Privilege ... privileges) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        for (Privilege privilege : privileges) {
            String objectName;
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            List actions = privilege.getActions();
            if (actions.isEmpty()) {
                actions.add(privilege.getName());
            }
            builder.append("REVOKE ").append(BeanUtil.concat((Collection)actions));
            builder.append(" ON ");
            String database = privilege.getDatabaseName();
            if (BasicUtil.isEmpty((Object)database)) {
                database = privilege.getSchemaName();
            }
            if (BasicUtil.isEmpty((Object)database)) {
                database = "*";
            }
            if (BasicUtil.isEmpty((Object)(objectName = privilege.getObjectName()))) {
                objectName = "*";
            }
            builder.append(database).append(".").append(objectName);
            builder.append(" FROM '").append(user.getName()).append("'");
            String host = user.getHost();
            if (!BasicUtil.isNotEmpty((Object)host)) continue;
            builder.append("@'").append(host).append("'");
        }
        return runs;
    }

    public <T extends Metadata> void correctSchemaFromJDBC(DataRuntime runtime, T meta, String catalog, String schema, boolean overrideRuntime, boolean overrideMeta) {
        if (overrideMeta || this.empty((Metadata)meta.getSchema())) {
            meta.setSchema(catalog);
        }
    }

    public String[] correctSchemaFromJDBC(String catalog, String schema) {
        return new String[]{schema, null};
    }

    @Override
    public String insertHead(ConfigStore configs) {
        Boolean override = null;
        if (null != configs) {
            override = configs.override();
        }
        if (null == override) {
            return "INSERT INTO ";
        }
        if (override.booleanValue()) {
            return "REPLACE INTO ";
        }
        return "INSERT IGNORE INTO ";
    }

    @Override
    public String insertFoot(ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return "";
    }

    public String columnFieldLengthRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnFieldLengthRefer(runtime, meta);
    }

    public String columnFieldPrecisionRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnFieldPrecisionRefer(runtime, meta);
    }

    public String columnFieldScaleRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnFieldScaleRefer(runtime, meta);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATETIME) {
            return "now()";
        }
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATE) {
            return "curdate()";
        }
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "curtime()";
        }
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIMESTAMP) {
            return "now()";
        }
        return null;
    }

    @Override
    public String concat(DataRuntime runtime, String ... args) {
        return super.concatFun(runtime, args);
    }

    @Override
    protected String dummy() {
        return super.dummy();
    }

    static {
        types.put((Type)Table.TYPE.NORMAL, "BASE TABLE");
        types.put((Type)Table.TYPE.VIEW, "VIEW");
        types.put((Type)View.TYPE.NORMAL, "VIEW");
        types.put((Type)Metadata.TYPE.TABLE, "BASE TABLE");
        types.put((Type)Metadata.TYPE.VIEW, "VIEW");
    }
}

