/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.journal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncoderPersister;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalLoaderCallback;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalReaderCallback;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalRecord;
import org.apache.activemq.artemis.jdbc.store.journal.TransactionHolder;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.jboss.logging.Logger;

public class JDBCJournalImpl
extends AbstractJDBCDriver
implements Journal {
    private static final Logger logger = Logger.getLogger(JDBCJournalImpl.class);
    private long syncDelay;
    private static int USER_VERSION = 1;
    private final List<JDBCJournalRecord> records;
    private PreparedStatement insertJournalRecords;
    private PreparedStatement selectJournalRecords;
    private PreparedStatement countJournalRecords;
    private PreparedStatement deleteJournalRecords;
    private PreparedStatement deleteJournalTxRecords;
    private boolean started;
    private AtomicBoolean failed = new AtomicBoolean(false);
    private JDBCJournalSync syncTimer;
    private final Executor completeExecutor;
    private final ScheduledExecutorService scheduledExecutorService;
    private Map<Long, TransactionHolder> transactions = new ConcurrentHashMap<Long, TransactionHolder>();
    private final AtomicLong seq = new AtomicLong(0L);
    private final IOCriticalErrorListener criticalIOErrorListener;

    public JDBCJournalImpl(DataSource dataSource, SQLProvider provider, String tableName, ScheduledExecutorService scheduledExecutorService, Executor completeExecutor, IOCriticalErrorListener criticalIOErrorListener, long syncDelay) {
        super(dataSource, provider);
        this.records = new ArrayList<JDBCJournalRecord>();
        this.scheduledExecutorService = scheduledExecutorService;
        this.completeExecutor = completeExecutor;
        this.criticalIOErrorListener = criticalIOErrorListener;
        this.syncDelay = syncDelay;
    }

    public JDBCJournalImpl(String jdbcUrl, String jdbcDriverClass, SQLProvider sqlProvider, ScheduledExecutorService scheduledExecutorService, Executor completeExecutor, IOCriticalErrorListener criticalIOErrorListener, long syncDelay) {
        super(sqlProvider, jdbcUrl, jdbcDriverClass);
        this.records = new ArrayList<JDBCJournalRecord>();
        this.scheduledExecutorService = scheduledExecutorService;
        this.completeExecutor = completeExecutor;
        this.criticalIOErrorListener = criticalIOErrorListener;
        this.syncDelay = syncDelay;
    }

    @Override
    public void start() throws SQLException {
        super.start();
        this.syncTimer = new JDBCJournalSync(this.scheduledExecutorService, this.completeExecutor, this.syncDelay, TimeUnit.MILLISECONDS, this);
        this.started = true;
    }

    public void flush() throws Exception {
    }

    public long getMaxRecordSize() {
        return this.sqlProvider.getMaxBlobSize();
    }

    @Override
    protected void createSchema() throws SQLException {
        this.createTable(this.sqlProvider.getCreateJournalTableSQL());
    }

    @Override
    protected void prepareStatements() throws SQLException {
        logger.tracef("preparing statements", new Object[0]);
        this.insertJournalRecords = this.connection.prepareStatement(this.sqlProvider.getInsertJournalRecordsSQL());
        this.selectJournalRecords = this.connection.prepareStatement(this.sqlProvider.getSelectJournalRecordsSQL());
        this.countJournalRecords = this.connection.prepareStatement(this.sqlProvider.getCountJournalRecordsSQL());
        this.deleteJournalRecords = this.connection.prepareStatement(this.sqlProvider.getDeleteJournalRecordsSQL());
        this.deleteJournalTxRecords = this.connection.prepareStatement(this.sqlProvider.getDeleteJournalTxRecordsSQL());
    }

    @Override
    public void stop() throws SQLException {
        this.stop(true);
    }

    public synchronized void stop(boolean sync) throws SQLException {
        if (this.started) {
            if (sync) {
                this.sync();
            }
            this.started = false;
            super.stop();
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        super.destroy();
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int sync() {
        ArrayList<JDBCJournalRecord> recordRef;
        List<JDBCJournalRecord> list = this.records;
        synchronized (list) {
            if (this.records.isEmpty()) {
                return 0;
            }
            recordRef = new ArrayList<JDBCJournalRecord>(this.records);
            this.records.clear();
        }
        if (!this.started || this.failed.get()) {
            this.executeCallbacks(recordRef, false);
            return 0;
        }
        ArrayList<Long> deletedRecords = new ArrayList<Long>();
        ArrayList<Long> committedTransactions = new ArrayList<Long>();
        try {
            this.connection.setAutoCommit(false);
            block10: for (JDBCJournalRecord record : recordRef) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("sync::preparing JDBC statement for " + record));
                }
                switch (record.getRecordType()) {
                    case 16: {
                        deletedRecords.add(record.getId());
                        record.writeDeleteRecord(this.deleteJournalRecords);
                        continue block10;
                    }
                    case 19: {
                        this.deleteJournalTxRecords.setLong(1, record.getTxId());
                        this.deleteJournalTxRecords.addBatch();
                        continue block10;
                    }
                    case 18: {
                        TransactionHolder holder = this.transactions.get(record.getTxId());
                        for (RecordInfo info : holder.recordsToDelete) {
                            deletedRecords.add(record.getId());
                            this.deleteJournalRecords.setLong(1, info.id);
                            this.deleteJournalRecords.addBatch();
                        }
                        record.writeRecord(this.insertJournalRecords);
                        committedTransactions.add(record.getTxId());
                        continue block10;
                    }
                }
                record.writeRecord(this.insertJournalRecords);
            }
            this.insertJournalRecords.executeBatch();
            this.deleteJournalRecords.executeBatch();
            this.deleteJournalTxRecords.executeBatch();
            this.connection.commit();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"JDBC commit worked");
            }
            this.cleanupTxRecords(deletedRecords, committedTransactions);
            this.executeCallbacks(recordRef, true);
            return recordRef.size();
        }
        catch (Exception e) {
            this.handleException(recordRef, e);
            return 0;
        }
    }

    public void handleException(List<JDBCJournalRecord> recordRef, Throwable e) {
        logger.warn((Object)e.getMessage(), e);
        this.failed.set(true);
        this.criticalIOErrorListener.onIOException(e, "Critical IO Error.  Failed to process JDBC Record statements", null);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Rolling back Transaction, just in case");
        }
        try {
            this.connection.rollback();
        }
        catch (Throwable rollback) {
            logger.warn((Object)rollback);
        }
        try {
            this.connection.close();
        }
        catch (Throwable rollback) {
            logger.warn((Object)rollback);
        }
        if (recordRef != null) {
            this.executeCallbacks(recordRef, false);
        }
    }

    private synchronized void cleanupTxRecords(List<Long> deletedRecords, List<Long> committedTx) throws SQLException {
        ArrayList<TransactionHolder> iterableCopyTx = new ArrayList<TransactionHolder>();
        iterableCopyTx.addAll(this.transactions.values());
        for (Long txId : committedTx) {
            this.transactions.get((Object)txId).committed = true;
        }
        for (TransactionHolder h : iterableCopyTx) {
            ArrayList<RecordInfo> iterableCopy = new ArrayList<RecordInfo>();
            iterableCopy.addAll(h.recordInfos);
            for (RecordInfo info : iterableCopy) {
                if (!deletedRecords.contains(info.id)) continue;
                h.recordInfos.remove(info);
            }
            if (!h.recordInfos.isEmpty() || !h.committed) continue;
            this.deleteJournalTxRecords.setLong(1, h.transactionID);
            this.deleteJournalTxRecords.addBatch();
            this.transactions.remove(h.transactionID);
        }
    }

    private void executeCallbacks(final List<JDBCJournalRecord> records, final boolean success) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (JDBCJournalRecord record : records) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Calling callback " + record + " with success = " + success));
                    }
                    record.complete(success);
                }
            }
        };
        this.completeExecutor.execute(r);
    }

    private void checkStatus() {
        this.checkStatus(null);
    }

    private void checkStatus(IOCompletion callback) {
        if (!this.started) {
            if (callback != null) {
                callback.onError(-1, "JDBC Journal is not loaded");
            }
            throw new IllegalStateException("JDBCJournal is not loaded");
        }
        if (this.failed.get()) {
            if (callback != null) {
                callback.onError(-1, "JDBC Journal failed");
            }
            throw new IllegalStateException("JDBCJournal Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendRecord(JDBCJournalRecord record) throws Exception {
        this.checkStatus();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendRecord " + record));
        }
        record.storeLineUp();
        if (!this.started && record.getIoCompletion() != null) {
            record.getIoCompletion().onError(ActiveMQExceptionType.IO_ERROR.getCode(), "JDBC Journal not started");
        }
        SimpleWaitIOCallback callback = null;
        if (record.isSync() && record.getIoCompletion() == null) {
            callback = new SimpleWaitIOCallback();
            record.setIoCompletion((IOCompletion)callback);
        }
        JDBCJournalImpl jDBCJournalImpl = this;
        synchronized (jDBCJournalImpl) {
            if (record.isTransactional() || record.getRecordType() == 17) {
                this.addTxRecord(record);
            }
            List<JDBCJournalRecord> list = this.records;
            synchronized (list) {
                this.records.add(record);
            }
        }
        this.syncTimer.delay();
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    private synchronized void addTxRecord(JDBCJournalRecord record) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("addTxRecord " + record + ", started=" + this.started + ", failed=" + this.failed));
        }
        this.checkStatus();
        TransactionHolder txHolder = this.transactions.get(record.getTxId());
        if (txHolder == null) {
            txHolder = new TransactionHolder(record.getTxId());
            this.transactions.put(record.getTxId(), txHolder);
        }
        if (record.isTransactional()) {
            RecordInfo info = new RecordInfo(record.getId().longValue(), record.getRecordType(), new byte[0], record.isUpdate(), (short)record.getCompactCount());
            if (record.getRecordType() == 15) {
                txHolder.recordsToDelete.add(info);
            } else {
                txHolder.recordInfos.add(info);
            }
        } else {
            txHolder.prepared = true;
        }
    }

    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendAddRecord bytes[] " + r));
        }
        this.appendRecord(r);
    }

    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendAddRecord (encoding) " + r + " with record = " + record));
        }
        this.appendRecord(r);
    }

    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.checkStatus(completionCallback);
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setSync(sync);
        r.setIoCompletion(completionCallback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendAddRecord (completionCallback & encoding) " + r + " with record = " + record));
        }
        this.appendRecord(r);
    }

    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 12, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendUpdateRecord (bytes)) " + r));
        }
        this.appendRecord(r);
    }

    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 12, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendUpdateRecord (encoding)) " + r + " with record " + record));
        }
        this.appendRecord(r);
    }

    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.checkStatus(completionCallback);
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setSync(sync);
        r.setIoCompletion(completionCallback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendUpdateRecord (encoding & completioncallback)) " + r + " with record " + record));
        }
        this.appendRecord(r);
    }

    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 16, this.seq.incrementAndGet());
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendDeleteRecord id=" + id + " sync=" + sync));
        }
        this.appendRecord(r);
    }

    public void appendDeleteRecord(long id, boolean sync, IOCompletion completionCallback) throws Exception {
        this.checkStatus(completionCallback);
        JDBCJournalRecord r = new JDBCJournalRecord(id, 16, this.seq.incrementAndGet());
        r.setSync(sync);
        r.setIoCompletion(completionCallback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendDeleteRecord id=" + id + " sync=" + sync + " with completionCallback"));
        }
        this.appendRecord(r);
    }

    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 13, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setTxId(txID);
        this.appendRecord(r);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendAddRecordTransactional txID=" + txID + " id=" + id + " using bytes[] r=" + r));
        }
    }

    public void appendAddRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 13, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendAddRecordTransactional txID=" + txID + " id=" + id + " using encoding=" + record + " and r=" + r));
        }
        this.appendRecord(r);
    }

    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 14, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendUpdateRecordTransactional txID=" + txID + " id=" + id + " using bytes and r=" + r));
        }
        this.appendRecord(r);
    }

    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 14, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(persister, record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendUpdateRecordTransactional txID=" + txID + " id=" + id + " using encoding=" + record + " and r=" + r));
        }
        this.appendRecord(r);
    }

    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 15, this.seq.incrementAndGet());
        r.setRecord(record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendDeleteRecordTransactional txID=" + txID + " id=" + id + " using bytes and r=" + r));
        }
        this.appendRecord(r);
    }

    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 15, this.seq.incrementAndGet());
        r.setRecord((Persister)EncoderPersister.getInstance(), record);
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendDeleteRecordTransactional txID=" + txID + " id=" + id + " using encoding=" + record + " and r=" + r));
        }
        this.appendRecord(r);
    }

    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(id, 15, this.seq.incrementAndGet());
        r.setTxId(txID);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendDeleteRecordTransactional txID=" + txID + " id=" + id));
        }
        this.appendRecord(r);
    }

    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 18, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendCommitRecord txID=" + txID + " sync=" + sync));
        }
        this.appendRecord(r);
    }

    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 18, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        r.setIoCompletion(callback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendCommitRecord txID=" + txID + " callback=" + callback));
        }
        this.appendRecord(r);
    }

    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 18, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setStoreLineUp(lineUpContext);
        r.setIoCompletion(callback);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendCommitRecord txID=" + txID + " using callback, lineup=" + lineUpContext));
        }
        this.appendRecord(r);
    }

    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 17, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setTxData(transactionData);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendPrepareRecord txID=" + txID + " using sync=" + sync));
        }
        this.appendRecord(r);
    }

    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 17, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setTxData(transactionData);
        r.setTxData(transactionData);
        r.setSync(sync);
        r.setIoCompletion(callback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendPrepareRecord txID=" + txID + " using callback, sync=" + sync));
        }
        this.appendRecord(r);
    }

    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 17, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setTxData(transactionData);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendPrepareRecord txID=" + txID + " transactionData, sync=" + sync));
        }
        this.appendRecord(r);
    }

    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 19, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendRollbackRecord txID=" + txID + " sync=" + sync));
        }
        this.appendRecord(r);
    }

    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.checkStatus();
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 19, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        r.setIoCompletion(callback);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendRollbackRecord txID=" + txID + " sync=" + sync + " using callback"));
        }
        this.appendRecord(r);
    }

    public synchronized JournalLoadInformation load(LoaderCallback reloadManager) {
        JournalLoadInformation jli = new JournalLoadInformation();
        JDBCJournalReaderCallback jrc = new JDBCJournalReaderCallback(reloadManager);
        try (ResultSet rs = this.selectJournalRecords.executeQuery();){
            int noRecords = 0;
            while (rs.next()) {
                JDBCJournalRecord r = JDBCJournalRecord.readRecord(rs);
                switch (r.getRecordType()) {
                    case 11: {
                        jrc.onReadAddRecord(r.toRecordInfo());
                        break;
                    }
                    case 12: {
                        jrc.onReadUpdateRecord(r.toRecordInfo());
                        break;
                    }
                    case 16: {
                        jrc.onReadDeleteRecord(r.getId());
                        break;
                    }
                    case 13: {
                        jrc.onReadAddRecordTX(r.getTxId(), r.toRecordInfo());
                        break;
                    }
                    case 14: {
                        jrc.onReadUpdateRecordTX(r.getTxId(), r.toRecordInfo());
                        break;
                    }
                    case 15: {
                        jrc.onReadDeleteRecordTX(r.getTxId(), r.toRecordInfo());
                        break;
                    }
                    case 17: {
                        jrc.onReadPrepareRecord(r.getTxId(), r.getTxDataAsByteArray(), r.getTxCheckNoRecords());
                        break;
                    }
                    case 18: {
                        jrc.onReadCommitRecord(r.getTxId(), r.getTxCheckNoRecords());
                        break;
                    }
                    case 19: {
                        jrc.onReadRollbackRecord(r.getTxId());
                        break;
                    }
                    default: {
                        throw new Exception("Error Reading Journal, Unknown Record Type: " + r.getRecordType());
                    }
                }
                ++noRecords;
                if (r.getSeq() <= this.seq.longValue()) continue;
                this.seq.set(r.getSeq());
            }
            jrc.checkPreparedTx();
            jli.setMaxID(((JDBCJournalLoaderCallback)reloadManager).getMaxId());
            jli.setNumberOfRecords(noRecords);
            this.transactions = jrc.getTransactions();
        }
        catch (Throwable e) {
            this.handleException(null, e);
        }
        return jli;
    }

    public JournalLoadInformation loadInternalOnly() throws Exception {
        return null;
    }

    public JournalLoadInformation loadSyncOnly(Journal.JournalState state) throws Exception {
        return null;
    }

    public void lineUpContext(IOCompletion callback) {
        callback.storeLineUp();
    }

    public synchronized JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback failureCallback, boolean fixBadTX) throws Exception {
        JDBCJournalLoaderCallback lc = new JDBCJournalLoaderCallback(committedRecords, preparedTransactions, failureCallback, fixBadTX);
        return this.load(lc);
    }

    public int getAlignment() throws Exception {
        return 0;
    }

    public int getNumberOfRecords() {
        int count = 0;
        try (ResultSet rs = this.countJournalRecords.executeQuery();){
            rs.next();
            count = rs.getInt(1);
        }
        catch (SQLException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
        return count;
    }

    public int getUserVersion() {
        return USER_VERSION;
    }

    public void runDirectJournalBlast() throws Exception {
    }

    public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        return null;
    }

    public final void synchronizationLock() {
        logger.error((Object)"Replication is not supported with JDBC Store", (Throwable)new Exception("trace"));
    }

    public final void synchronizationUnlock() {
        logger.error((Object)"Replication is not supported with JDBC Store", (Throwable)new Exception("trace"));
    }

    public void forceMoveNextFile() throws Exception {
    }

    public JournalFile[] getDataFiles() {
        return new JournalFile[0];
    }

    public SequentialFileFactory getFileFactory() {
        return null;
    }

    public int getFileSize() {
        return 0;
    }

    public void scheduleCompactAndBlock(int timeout) throws Exception {
    }

    public void replicationSyncPreserveOldFiles() {
    }

    public void replicationSyncFinished() {
    }

    public boolean isStarted() {
        return this.started;
    }

    private static class JDBCJournalSync
    extends ActiveMQScheduledComponent {
        private final JDBCJournalImpl journal;

        JDBCJournalSync(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, JDBCJournalImpl journal) {
            super(scheduledExecutorService, executor, checkPeriod, timeUnit, true);
            this.journal = journal;
        }

        public void run() {
            if (this.journal.isStarted()) {
                this.journal.sync();
            }
        }
    }
}

