/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.server.config.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.utils.BufferHelper;

public class ConnectionFactoryConfigurationImpl
implements ConnectionFactoryConfiguration {
    private String name = null;
    private boolean persisted = false;
    private String[] bindings = null;
    private List<String> connectorNames = null;
    private String discoveryGroupName = null;
    private String clientID = null;
    private boolean ha = false;
    private long clientFailureCheckPeriod = ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
    private long connectionTTL = ActiveMQClient.DEFAULT_CONNECTION_TTL;
    private long callTimeout = 30000L;
    private long callFailoverTimeout = 30000L;
    private boolean cacheLargeMessagesClient = false;
    private int minLargeMessageSize = 102400;
    private boolean compressLargeMessage = false;
    private int consumerWindowSize = 0x100000;
    private int consumerMaxRate = -1;
    private int confirmationWindowSize = -1;
    private int producerWindowSize = 65536;
    private int producerMaxRate = -1;
    private boolean blockOnAcknowledge = false;
    private boolean blockOnDurableSend = true;
    private boolean blockOnNonDurableSend = false;
    private boolean autoGroup = false;
    private boolean preAcknowledge = false;
    private String loadBalancingPolicyClassName = ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
    private int transactionBatchSize = 0x100000;
    private int dupsOKBatchSize = 0x100000;
    private long initialWaitTimeout = 10000L;
    private boolean useGlobalPools = true;
    private int scheduledThreadPoolMaxSize = 5;
    private int threadPoolMaxSize = -1;
    private long retryInterval = 2000L;
    private double retryIntervalMultiplier = ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER;
    private long maxRetryInterval = ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL;
    private int reconnectAttempts = 0;
    private boolean failoverOnInitialConnection = false;
    private String groupID = null;
    private String protocolManagerFactoryStr;
    private JMSFactoryType factoryType = JMSFactoryType.CF;
    private String deserializationBlackList;
    private String deserializationWhiteList;
    private int initialMessagePacketSize = 1500;

    @Override
    public String[] getBindings() {
        return this.bindings;
    }

    @Override
    public ConnectionFactoryConfiguration setBindings(String ... bindings) {
        this.bindings = bindings;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConnectionFactoryConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    @Override
    public ConnectionFactoryConfiguration setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
        return this;
    }

    @Override
    public List<String> getConnectorNames() {
        return this.connectorNames;
    }

    @Override
    public ConnectionFactoryConfiguration setConnectorNames(List<String> connectorNames) {
        this.connectorNames = connectorNames;
        return this;
    }

    @Override
    public ConnectionFactoryConfiguration setConnectorNames(String ... names) {
        return this.setConnectorNames(Arrays.asList(names));
    }

    @Override
    public boolean isHA() {
        return this.ha;
    }

    @Override
    public ConnectionFactoryConfiguration setHA(boolean ha) {
        this.ha = ha;
        return this;
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public ConnectionFactoryConfiguration setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    @Override
    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    @Override
    public ConnectionFactoryConfiguration setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        return this;
    }

    @Override
    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public ConnectionFactoryConfiguration setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
        return this;
    }

    @Override
    public long getCallTimeout() {
        return this.callTimeout;
    }

    @Override
    public ConnectionFactoryConfiguration setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    @Override
    public long getCallFailoverTimeout() {
        return this.callFailoverTimeout;
    }

    @Override
    public ConnectionFactoryConfiguration setCallFailoverTimeout(long callFailoverTimeout) {
        this.callFailoverTimeout = callFailoverTimeout;
        return this;
    }

    @Override
    public boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    @Override
    public ConnectionFactoryConfiguration setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.cacheLargeMessagesClient = cacheLargeMessagesClient;
        return this;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public ConnectionFactoryConfiguration setMinLargeMessageSize(int minLargeMessageSize) {
        this.minLargeMessageSize = minLargeMessageSize;
        return this;
    }

    @Override
    public int getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    @Override
    public ConnectionFactoryConfiguration setConsumerWindowSize(int consumerWindowSize) {
        this.consumerWindowSize = consumerWindowSize;
        return this;
    }

    @Override
    public int getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    @Override
    public ConnectionFactoryConfiguration setConsumerMaxRate(int consumerMaxRate) {
        this.consumerMaxRate = consumerMaxRate;
        return this;
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    @Override
    public ConnectionFactoryConfiguration setConfirmationWindowSize(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
        return this;
    }

    @Override
    public int getProducerMaxRate() {
        return this.producerMaxRate;
    }

    @Override
    public ConnectionFactoryConfiguration setProducerMaxRate(int producerMaxRate) {
        this.producerMaxRate = producerMaxRate;
        return this;
    }

    @Override
    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    @Override
    public ConnectionFactoryConfiguration setProducerWindowSize(int producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
        return this;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public ConnectionFactoryConfiguration setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.blockOnAcknowledge = blockOnAcknowledge;
        return this;
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public ConnectionFactoryConfiguration setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.blockOnDurableSend = blockOnDurableSend;
        return this;
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public ConnectionFactoryConfiguration setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.blockOnNonDurableSend = blockOnNonDurableSend;
        return this;
    }

    @Override
    public boolean isAutoGroup() {
        return this.autoGroup;
    }

    @Override
    public ConnectionFactoryConfiguration setAutoGroup(boolean autoGroup) {
        this.autoGroup = autoGroup;
        return this;
    }

    @Override
    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    @Override
    public ConnectionFactoryConfiguration setPreAcknowledge(boolean preAcknowledge) {
        this.preAcknowledge = preAcknowledge;
        return this;
    }

    @Override
    public String getLoadBalancingPolicyClassName() {
        return this.loadBalancingPolicyClassName;
    }

    @Override
    public ConnectionFactoryConfiguration setLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.loadBalancingPolicyClassName = loadBalancingPolicyClassName;
        return this;
    }

    @Override
    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    @Override
    public ConnectionFactoryConfiguration setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
        return this;
    }

    @Override
    public int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    @Override
    public ConnectionFactoryConfiguration setDupsOKBatchSize(int dupsOKBatchSize) {
        this.dupsOKBatchSize = dupsOKBatchSize;
        return this;
    }

    public long getInitialWaitTimeout() {
        return this.initialWaitTimeout;
    }

    public ConnectionFactoryConfiguration setInitialWaitTimeout(long initialWaitTimeout) {
        this.initialWaitTimeout = initialWaitTimeout;
        return this;
    }

    @Override
    public boolean isUseGlobalPools() {
        return this.useGlobalPools;
    }

    @Override
    public ConnectionFactoryConfiguration setUseGlobalPools(boolean useGlobalPools) {
        this.useGlobalPools = useGlobalPools;
        return this;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public ConnectionFactoryConfiguration setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
        return this;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public ConnectionFactoryConfiguration setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.threadPoolMaxSize = threadPoolMaxSize;
        return this;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public ConnectionFactoryConfiguration setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    @Override
    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @Override
    public ConnectionFactoryConfiguration setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        return this;
    }

    @Override
    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    @Override
    public ConnectionFactoryConfiguration setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
        return this;
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public ConnectionFactoryConfiguration setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    @Override
    public boolean isFailoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    @Override
    public ConnectionFactoryConfiguration setFailoverOnInitialConnection(boolean failover) {
        this.failoverOnInitialConnection = failover;
        return this;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public ConnectionFactoryConfiguration setGroupID(String groupID) {
        this.groupID = groupID;
        return this;
    }

    public void decode(ActiveMQBuffer buffer) {
        this.persisted = true;
        this.name = buffer.readSimpleString().toString();
        this.discoveryGroupName = BufferHelper.readNullableSimpleStringAsString((ActiveMQBuffer)buffer);
        int nConnectors = buffer.readInt();
        if (nConnectors > 0) {
            this.connectorNames = new ArrayList<String>(nConnectors);
            for (int i = 0; i < nConnectors; ++i) {
                SimpleString str = buffer.readSimpleString();
                this.connectorNames.add(str.toString());
            }
        }
        this.ha = buffer.readBoolean();
        this.clientID = BufferHelper.readNullableSimpleStringAsString((ActiveMQBuffer)buffer);
        this.clientFailureCheckPeriod = buffer.readLong();
        this.connectionTTL = buffer.readLong();
        this.callTimeout = buffer.readLong();
        this.cacheLargeMessagesClient = buffer.readBoolean();
        this.minLargeMessageSize = buffer.readInt();
        this.consumerWindowSize = buffer.readInt();
        this.consumerMaxRate = buffer.readInt();
        this.confirmationWindowSize = buffer.readInt();
        this.producerWindowSize = buffer.readInt();
        this.producerMaxRate = buffer.readInt();
        this.blockOnAcknowledge = buffer.readBoolean();
        this.blockOnDurableSend = buffer.readBoolean();
        this.blockOnNonDurableSend = buffer.readBoolean();
        this.autoGroup = buffer.readBoolean();
        this.preAcknowledge = buffer.readBoolean();
        this.loadBalancingPolicyClassName = buffer.readSimpleString().toString();
        this.transactionBatchSize = buffer.readInt();
        this.dupsOKBatchSize = buffer.readInt();
        this.initialWaitTimeout = buffer.readLong();
        this.useGlobalPools = buffer.readBoolean();
        this.scheduledThreadPoolMaxSize = buffer.readInt();
        this.threadPoolMaxSize = buffer.readInt();
        this.retryInterval = buffer.readLong();
        this.retryIntervalMultiplier = buffer.readDouble();
        this.maxRetryInterval = buffer.readLong();
        this.reconnectAttempts = buffer.readInt();
        this.failoverOnInitialConnection = buffer.readBoolean();
        this.compressLargeMessage = buffer.readBoolean();
        this.groupID = BufferHelper.readNullableSimpleStringAsString((ActiveMQBuffer)buffer);
        this.factoryType = JMSFactoryType.valueOf((int)buffer.readInt());
        this.protocolManagerFactoryStr = BufferHelper.readNullableSimpleStringAsString((ActiveMQBuffer)buffer);
        this.deserializationBlackList = BufferHelper.readNullableSimpleStringAsString((ActiveMQBuffer)buffer);
        this.deserializationWhiteList = BufferHelper.readNullableSimpleStringAsString((ActiveMQBuffer)buffer);
    }

    public void encode(ActiveMQBuffer buffer) {
        this.persisted = true;
        BufferHelper.writeAsSimpleString((ActiveMQBuffer)buffer, (String)this.name);
        BufferHelper.writeAsNullableSimpleString((ActiveMQBuffer)buffer, (String)this.discoveryGroupName);
        if (this.connectorNames == null) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(this.connectorNames.size());
            for (String tc : this.connectorNames) {
                BufferHelper.writeAsSimpleString((ActiveMQBuffer)buffer, (String)tc);
            }
        }
        buffer.writeBoolean(this.ha);
        BufferHelper.writeAsNullableSimpleString((ActiveMQBuffer)buffer, (String)this.clientID);
        buffer.writeLong(this.clientFailureCheckPeriod);
        buffer.writeLong(this.connectionTTL);
        buffer.writeLong(this.callTimeout);
        buffer.writeBoolean(this.cacheLargeMessagesClient);
        buffer.writeInt(this.minLargeMessageSize);
        buffer.writeInt(this.consumerWindowSize);
        buffer.writeInt(this.consumerMaxRate);
        buffer.writeInt(this.confirmationWindowSize);
        buffer.writeInt(this.producerWindowSize);
        buffer.writeInt(this.producerMaxRate);
        buffer.writeBoolean(this.blockOnAcknowledge);
        buffer.writeBoolean(this.blockOnDurableSend);
        buffer.writeBoolean(this.blockOnNonDurableSend);
        buffer.writeBoolean(this.autoGroup);
        buffer.writeBoolean(this.preAcknowledge);
        BufferHelper.writeAsSimpleString((ActiveMQBuffer)buffer, (String)this.loadBalancingPolicyClassName);
        buffer.writeInt(this.transactionBatchSize);
        buffer.writeInt(this.dupsOKBatchSize);
        buffer.writeLong(this.initialWaitTimeout);
        buffer.writeBoolean(this.useGlobalPools);
        buffer.writeInt(this.scheduledThreadPoolMaxSize);
        buffer.writeInt(this.threadPoolMaxSize);
        buffer.writeLong(this.retryInterval);
        buffer.writeDouble(this.retryIntervalMultiplier);
        buffer.writeLong(this.maxRetryInterval);
        buffer.writeInt(this.reconnectAttempts);
        buffer.writeBoolean(this.failoverOnInitialConnection);
        buffer.writeBoolean(this.compressLargeMessage);
        BufferHelper.writeAsNullableSimpleString((ActiveMQBuffer)buffer, (String)this.groupID);
        buffer.writeInt(this.factoryType.intValue());
        BufferHelper.writeAsNullableSimpleString((ActiveMQBuffer)buffer, (String)this.protocolManagerFactoryStr);
        BufferHelper.writeAsNullableSimpleString((ActiveMQBuffer)buffer, (String)this.deserializationBlackList);
        BufferHelper.writeAsNullableSimpleString((ActiveMQBuffer)buffer, (String)this.deserializationWhiteList);
    }

    public int getEncodeSize() {
        int size = BufferHelper.sizeOfSimpleString((String)this.name) + BufferHelper.sizeOfNullableSimpleString((String)this.discoveryGroupName);
        size += 4;
        if (this.connectorNames != null) {
            for (String tc : this.connectorNames) {
                size += BufferHelper.sizeOfSimpleString((String)tc);
            }
        }
        return size += BufferHelper.sizeOfNullableSimpleString((String)this.clientID) + 1 + 8 + 8 + 8 + 1 + 4 + 4 + 4 + 4 + 4 + 4 + 1 + 1 + 1 + 1 + 1 + BufferHelper.sizeOfSimpleString((String)this.loadBalancingPolicyClassName) + 4 + 4 + 8 + 1 + 4 + 4 + 8 + 8 + 8 + 4 + 1 + 1 + BufferHelper.sizeOfNullableSimpleString((String)this.groupID) + 4 + BufferHelper.sizeOfNullableSimpleString((String)this.protocolManagerFactoryStr) + BufferHelper.sizeOfNullableSimpleString((String)this.deserializationBlackList) + BufferHelper.sizeOfNullableSimpleString((String)this.deserializationWhiteList);
    }

    @Override
    public ConnectionFactoryConfiguration setFactoryType(JMSFactoryType factoryType) {
        this.factoryType = factoryType;
        return this;
    }

    @Override
    public JMSFactoryType getFactoryType() {
        return this.factoryType;
    }

    @Override
    public String getDeserializationBlackList() {
        return this.deserializationBlackList;
    }

    @Override
    public void setDeserializationBlackList(String blackList) {
        this.deserializationBlackList = blackList;
    }

    @Override
    public String getDeserializationWhiteList() {
        return this.deserializationWhiteList;
    }

    @Override
    public void setDeserializationWhiteList(String whiteList) {
        this.deserializationWhiteList = whiteList;
    }

    @Override
    public ConnectionFactoryConfiguration setCompressLargeMessages(boolean compressLargeMessage) {
        this.compressLargeMessage = compressLargeMessage;
        return this;
    }

    @Override
    public boolean isCompressLargeMessages() {
        return this.compressLargeMessage;
    }

    @Override
    public ConnectionFactoryConfiguration setProtocolManagerFactoryStr(String protocolManagerFactoryStr) {
        this.protocolManagerFactoryStr = protocolManagerFactoryStr;
        return this;
    }

    @Override
    public String getProtocolManagerFactoryStr() {
        return this.protocolManagerFactoryStr;
    }

    @Override
    public int getInitialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    @Override
    public ConnectionFactoryConfiguration setInitialMessagePacketSize(int size) {
        this.initialMessagePacketSize = size;
        return this;
    }
}

