/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.SettingsUtils;

@Mojo(name="all-profiles", requiresProject=false)
public class AllProfilesMojo
extends AbstractHelpMojo {
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Parameter(defaultValue="${settings.profiles}", readonly=true, required=true)
    private List<org.apache.maven.settings.Profile> settingsProfiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StringBuilder descriptionBuffer = new StringBuilder();
        for (MavenProject project : this.projects) {
            descriptionBuffer.append("Listing Profiles for Project: ").append(project.getId()).append(LS);
            HashMap<String, Profile> allProfilesByIds = new HashMap<String, Profile>();
            HashMap<String, Profile> activeProfilesByIds = new HashMap<String, Profile>();
            this.addSettingsProfiles(allProfilesByIds);
            this.addProjectPomProfiles(project, allProfilesByIds, activeProfilesByIds);
            if (allProfilesByIds.isEmpty()) {
                this.getLog().warn((CharSequence)"No profiles detected!");
                continue;
            }
            allProfilesByIds.keySet().removeAll(activeProfilesByIds.keySet());
            this.writeProfilesDescription(descriptionBuffer, activeProfilesByIds, true);
            this.writeProfilesDescription(descriptionBuffer, allProfilesByIds, false);
        }
        if (this.output != null) {
            try {
                AllProfilesMojo.writeFile(this.output, descriptionBuffer);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write profiles description to output: " + this.output, (Exception)e);
            }
            this.getLog().info((CharSequence)("Wrote descriptions to: " + this.output));
        } else {
            this.getLog().info((CharSequence)descriptionBuffer.toString());
        }
    }

    private void writeProfilesDescription(StringBuilder sb, Map<String, Profile> profilesByIds, boolean active) {
        for (Profile p : profilesByIds.values()) {
            sb.append("  Profile Id: ").append(p.getId());
            sb.append(" (Active: " + active + " , Source: ").append(p.getSource()).append(")");
            sb.append(LS);
        }
    }

    private void addProjectPomProfiles(MavenProject project, Map<String, Profile> allProfiles, Map<String, Profile> activeProfiles) {
        if (project == null) {
            this.getLog().debug((CharSequence)"No pom.xml found to read Profiles from.");
            return;
        }
        this.getLog().debug((CharSequence)"Attempting to read profiles from pom.xml...");
        while (project != null) {
            for (Profile profile : project.getModel().getProfiles()) {
                allProfiles.put(profile.getId(), profile);
            }
            if (project.getActiveProfiles() != null) {
                for (Profile profile : project.getActiveProfiles()) {
                    activeProfiles.put(profile.getId(), profile);
                }
            }
            project = project.getParent();
        }
    }

    private void addSettingsProfiles(Map<String, Profile> allProfiles) {
        this.getLog().debug((CharSequence)"Attempting to read profiles from settings.xml...");
        for (org.apache.maven.settings.Profile settingsProfile : this.settingsProfiles) {
            Profile profile = SettingsUtils.convertFromSettingsProfile((org.apache.maven.settings.Profile)settingsProfile);
            allProfiles.put(profile.getId(), profile);
        }
    }
}

