/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.runorder;

import java.io.File;
import java.io.IOException;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.runorder.RunEntryStatisticsMap;

public class StatisticsReporter {
    private final RunEntryStatisticsMap existing;
    private final RunEntryStatisticsMap newResults;
    private final File dataFile;

    public StatisticsReporter(File dataFile) {
        this(dataFile, RunEntryStatisticsMap.fromFile((File)dataFile), new RunEntryStatisticsMap());
    }

    protected StatisticsReporter(File dataFile, RunEntryStatisticsMap existing, RunEntryStatisticsMap newResults) {
        this.dataFile = dataFile;
        this.existing = existing;
        this.newResults = newResults;
    }

    public synchronized void testSetCompleted() {
        try {
            this.newResults.serialize(this.dataFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void testSucceeded(ReportEntry report) {
        this.newResults.add(this.existing.createNextGeneration(report));
    }

    public void testSkipped(ReportEntry report) {
        this.newResults.add(this.existing.createNextGeneration(report));
    }

    public void testError(ReportEntry report) {
        this.newResults.add(this.existing.createNextGenerationFailure(report));
    }

    public void testFailed(ReportEntry report) {
        this.newResults.add(this.existing.createNextGenerationFailure(report));
    }
}

