/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.luosimao.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.luosimao.config.LuoSiMaoConfig;
import org.dromara.sms4j.luosimao.utils.LuoSiMaoUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuoSiMaoSmsImpl
extends AbstractSmsBlend<LuoSiMaoConfig> {
    private static final Logger log = LoggerFactory.getLogger(LuoSiMaoSmsImpl.class);
    private int retry = 0;

    public LuoSiMaoSmsImpl(LuoSiMaoConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public LuoSiMaoSmsImpl(LuoSiMaoConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "luosimao";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        return this.getSmsResponse(Collections.singletonList(phone), message, null, false, false);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        throw new SmsBlendException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        throw new SmsBlendException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        return this.getSmsResponse(phones, message, null, false, false);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        throw new SmsBlendException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    public SmsResponse massTextingOnTime(List<String> phones, String message, Date date) {
        return this.getSmsResponse(phones, message, date, true, false);
    }

    public SmsResponse queryAccountBalance() {
        return this.getSmsResponse(null, null, null, false, true);
    }

    private SmsResponse getSmsResponse(List<String> phones, String message, Date date, boolean batch, boolean status) {
        SmsResponse smsResponse;
        LuoSiMaoConfig config = (LuoSiMaoConfig)this.getConfig();
        try {
            String url = config.getHost() + config.getAction();
            if (status) {
                if ("status.json".equals(config.getAction())) {
                    log.error("please set the request interface method to status.json");
                    throw new SmsBlendException("please set the request interface method to status.json");
                }
                smsResponse = this.getResponse(this.http.getBasic(url, "api", "key-" + config.getAccessKeyId()));
            } else {
                if (CollUtil.isEmpty(phones)) {
                    log.error("mobile number is required");
                    throw new SmsBlendException("mobile number is required");
                }
                if (StrUtil.isBlank((CharSequence)message)) {
                    log.error("message number is required");
                    throw new SmsBlendException("message number is required");
                }
                LinkedHashMap<String, Object> body = batch ? LuoSiMaoUtils.buildBody(phones, message, date) : LuoSiMaoUtils.buildBody(phones.get(0), message);
                smsResponse = this.getResponse(this.http.postBasicFrom(url, LuoSiMaoUtils.buildHeaders(), "api", "key-" + config.getAccessKeyId(), body));
            }
            log.debug("\u77ed\u4fe1\u53d1\u9001\u7ed3\u679c\uff1a{}", (Object)smsResponse);
        }
        catch (SmsBlendException e) {
            log.error(e.message, (Throwable)e);
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry == config.getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phones, message, date, batch, status);
    }

    private SmsResponse requestRetry(List<String> phones, String message, Date date, boolean batch, boolean status) {
        this.http.safeSleep(((LuoSiMaoConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.getSmsResponse(phones, message, date, batch, status);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        return SmsRespUtils.resp((Object)resJson, (boolean)Objects.equals(0, resJson.getInt((Object)"error")), (String)this.getConfigId());
    }
}

