/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.net.DatagramPacket;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.scandium.DatagramFilter;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.Record;

public class DtlsDatagramFilter
implements DatagramFilter {
    private final long macErrorFilterQuietTimeNanos;
    private final int macErrorFilterThreshold;

    public DtlsDatagramFilter() {
        this.macErrorFilterQuietTimeNanos = 0L;
        this.macErrorFilterThreshold = 0;
    }

    public DtlsDatagramFilter(Configuration config) {
        this.macErrorFilterQuietTimeNanos = config.get(DtlsConfig.DTLS_MAC_ERROR_FILTER_QUIET_TIME, TimeUnit.NANOSECONDS);
        this.macErrorFilterThreshold = (Integer)config.get((BasicDefinition)DtlsConfig.DTLS_MAC_ERROR_FILTER_THRESHOLD);
        if (this.macErrorFilterQuietTimeNanos == 0L ^ this.macErrorFilterThreshold == 0) {
            throw new IllegalArgumentException("DTLS MAC error filter configuration ambig! Use 0 for both, or larger than 0 for both!");
        }
    }

    @Override
    public boolean onReceiving(DatagramPacket packet) {
        int offset;
        if (packet.getLength() < 13) {
            return false;
        }
        byte[] data = packet.getData();
        ContentType contentType = ContentType.getTypeByValue(data[offset = packet.getOffset()]);
        if (contentType == null) {
            return false;
        }
        if (data[offset + 3] != 0 || (data[offset + 4] & 0xFF) > 1 || data[offset + 5] != 0) {
            return false;
        }
        if (contentType == ContentType.HANDSHAKE || contentType == ContentType.ALERT) {
            return true;
        }
        int major = 0xFF & data[offset + 1];
        int minor = 0xFF & data[offset + 2];
        return major == 254 && minor == 253;
    }

    @Override
    public boolean onReceiving(Record record, Connection connection) {
        Object filterData;
        if (this.macErrorFilterThreshold > 0 && (filterData = connection.getFilterData()) instanceof MacErrorFilter) {
            return !((MacErrorFilter)filterData).dropRecords(this.macErrorFilterThreshold, record.getReceiveNanos(), this.macErrorFilterQuietTimeNanos);
        }
        return true;
    }

    @Override
    public boolean onMacError(Record record, Connection connection) {
        if (this.macErrorFilterThreshold > 0) {
            Object filterData = connection.getFilterData();
            if (filterData == null) {
                filterData = new MacErrorFilter(record.getReceiveNanos());
                connection.setFilterData(filterData);
            }
            if (filterData instanceof MacErrorFilter) {
                ((MacErrorFilter)filterData).incrementMacErrors(record.getReceiveNanos(), this.macErrorFilterQuietTimeNanos);
            }
        }
        return false;
    }

    private static class MacErrorFilter {
        private long currentMacErrors = 0L;
        private long lastMacErrorsNanoTimestamp = 0L;

        private MacErrorFilter(long now) {
            this.lastMacErrorsNanoTimestamp = now;
        }

        private void incrementMacErrors(long now, long quietTimeNanos) {
            this.resetMacErrorFilter(now, quietTimeNanos);
            ++this.currentMacErrors;
        }

        private boolean dropRecords(int macErrorThreshold, long now, long quietTimeNanos) {
            this.resetMacErrorFilter(now, quietTimeNanos);
            return this.currentMacErrors > (long)macErrorThreshold;
        }

        private void resetMacErrorFilter(long now, long quietTimeNanos) {
            if (now - this.lastMacErrorsNanoTimestamp > quietTimeNanos) {
                this.currentMacErrors = 0L;
            }
            this.lastMacErrorsNanoTimestamp = now;
        }
    }
}

