/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.leshan.client.EndpointsManager;
import org.eclipse.leshan.client.LwM2mClient;
import org.eclipse.leshan.client.RegistrationUpdateHandler;
import org.eclipse.leshan.client.bootstrap.BootstrapHandler;
import org.eclipse.leshan.client.californium.CaliforniumEndpointsManager;
import org.eclipse.leshan.client.californium.RootResource;
import org.eclipse.leshan.client.californium.bootstrap.BootstrapResource;
import org.eclipse.leshan.client.californium.object.ObjectResource;
import org.eclipse.leshan.client.californium.request.CaliforniumLwM2mRequestSender;
import org.eclipse.leshan.client.engine.RegistrationEngine;
import org.eclipse.leshan.client.engine.RegistrationEngineFactory;
import org.eclipse.leshan.client.engine.RegistrationEngineFactory2;
import org.eclipse.leshan.client.observer.LwM2mClientObserver;
import org.eclipse.leshan.client.observer.LwM2mClientObserverAdapter;
import org.eclipse.leshan.client.observer.LwM2mClientObserverDispatcher;
import org.eclipse.leshan.client.request.LwM2mRequestSender;
import org.eclipse.leshan.client.resource.LwM2mObjectEnabler;
import org.eclipse.leshan.client.resource.LwM2mObjectTree;
import org.eclipse.leshan.client.resource.listener.ObjectListener;
import org.eclipse.leshan.client.resource.listener.ObjectsListener;
import org.eclipse.leshan.client.resource.listener.ObjectsListenerAdapter;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.node.codec.LwM2mNodeDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mNodeEncoder;
import org.eclipse.leshan.core.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshanClient
implements LwM2mClient {
    private static final Logger LOG = LoggerFactory.getLogger(LeshanClient.class);
    private final CoapAPI coapApi;
    private final CoapServer coapServer;
    private final CaliforniumLwM2mRequestSender requestSender;
    private final CaliforniumEndpointsManager endpointsManager;
    private LwM2mObjectTree objectTree;
    private final BootstrapHandler bootstrapHandler;
    private final RegistrationEngine engine;
    private final LwM2mClientObserverDispatcher observers;

    public LeshanClient(String endpoint, InetSocketAddress localAddress, List<? extends LwM2mObjectEnabler> objectEnablers, NetworkConfig coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, EndpointFactory endpointFactory, RegistrationEngineFactory engineFactory, Map<String, String> additionalAttributes, LwM2mNodeEncoder encoder, LwM2mNodeDecoder decoder, ScheduledExecutorService sharedExecutor) {
        this(endpoint, localAddress, objectEnablers, coapConfig, dtlsConfigBuilder, endpointFactory, engineFactory, additionalAttributes, null, encoder, decoder, sharedExecutor);
    }

    public LeshanClient(String endpoint, InetSocketAddress localAddress, List<? extends LwM2mObjectEnabler> objectEnablers, NetworkConfig coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, EndpointFactory endpointFactory, RegistrationEngineFactory engineFactory, Map<String, String> additionalAttributes, Map<String, String> bsAdditionalAttributes, LwM2mNodeEncoder encoder, LwM2mNodeDecoder decoder, ScheduledExecutorService sharedExecutor) {
        Validate.notNull((Object)endpoint);
        Validate.notEmpty(objectEnablers);
        Validate.notNull((Object)coapConfig);
        this.objectTree = this.createObjectTree(objectEnablers);
        this.observers = this.createClientObserverDispatcher();
        this.bootstrapHandler = this.createBoostrapHandler(this.objectTree);
        this.endpointsManager = this.createEndpointsManager(localAddress, coapConfig, dtlsConfigBuilder, endpointFactory);
        this.requestSender = this.createRequestSender(this.endpointsManager, sharedExecutor);
        this.engine = engineFactory instanceof RegistrationEngineFactory2 ? ((RegistrationEngineFactory2)engineFactory).createRegistratioEngine(endpoint, this.objectTree, (EndpointsManager)this.endpointsManager, (LwM2mRequestSender)this.requestSender, this.bootstrapHandler, (LwM2mClientObserver)this.observers, additionalAttributes, bsAdditionalAttributes, sharedExecutor) : engineFactory.createRegistratioEngine(endpoint, this.objectTree, (EndpointsManager)this.endpointsManager, (LwM2mRequestSender)this.requestSender, this.bootstrapHandler, (LwM2mClientObserver)this.observers, additionalAttributes, sharedExecutor);
        this.coapServer = this.createCoapServer(coapConfig, sharedExecutor);
        this.coapServer.add(new Resource[]{this.createBootstrapResource(this.engine, this.bootstrapHandler)});
        this.endpointsManager.setCoapServer(this.coapServer);
        this.linkObjectTreeToCoapServer(this.coapServer, this.engine, this.objectTree, encoder, decoder);
        this.createRegistrationUpdateHandler(this.engine, this.endpointsManager, this.bootstrapHandler, this.objectTree);
        this.coapApi = new CoapAPI();
    }

    protected LwM2mObjectTree createObjectTree(List<? extends LwM2mObjectEnabler> objectEnablers) {
        return new LwM2mObjectTree((LwM2mClient)this, objectEnablers);
    }

    protected LwM2mClientObserverDispatcher createClientObserverDispatcher() {
        LwM2mClientObserverDispatcher observer = new LwM2mClientObserverDispatcher();
        observer.addObserver((LwM2mClientObserver)new LwM2mClientObserverAdapter(){

            public void onUnexpectedError(Throwable unexpectedError) {
                LeshanClient.this.destroy(false);
            }
        });
        return observer;
    }

    protected BootstrapHandler createBoostrapHandler(LwM2mObjectTree objectTree) {
        return new BootstrapHandler(objectTree.getObjectEnablers());
    }

    protected CoapServer createCoapServer(NetworkConfig coapConfig, ScheduledExecutorService sharedExecutor) {
        CoapServer coapServer = new CoapServer(coapConfig, new int[0]){

            protected Resource createRoot() {
                return new RootResource(LeshanClient.this.engine, LeshanClient.this.bootstrapHandler, this);
            }
        };
        if (sharedExecutor != null) {
            coapServer.setExecutors(sharedExecutor, sharedExecutor, true);
        } else {
            ScheduledExecutorService executor = ExecutorsUtil.newScheduledThreadPool((int)coapConfig.getInt("PROTOCOL_STAGE_THREAD_COUNT"), (ThreadFactory)new NamedThreadFactory("CoapServer(main)#"));
            coapServer.setExecutors(executor, executor, false);
        }
        return coapServer;
    }

    protected void linkObjectTreeToCoapServer(final CoapServer coapServer, final RegistrationEngine registrationEngine, LwM2mObjectTree objectTree, final LwM2mNodeEncoder encoder, final LwM2mNodeDecoder decoder) {
        for (LwM2mObjectEnabler enabler : objectTree.getObjectEnablers().values()) {
            CoapResource clientObject = this.createObjectResource(enabler, registrationEngine, encoder, decoder);
            coapServer.add(new Resource[]{clientObject});
        }
        objectTree.addListener((ObjectsListener)new ObjectsListenerAdapter(){

            public void objectAdded(LwM2mObjectEnabler object) {
                CoapResource clientObject = LeshanClient.this.createObjectResource(object, registrationEngine, encoder, decoder);
                coapServer.add(new Resource[]{clientObject});
            }

            public void objectRemoved(LwM2mObjectEnabler object) {
                Resource resource = coapServer.getRoot().getChild(Integer.toString(object.getId()));
                if (resource instanceof ObjectListener) {
                    object.removeListener((ObjectListener)resource);
                }
                coapServer.remove(resource);
            }
        });
    }

    protected CoapResource createObjectResource(LwM2mObjectEnabler enabler, RegistrationEngine registrationEngine, LwM2mNodeEncoder encoder, LwM2mNodeDecoder decoder) {
        return new ObjectResource(enabler, registrationEngine, encoder, decoder);
    }

    protected CoapResource createBootstrapResource(RegistrationEngine engine, BootstrapHandler bootstrapHandler) {
        return new BootstrapResource(engine, bootstrapHandler);
    }

    protected CaliforniumEndpointsManager createEndpointsManager(InetSocketAddress localAddress, NetworkConfig coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, EndpointFactory endpointFactory) {
        return new CaliforniumEndpointsManager(localAddress, coapConfig, dtlsConfigBuilder, endpointFactory);
    }

    protected CaliforniumLwM2mRequestSender createRequestSender(CaliforniumEndpointsManager endpointsManager, ScheduledExecutorService executor) {
        return new CaliforniumLwM2mRequestSender(endpointsManager, executor);
    }

    protected RegistrationUpdateHandler createRegistrationUpdateHandler(RegistrationEngine engine, CaliforniumEndpointsManager endpointsManager, BootstrapHandler bootstrapHandler, LwM2mObjectTree objectTree) {
        RegistrationUpdateHandler registrationUpdateHandler = new RegistrationUpdateHandler(engine, bootstrapHandler);
        registrationUpdateHandler.listen(objectTree);
        return registrationUpdateHandler;
    }

    public void start() {
        LOG.info("Starting Leshan client ...");
        this.endpointsManager.start();
        this.engine.start();
        this.objectTree.start();
        if (LOG.isInfoEnabled()) {
            LOG.info("Leshan client[endpoint:{}] started.", (Object)this.engine.getEndpoint());
        }
    }

    public void stop(boolean deregister) {
        LOG.info("Stopping Leshan Client ...");
        this.engine.stop(deregister);
        this.endpointsManager.stop();
        this.objectTree.stop();
        LOG.info("Leshan client stopped.");
    }

    public void destroy(boolean deregister) {
        LOG.info("Destroying Leshan client ...");
        this.engine.destroy(deregister);
        this.endpointsManager.destroy();
        this.requestSender.destroy();
        this.objectTree.destroy();
        LOG.info("Leshan client destroyed.");
    }

    public LwM2mObjectTree getObjectTree() {
        return this.objectTree;
    }

    public void triggerRegistrationUpdate() {
        this.engine.triggerRegistrationUpdate();
    }

    public void triggerRegistrationUpdate(ServerIdentity server) {
        this.engine.triggerRegistrationUpdate(server);
    }

    public CoapAPI coap() {
        return this.coapApi;
    }

    public void addObserver(LwM2mClientObserver observer) {
        this.observers.addObserver(observer);
    }

    public void removeObserver(LwM2mClientObserver observer) {
        this.observers.removeObserver(observer);
    }

    public String getRegistrationId(ServerIdentity server) {
        return this.engine.getRegistrationId(server);
    }

    public Map<String, ServerIdentity> getRegisteredServers() {
        return this.engine.getRegisteredServers();
    }

    public InetSocketAddress getAddress(ServerIdentity server) {
        return this.endpointsManager.getEndpoint(server).getAddress();
    }

    public class CoapAPI {
        public CoapServer getServer() {
            return LeshanClient.this.coapServer;
        }

        public CoapEndpoint getEndpoint(ServerIdentity server) {
            return (CoapEndpoint)LeshanClient.this.endpointsManager.getEndpoint(server);
        }
    }
}

