/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.eclipse.leshan.core.californium.DefaultEndpointFactory;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.californium.oscore.cf.InMemoryOscoreContextDB;
import org.eclipse.leshan.core.californium.oscore.cf.OscoreStore;
import org.eclipse.leshan.core.link.lwm2m.DefaultLwM2mLinkParser;
import org.eclipse.leshan.core.link.lwm2m.LwM2mLinkParser;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mDecoder;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.server.bootstrap.BootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.BootstrapConfigStoreTaskProvider;
import org.eclipse.leshan.server.bootstrap.BootstrapHandler;
import org.eclipse.leshan.server.bootstrap.BootstrapHandlerFactory;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionListener;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionManager;
import org.eclipse.leshan.server.bootstrap.BootstrapTaskProvider;
import org.eclipse.leshan.server.bootstrap.DefaultBootstrapAuthorizer;
import org.eclipse.leshan.server.bootstrap.DefaultBootstrapHandler;
import org.eclipse.leshan.server.bootstrap.DefaultBootstrapSessionManager;
import org.eclipse.leshan.server.bootstrap.InMemoryBootstrapConfigStore;
import org.eclipse.leshan.server.bootstrap.LwM2mBootstrapRequestSender;
import org.eclipse.leshan.server.californium.bootstrap.BootstrapOscoreContextCleaner;
import org.eclipse.leshan.server.californium.bootstrap.LeshanBootstrapServer;
import org.eclipse.leshan.server.californium.bootstrap.LwM2mBootstrapOscoreStore;
import org.eclipse.leshan.server.californium.bootstrap.LwM2mBootstrapPskStore;
import org.eclipse.leshan.server.californium.bootstrap.OscoreBootstrapListener;
import org.eclipse.leshan.server.model.LwM2mBootstrapModelProvider;
import org.eclipse.leshan.server.model.StandardBootstrapModelProvider;
import org.eclipse.leshan.server.security.BootstrapAuthorizer;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.eclipse.leshan.server.security.SecurityChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshanBootstrapServerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LeshanBootstrapServerBuilder.class);
    private InetSocketAddress localAddress;
    private InetSocketAddress localAddressSecure;
    private BootstrapConfigStore configStore;
    private BootstrapSecurityStore securityStore;
    private BootstrapSessionManager sessionManager;
    private BootstrapHandlerFactory bootstrapHandlerFactory;
    private LwM2mBootstrapModelProvider modelProvider;
    private Configuration coapConfig;
    private DtlsConnectorConfig.Builder dtlsConfigBuilder;
    private LwM2mEncoder encoder;
    private LwM2mDecoder decoder;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private X509Certificate[] certificateChain;
    private Certificate[] trustedCertificates;
    private EndpointFactory endpointFactory;
    private boolean noSecuredEndpoint;
    private boolean noUnsecuredEndpoint;
    private LwM2mLinkParser linkParser;
    private boolean enableOscore = false;
    private BootstrapAuthorizer authorizer;

    public LeshanBootstrapServerBuilder setLocalAddress(String hostname, int port) {
        this.localAddress = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanBootstrapServerBuilder setLocalAddress(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public LeshanBootstrapServerBuilder setLocalSecureAddress(String hostname, int port) {
        this.localAddressSecure = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanBootstrapServerBuilder setLocalSecureAddress(InetSocketAddress localSecureAddress) {
        this.localAddressSecure = localSecureAddress;
        return this;
    }

    public LeshanBootstrapServerBuilder setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public <T extends X509Certificate> LeshanBootstrapServerBuilder setCertificateChain(T[] certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public LeshanBootstrapServerBuilder setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public <T extends Certificate> LeshanBootstrapServerBuilder setTrustedCertificates(T[] trustedCertificates) {
        this.trustedCertificates = trustedCertificates;
        return this;
    }

    public LeshanBootstrapServerBuilder setConfigStore(BootstrapConfigStore configStore) {
        this.configStore = configStore;
        return this;
    }

    public LeshanBootstrapServerBuilder setSecurityStore(BootstrapSecurityStore securityStore) {
        this.securityStore = securityStore;
        return this;
    }

    public LeshanBootstrapServerBuilder setSessionManager(BootstrapSessionManager sessionManager) {
        this.sessionManager = sessionManager;
        return this;
    }

    public LeshanBootstrapServerBuilder setBootstrapHandlerFactory(BootstrapHandlerFactory bootstrapHandlerFactory) {
        this.bootstrapHandlerFactory = bootstrapHandlerFactory;
        return this;
    }

    public LeshanBootstrapServerBuilder setObjectModelProvider(LwM2mBootstrapModelProvider objectModelProvider) {
        this.modelProvider = objectModelProvider;
        return this;
    }

    public LeshanBootstrapServerBuilder setEncoder(LwM2mEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public LeshanBootstrapServerBuilder setDecoder(LwM2mDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public LeshanBootstrapServerBuilder setCoapConfig(Configuration coapConfig) {
        this.coapConfig = coapConfig;
        return this;
    }

    public LeshanBootstrapServerBuilder setDtlsConfig(DtlsConnectorConfig.Builder dtlsConfig) {
        this.dtlsConfigBuilder = dtlsConfig;
        return this;
    }

    public LeshanBootstrapServerBuilder setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public void setLinkParser(LwM2mLinkParser linkParser) {
        this.linkParser = linkParser;
    }

    public LeshanBootstrapServerBuilder disableUnsecuredEndpoint() {
        this.noUnsecuredEndpoint = true;
        return this;
    }

    public LeshanBootstrapServerBuilder disableSecuredEndpoint() {
        this.noSecuredEndpoint = true;
        return this;
    }

    public LeshanBootstrapServerBuilder setEnableOscore(boolean enableOscore) {
        this.enableOscore = enableOscore;
        return this;
    }

    public LeshanBootstrapServerBuilder setAuthorizer(BootstrapAuthorizer authorizer) {
        this.authorizer = authorizer;
        return this;
    }

    public static Configuration createDefaultCoapConfiguration() {
        Configuration networkConfig = new Configuration(new Configuration.ModuleDefinitionsProvider[]{CoapConfig.DEFINITIONS, DtlsConfig.DEFINITIONS, UdpConfig.DEFINITIONS, SystemConfig.DEFINITIONS});
        networkConfig.set((BasicDefinition)CoapConfig.MID_TRACKER, (Object)CoapConfig.TrackerMode.NULL);
        networkConfig.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.SERVER_ONLY);
        return networkConfig;
    }

    public LeshanBootstrapServer build() {
        if (this.localAddress == null) {
            this.localAddress = new InetSocketAddress(5683);
        }
        if (this.bootstrapHandlerFactory == null) {
            this.bootstrapHandlerFactory = new BootstrapHandlerFactory(){

                public BootstrapHandler create(LwM2mBootstrapRequestSender sender, BootstrapSessionManager sessionManager, BootstrapSessionListener listener) {
                    return new DefaultBootstrapHandler(sender, sessionManager, listener);
                }
            };
        }
        if (this.configStore == null) {
            this.configStore = new InMemoryBootstrapConfigStore();
        } else if (this.sessionManager != null) {
            LOG.warn("configStore is set but you also provide a custom SessionManager so this store will not be used");
        }
        if (this.modelProvider == null) {
            this.modelProvider = new StandardBootstrapModelProvider();
        } else if (this.sessionManager != null) {
            LOG.warn("modelProvider is set but you also provide a custom SessionManager so this provider will not be used");
        }
        if (this.sessionManager == null) {
            SecurityChecker securityChecker = new SecurityChecker();
            if (this.authorizer == null) {
                this.authorizer = new DefaultBootstrapAuthorizer(this.securityStore, securityChecker);
            }
            this.sessionManager = new DefaultBootstrapSessionManager((BootstrapTaskProvider)new BootstrapConfigStoreTaskProvider(this.configStore), this.modelProvider, this.authorizer);
        }
        if (this.coapConfig == null) {
            this.coapConfig = LeshanBootstrapServerBuilder.createDefaultCoapConfiguration();
        }
        if (this.endpointFactory == null) {
            this.endpointFactory = new DefaultEndpointFactory("LWM2M BS Server", false);
        }
        if (this.encoder == null) {
            this.encoder = new DefaultLwM2mEncoder();
        }
        if (this.decoder == null) {
            this.decoder = new DefaultLwM2mDecoder();
        }
        if (this.linkParser == null) {
            this.linkParser = new DefaultLwM2mLinkParser();
        }
        DtlsConnectorConfig dtlsConfig = null;
        if (!this.noSecuredEndpoint && this.shouldTryToCreateSecureEndpoint()) {
            List ciphers;
            DtlsConnectorConfig incompleteConfig;
            if (this.dtlsConfigBuilder == null) {
                this.dtlsConfigBuilder = DtlsConnectorConfig.builder((Configuration)this.coapConfig);
            }
            if ((incompleteConfig = this.dtlsConfigBuilder.getIncompleteConfig()).getAdvancedPskStore() != null) {
                LOG.warn("PskStore should be automatically set by Leshan. Using a custom implementation is not advised.");
            } else if (this.securityStore != null && ((ciphers = (List)incompleteConfig.getConfiguration().get((BasicDefinition)DtlsConfig.DTLS_CIPHER_SUITES)) == null || CipherSuite.containsPskBasedCipherSuite((List)ciphers))) {
                this.dtlsConfigBuilder.setAdvancedPskStore((AdvancedPskStore)new LwM2mBootstrapPskStore(this.securityStore));
            }
            if (incompleteConfig.getAddress() == null) {
                if (this.localAddressSecure == null) {
                    this.localAddressSecure = new InetSocketAddress(5684);
                }
                this.dtlsConfigBuilder.setAddress(this.localAddressSecure);
            } else if (this.localAddressSecure != null && !this.localAddressSecure.equals(incompleteConfig.getAddress())) {
                throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for secure address: %s != %s", this.localAddressSecure, incompleteConfig.getAddress()));
            }
            if (incompleteConfig.getCertificateIdentityProvider() != null) {
                if (this.privateKey != null) {
                    throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for private key", new Object[0]));
                }
                if (this.publicKey != null) {
                    throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for public key", new Object[0]));
                }
                if (this.certificateChain != null) {
                    throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for certificate chain", new Object[0]));
                }
            } else if (this.privateKey != null) {
                if (this.certificateChain == null && this.publicKey != null) {
                    this.dtlsConfigBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(this.privateKey, this.publicKey));
                }
                if (this.certificateChain != null && this.certificateChain.length > 0) {
                    this.dtlsConfigBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(this.privateKey, (Certificate[])this.certificateChain, new CertificateType[]{CertificateType.X_509, CertificateType.RAW_PUBLIC_KEY}));
                }
            }
            if (incompleteConfig.getAdvancedCertificateVerifier() != null) {
                if (this.trustedCertificates != null) {
                    throw new IllegalStateException("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder: if a AdvancedCertificateVerifier is set, trustedCertificates must not be set.");
                }
            } else if (incompleteConfig.getCertificateIdentityProvider() != null) {
                StaticNewAdvancedCertificateVerifier.Builder verifierBuilder = StaticNewAdvancedCertificateVerifier.builder();
                verifierBuilder.setTrustAllRPKs();
                if (this.trustedCertificates != null) {
                    verifierBuilder.setTrustedCertificates(this.trustedCertificates);
                }
                this.dtlsConfigBuilder.setAdvancedCertificateVerifier(verifierBuilder.build());
            }
            try {
                dtlsConfig = this.dtlsConfigBuilder.build();
            }
            catch (IllegalStateException e) {
                LOG.warn("Unable to create DTLS config and so secured endpoint.", (Throwable)e);
            }
        }
        InMemoryOscoreContextDB oscoreCtxDB = null;
        OscoreBootstrapListener sessionHolder = null;
        BootstrapOscoreContextCleaner oscoreContextCleaner = null;
        if (this.enableOscore && this.securityStore != null) {
            sessionHolder = new OscoreBootstrapListener();
            oscoreCtxDB = new InMemoryOscoreContextDB((OscoreStore)new LwM2mBootstrapOscoreStore(this.securityStore, sessionHolder));
            oscoreContextCleaner = new BootstrapOscoreContextCleaner((OSCoreCtxDB)oscoreCtxDB);
            LOG.warn("Experimental OSCORE feature is enabled.");
        }
        CoapEndpoint unsecuredEndpoint = null;
        if (!this.noUnsecuredEndpoint) {
            unsecuredEndpoint = this.endpointFactory.createUnsecuredEndpoint(this.localAddress, this.coapConfig, null, oscoreCtxDB);
        }
        CoapEndpoint securedEndpoint = null;
        if (!this.noSecuredEndpoint && dtlsConfig != null) {
            securedEndpoint = this.endpointFactory.createSecuredEndpoint(dtlsConfig, this.coapConfig, null, null);
        }
        if (securedEndpoint == null && unsecuredEndpoint == null) {
            throw new IllegalStateException("All CoAP enpoints are deactivated, at least one endpoint should be activated");
        }
        LeshanBootstrapServer bootstrapServer = this.createBootstrapServer(unsecuredEndpoint, securedEndpoint, this.sessionManager, this.bootstrapHandlerFactory, this.coapConfig, this.encoder, this.decoder, this.linkParser);
        if (sessionHolder != null) {
            bootstrapServer.addListener((BootstrapSessionListener)sessionHolder);
        }
        if (oscoreContextCleaner != null) {
            bootstrapServer.addListener((BootstrapSessionListener)oscoreContextCleaner);
        }
        return bootstrapServer;
    }

    protected boolean shouldTryToCreateSecureEndpoint() {
        return this.dtlsConfigBuilder != null || this.certificateChain != null || this.privateKey != null || this.publicKey != null || this.securityStore != null || this.trustedCertificates != null;
    }

    protected LeshanBootstrapServer createBootstrapServer(CoapEndpoint unsecuredEndpoint, CoapEndpoint securedEndpoint, BootstrapSessionManager bsSessionManager, BootstrapHandlerFactory bsHandlerFactory, Configuration coapConfig, LwM2mEncoder encoder, LwM2mDecoder decoder, LwM2mLinkParser linkParser) {
        return new LeshanBootstrapServer(unsecuredEndpoint, securedEndpoint, bsSessionManager, bsHandlerFactory, coapConfig, encoder, decoder, linkParser);
    }
}

