/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import java.net.InetSocketAddress;
import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.eclipse.leshan.server.security.BootstrapSecurityStore;
import org.eclipse.leshan.server.security.SecurityInfo;

public class LwM2mBootstrapPskStore
implements AdvancedPskStore {
    private BootstrapSecurityStore bsSecurityStore;

    public LwM2mBootstrapPskStore(BootstrapSecurityStore bsSecurityStore) {
        this.bsSecurityStore = bsSecurityStore;
    }

    public boolean hasEcdhePskSupported() {
        return true;
    }

    public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        SecurityInfo info = this.bsSecurityStore.getByIdentity(identity.getPublicInfoAsString());
        if (info == null || info.getPreSharedKey() == null) {
            return new PskSecretResult(cid, identity, null);
        }
        return new PskSecretResult(cid, identity, SecretUtil.create((byte[])info.getPreSharedKey(), (String)"PSK"));
    }

    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        throw new UnsupportedOperationException("Getting PSK Id by IP addresss dos not make sense on BS server side.");
    }
}

