/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.LimitOffsetQueryRewriter;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

public class MysqlQueryRewriter
extends LimitOffsetQueryRewriter {
    public MysqlQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public String escapeQuotes(String filterItemOperand) {
        return filterItemOperand.replaceAll("\\'", "\\\\'");
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.NUMERIC) {
            return super.rewriteColumnType(ColumnType.DECIMAL, columnSize);
        }
        if (columnType.isLiteral() && columnSize == null && (columnType == ColumnType.STRING || columnType == ColumnType.VARCHAR || columnType == ColumnType.NVARCHAR)) {
            return "TEXT";
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    @Override
    protected String rewriteFromItem(Query query, FromItem item) {
        String result = super.rewriteFromItem(query, item);
        result = this.rewriteSchema(item, result);
        return result;
    }

    private String rewriteSchema(FromItem item, String result) {
        Table table = item.getTable();
        if (table == null) {
            String schemaName;
            Schema schema;
            FromItem leftSideItem = item.getLeftSide();
            table = leftSideItem.getTable();
            if (table != null && (schema = table.getSchema()) != null && (schemaName = schema.getName()) != null && !schemaName.isEmpty()) {
                result = result.replaceFirst(schemaName, '`' + schema.getName() + '`');
            }
        } else {
            String schemaName;
            Schema schema = table.getSchema();
            if (schema != null && (schemaName = schema.getName()) != null && !schemaName.isEmpty()) {
                result = result.replaceFirst(schemaName, '`' + schema.getName() + '`');
            }
        }
        return result;
    }
}

