/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.auth;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.wire.auth.AuthenticationPlugin;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.auth.UnixCrypt;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class LegacyAuthenticationPlugin
implements AuthenticationPlugin {
    private static final Logger log = LoggerFactory.getLogger(LegacyAuthenticationPlugin.class);
    public static final String LEGACY_AUTH_NAME = "Legacy_Auth";
    public static final String LEGACY_PASSWORD_SALT = "9z";
    private byte[] clientData;
    private boolean hasServerData;

    @Override
    public String getName() {
        return LEGACY_AUTH_NAME;
    }

    @Override
    public AuthenticationPlugin.AuthStatus authenticate(ClientAuthBlock clientAuthBlock) throws SQLException {
        if (clientAuthBlock.getLogin() == null || clientAuthBlock.getPassword() == null) {
            return AuthenticationPlugin.AuthStatus.AUTH_CONTINUE;
        }
        this.clientData = UnixCrypt.crypt(clientAuthBlock.getPassword(), LEGACY_PASSWORD_SALT).substring(2, 13).getBytes(StandardCharsets.US_ASCII);
        return AuthenticationPlugin.AuthStatus.AUTH_SUCCESS;
    }

    @Override
    public byte[] getClientData() {
        return this.clientData;
    }

    @Override
    public void setServerData(byte[] serverData) {
        log.debug("Ignoring server data, plugin doesn't use it");
        this.hasServerData = serverData != null && serverData.length > 0;
    }

    @Override
    public boolean hasServerData() {
        return this.hasServerData;
    }

    @Override
    public boolean generatesSessionKey() {
        return false;
    }

    @Override
    public byte[] getSessionKey() throws SQLException {
        throw new SQLException("LegacyAuthenticationPlugin cannot generate a session key");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : " + this.getName();
    }
}

