/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jdkspecific;

import sun.reflect.Reflection;

public class CallerId {
    private static final boolean hasGetCallerClass;
    private static final int callerOffset;
    private static final LocalSecurityManager SECURITY_MANAGER;

    public static Class<?> getCallerClass(int n) {
        if (hasGetCallerClass) {
            return Reflection.getCallerClass((int)(n + callerOffset));
        }
        return SECURITY_MANAGER.getClasses()[n + callerOffset];
    }

    static {
        boolean result = false;
        int offset = 1;
        try {
            result = Reflection.getCallerClass((int)1) == CallerId.class || Reflection.getCallerClass((int)2) == CallerId.class;
            offset = Reflection.getCallerClass((int)1) == Reflection.class ? 2 : 1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hasGetCallerClass = result;
        callerOffset = offset;
        SECURITY_MANAGER = !hasGetCallerClass ? new LocalSecurityManager() : null;
    }

    private static class LocalSecurityManager
    extends SecurityManager {
        private LocalSecurityManager() {
        }

        public Class<?>[] getClasses() {
            return this.getClassContext();
        }
    }
}

