/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import org.jboss.marshalling._private.GetReflectionFactoryAction;
import org.jboss.marshalling._private.SetAccessibleAction;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import sun.reflect.ReflectionFactory;

final class JDKSpecific {
    static final SerializableClassRegistry REGISTRY = SerializableClassRegistry.getInstanceUnchecked();
    private static final ReflectionFactory reflectionFactory = AccessController.doPrivileged(GetReflectionFactoryAction.INSTANCE);

    private JDKSpecific() {
    }

    static Constructor<?> newConstructorForSerialization(Class<?> classToInstantiate, Constructor<?> constructorToCall) {
        Constructor<?> serCtor = reflectionFactory.newConstructorForSerialization(classToInstantiate, constructorToCall);
        if (!serCtor.isAccessible()) {
            AccessController.doPrivileged(new SetAccessibleAction(serCtor));
        }
        return serCtor;
    }

    static final class SerMethods {
        private final Method readObject;
        private final Method readObjectNoData;
        private final Method writeObject;
        private final Method readResolve;
        private final Method writeReplace;
        private final Constructor<?> noArgConstructor;
        private final Constructor<?> objectInputConstructor;

        SerMethods(Class<?> clazz) {
            Class<?> superclass;
            Method writeObject = null;
            Method readObject = null;
            Method readObjectNoData = null;
            Method writeReplace = null;
            Method readResolve = null;
            for (Method method : clazz.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                int modifiers = method.getModifiers();
                String methodName = method.getName();
                Class<?> methodReturnType = method.getReturnType();
                if (Modifier.isStatic(modifiers)) continue;
                if (Modifier.isPrivate(modifiers) && methodReturnType == Void.TYPE) {
                    if (methodName.equals("writeObject")) {
                        parameterTypes = method.getParameterTypes();
                        if (parameterTypes.length != 1 || parameterTypes[0] != ObjectOutputStream.class) continue;
                        writeObject = method;
                        writeObject.setAccessible(true);
                        continue;
                    }
                    if (methodName.equals("readObject")) {
                        parameterTypes = method.getParameterTypes();
                        if (parameterTypes.length != 1 || parameterTypes[0] != ObjectInputStream.class) continue;
                        readObject = method;
                        readObject.setAccessible(true);
                        continue;
                    }
                    if (!methodName.equals("readObjectNoData") || (parameterTypes = method.getParameterTypes()).length != 0) continue;
                    readObjectNoData = method;
                    readObjectNoData.setAccessible(true);
                    continue;
                }
                if (methodReturnType != Object.class) continue;
                if (methodName.equals("writeReplace")) {
                    parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 0) continue;
                    writeReplace = method;
                    writeReplace.setAccessible(true);
                    continue;
                }
                if (!methodName.equals("readResolve") || (parameterTypes = method.getParameterTypes()).length != 0) continue;
                readResolve = method;
                readResolve.setAccessible(true);
            }
            if ((readResolve == null || writeReplace == null) && (superclass = clazz.getSuperclass()) != null) {
                SerializableClass superInfo = REGISTRY.lookup(superclass);
                Method otherReadResolve = superInfo.getSerMethods().readResolve;
                if (readResolve == null && otherReadResolve != null && !Modifier.isPrivate(otherReadResolve.getModifiers())) {
                    readResolve = otherReadResolve;
                }
                Method otherWriteReplace = superInfo.getSerMethods().writeReplace;
                if (writeReplace == null && otherWriteReplace != null && !Modifier.isPrivate(otherWriteReplace.getModifiers())) {
                    writeReplace = otherWriteReplace;
                }
            }
            this.readObject = readObject;
            this.readObjectNoData = readObjectNoData;
            this.writeObject = writeObject;
            this.readResolve = readResolve;
            this.writeReplace = writeReplace;
            Constructor<?> noArgConstructor = null;
            Constructor<?> objectInputConstructor = null;
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length == 0) {
                    noArgConstructor = constructor;
                    noArgConstructor.setAccessible(true);
                    continue;
                }
                if (parameterTypes.length != 1 || parameterTypes[0] != ObjectInput.class) continue;
                objectInputConstructor = constructor;
                objectInputConstructor.setAccessible(true);
            }
            this.noArgConstructor = noArgConstructor;
            this.objectInputConstructor = objectInputConstructor;
        }

        boolean hasWriteObject() {
            return this.writeObject != null;
        }

        void callWriteObject(Object object, ObjectOutputStream outputStream) throws IOException {
            try {
                this.writeObject.invoke(object, outputStream);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof IOException) {
                    throw (IOException)te;
                }
                if (te instanceof RuntimeException) {
                    throw (RuntimeException)te;
                }
                if (te instanceof Error) {
                    throw (Error)te;
                }
                throw new IllegalStateException("Unexpected exception", te);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Method is unexpectedly inaccessible");
            }
        }

        boolean hasReadObject() {
            return this.readObject != null;
        }

        void callReadObject(Object object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            try {
                this.readObject.invoke(object, inputStream);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof IOException) {
                    throw (IOException)te;
                }
                if (te instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)te;
                }
                if (te instanceof RuntimeException) {
                    throw (RuntimeException)te;
                }
                if (te instanceof Error) {
                    throw (Error)te;
                }
                throw new IllegalStateException("Unexpected exception", te);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Method is unexpectedly inaccessible");
            }
        }

        boolean hasReadObjectNoData() {
            return this.readObjectNoData != null;
        }

        void callReadObjectNoData(Object object) throws ObjectStreamException {
            try {
                this.readObjectNoData.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof ObjectStreamException) {
                    throw (ObjectStreamException)te;
                }
                if (te instanceof RuntimeException) {
                    throw (RuntimeException)te;
                }
                if (te instanceof Error) {
                    throw (Error)te;
                }
                throw new IllegalStateException("Unexpected exception", te);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Method is unexpectedly inaccessible");
            }
        }

        boolean hasWriteReplace() {
            return this.writeReplace != null;
        }

        Object callWriteReplace(Object object) throws ObjectStreamException {
            try {
                return this.writeReplace.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof ObjectStreamException) {
                    throw (ObjectStreamException)te;
                }
                if (te instanceof RuntimeException) {
                    throw (RuntimeException)te;
                }
                if (te instanceof Error) {
                    throw (Error)te;
                }
                throw new IllegalStateException("Unexpected exception", te);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Method is unexpectedly inaccessible");
            }
        }

        boolean hasReadResolve() {
            return this.readResolve != null;
        }

        Object callReadResolve(Object object) throws ObjectStreamException {
            try {
                return this.readResolve.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof ObjectStreamException) {
                    throw (ObjectStreamException)te;
                }
                if (te instanceof RuntimeException) {
                    throw (RuntimeException)te;
                }
                if (te instanceof Error) {
                    throw (Error)te;
                }
                throw new IllegalStateException("Unexpected exception", te);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Method is unexpectedly inaccessible");
            }
        }

        Constructor<?> getNoArgConstructor() {
            return this.noArgConstructor;
        }

        Constructor<?> getObjectInputConstructor() {
            return this.objectInputConstructor;
        }
    }
}

