/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weibo.util;

import com.jeecg.weibo.dto.WeiboFollowersDto;
import com.jeecg.weibo.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;

public class WeiboFollowersUtil {
    public static void getFollowersParmValidate(WeiboFollowersDto followers) {
        if (StringUtils.isEmpty((CharSequence)followers.getAccess_token())) {
            throw new BusinessException("access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)followers.getUid()) && StringUtils.isEmpty((CharSequence)followers.getScreen_name())) {
            throw new BusinessException("uid\u4e0escreen_name\u4e8c\u8005\u4e0d\u80fd\u5168\u4e3a\u7a7a");
        }
    }

    public static String getFollowersUrl(String interUrl, WeiboFollowersDto followers) {
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(interUrl);
        if (StringUtils.isNotEmpty((CharSequence)followers.getAccess_token())) {
            requestUrl.append("&access_token=" + followers.getAccess_token());
        }
        if (StringUtils.isNotEmpty((CharSequence)followers.getUid())) {
            requestUrl.append("&uid=" + followers.getUid());
        }
        if (StringUtils.isNotEmpty((CharSequence)followers.getScreen_name())) {
            requestUrl.append("&screen_name=" + followers.getScreen_name());
        }
        if (StringUtils.isNotEmpty((CharSequence)followers.getCount())) {
            requestUrl.append("&count=" + followers.getCount());
        }
        if (StringUtils.isNotEmpty((CharSequence)followers.getCursor())) {
            requestUrl.append("&cursor=" + followers.getCursor());
        }
        if (StringUtils.isNotEmpty((CharSequence)followers.getTrim_status())) {
            requestUrl.append("&trim_status=" + followers.getTrim_status());
        }
        return requestUrl.toString();
    }

    public static void getFollowersIdsParmValidate(WeiboFollowersDto followers) {
        if (StringUtils.isEmpty((CharSequence)followers.getAccess_token())) {
            throw new BusinessException("access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static String getFollowersIdsUrl(String interUrl, WeiboFollowersDto followers) {
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(interUrl);
        if (StringUtils.isNotEmpty((CharSequence)followers.getAccess_token())) {
            requestUrl.append("&access_token=" + followers.getAccess_token());
        }
        if (StringUtils.isNotEmpty((CharSequence)followers.getUid())) {
            requestUrl.append("&uid=" + followers.getUid());
        }
        if (StringUtils.isNotEmpty((CharSequence)followers.getScreen_name())) {
            requestUrl.append("&screen_name=" + followers.getScreen_name());
        }
        if (StringUtils.isNotEmpty((CharSequence)followers.getCount())) {
            requestUrl.append("&count=" + followers.getCount());
        }
        if (StringUtils.isNotEmpty((CharSequence)followers.getCursor())) {
            requestUrl.append("&cursor=" + followers.getCursor());
        }
        return requestUrl.toString();
    }
}

